/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step1;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.step1.BaseLayeringOperation;
import vg.lib.layout.hierarchical.step1.CustomLayeringOperation;
import vg.lib.layout.hierarchical.step1.data.LayeringOperationResult;
import vg.lib.operation.Operation;

public class FineTuningLayeringOperation
extends BaseLayeringOperation
implements Operation<LayeringOperationResult> {
    private static final Logger log = LoggerFactory.getLogger(FineTuningLayeringOperation.class);
    private final CustomLayeringOperation customLayeringOperation;

    public FineTuningLayeringOperation(List<UUID> vertices, List<UUID> inputPorts, List<UUID> outputPorts, Map<UUID, Map.Entry<UUID, UUID>> edgeToNodes) {
        super(vertices, inputPorts, outputPorts, edgeToNodes, Collections.emptyMap());
        this.customLayeringOperation = new CustomLayeringOperation(vertices, inputPorts, outputPorts, edgeToNodes, Collections.emptyMap());
    }

    @Override
    public LayeringOperationResult execute() {
        int i;
        int rootIndex;
        int[][] adjacencyMatrix = new int[this.numberOfVertices][this.numberOfVertices];
        for (int i2 = 0; i2 < this.numberOfVertices; ++i2) {
            Arrays.fill(adjacencyMatrix[i2], 0);
        }
        for (Map.Entry nodes : this.edgeIdToNodeIds.values()) {
            int srcIndex = (Integer)this.vertexIdToIndex.get(nodes.getKey());
            int trgIndex = (Integer)this.vertexIdToIndex.get(nodes.getValue());
            if (this.inputPorts[srcIndex] || this.outputPorts[srcIndex] || this.inputPorts[trgIndex] || this.outputPorts[trgIndex]) continue;
            int[] nArray = adjacencyMatrix[srcIndex];
            int n = trgIndex;
            nArray[n] = nArray[n] + 1;
        }
        boolean[] _used = new boolean[this.numberOfVertices];
        int[] _colors = new int[this.numberOfVertices];
        int[] _stack = new int[this.numberOfVertices];
        for (int i3 = 0; i3 < this.numberOfVertices; ++i3) {
            if (!this.inputPorts[i3] && !this.outputPorts[i3]) continue;
            _used[i3] = true;
        }
        int[] vertexToInput = this.calcVertexToInput(this.numberOfVertices, adjacencyMatrix);
        int rootAmount = 0;
        while ((rootIndex = this.findNextRoot(this.numberOfVertices, adjacencyMatrix, vertexToInput, _used)) >= 0) {
            this.doDFS(adjacencyMatrix, this.numberOfVertices, rootIndex, _used, _colors, _stack);
            log.debug(String.format("Amount of handled roots = %s. Last root index = %s.", rootAmount, rootIndex));
            ++rootAmount;
        }
        boolean[] coreTree = new boolean[this.numberOfVertices];
        int[] levels = new int[this.numberOfVertices];
        this.fromTopToBottom(coreTree, levels, adjacencyMatrix, this.numberOfVertices);
        this.buildCoreTree(coreTree, levels, adjacencyMatrix, this.numberOfVertices, true);
        boolean[] partOfCoreTree = new boolean[coreTree.length];
        System.arraycopy(coreTree, 0, partOfCoreTree, 0, coreTree.length);
        for (i = 0; i < 5; ++i) {
            this.fromBottomToTop(coreTree, levels, adjacencyMatrix, this.numberOfVertices);
            this.buildCoreTree(coreTree, levels, adjacencyMatrix, this.numberOfVertices, false);
            this.fromTopToBottom(coreTree, levels, adjacencyMatrix, this.numberOfVertices);
            this.buildCoreTree(coreTree, levels, adjacencyMatrix, this.numberOfVertices, false);
        }
        for (i = 0; i < levels.length; ++i) {
            if (this.inputPorts[i]) {
                levels[i] = Integer.MIN_VALUE;
            }
            if (!this.outputPorts[i]) continue;
            levels[i] = Integer.MAX_VALUE;
        }
        boolean check = true;
        block6: while (check) {
            check = false;
            for (int i4 = 0; i4 < levels.length; ++i4) {
                if (levels[i4] == Integer.MAX_VALUE || levels[i4] == Integer.MIN_VALUE) continue;
                int maxInput = Integer.MIN_VALUE;
                int inCount = 0;
                int minOutput = Integer.MAX_VALUE;
                int outCount = 0;
                for (int j = 0; j < levels.length; ++j) {
                    if (levels[j] == Integer.MAX_VALUE || levels[j] == Integer.MIN_VALUE) continue;
                    if (adjacencyMatrix[j][i4] > 0) {
                        inCount += adjacencyMatrix[j][i4];
                        if (levels[j] > maxInput) {
                            maxInput = levels[j];
                        }
                    }
                    if (adjacencyMatrix[i4][j] <= 0) continue;
                    outCount += adjacencyMatrix[i4][j];
                    if (levels[j] >= minOutput) continue;
                    minOutput = levels[j];
                }
                int level = levels[i4];
                if (maxInput == Integer.MIN_VALUE && minOutput != Integer.MAX_VALUE) {
                    if (level == minOutput - 1) continue;
                    levels[i4] = minOutput - 1;
                    check = true;
                    continue block6;
                }
                if (maxInput != Integer.MIN_VALUE && minOutput == Integer.MAX_VALUE) {
                    if (level == maxInput + 1) continue;
                    levels[i4] = maxInput + 1;
                    check = true;
                    continue block6;
                }
                Validate.isTrue((maxInput < level ? 1 : 0) != 0);
                Validate.isTrue((minOutput > level ? 1 : 0) != 0);
                if (maxInput == level - 1 && minOutput == level + 1) continue;
                int up = inCount + (minOutput - maxInput) * outCount;
                int down = outCount + (minOutput - maxInput) * inCount;
                if (maxInput != level - 1 && up < down) {
                    levels[i4] = maxInput + 1;
                    check = true;
                    continue block6;
                }
                if (minOutput == level + 1 || up <= down) continue;
                levels[i4] = minOutput - 1;
                check = true;
                continue block6;
            }
        }
        LayeringOperationResult re = this.customLayeringOperation.execute();
        return new LayeringOperationResult(this.numberOfVertices, this.vertexToId, this.inputPorts, this.outputPorts, partOfCoreTree, null, null, levels, null, re.vertexIndexToGroupId);
    }

    private int[] calcVertexToInput(int amountOfVertices, int[][] adjacencyMatrix) {
        int i;
        int[] vertexToIn = new int[amountOfVertices];
        Arrays.fill(vertexToIn, -1);
        boolean vertexToInCount = false;
        for (i = 0; i < amountOfVertices; ++i) {
            if (this.inputPorts[i] || this.outputPorts[i]) continue;
            vertexToIn[i] = 0;
        }
        for (i = 0; i < amountOfVertices; ++i) {
            if (vertexToIn[i] < 0) continue;
            for (int j = 0; j < amountOfVertices; ++j) {
                if (adjacencyMatrix[j][i] <= 0) continue;
                int n = i;
                vertexToIn[n] = vertexToIn[n] + adjacencyMatrix[j][i];
            }
        }
        return vertexToIn;
    }

    private int findNextRoot(int amountOfVertices, int[][] adjacencyMatrix, int[] vertexToInput, boolean[] used) {
        int i;
        int min = Integer.MAX_VALUE;
        int minIndex = -1;
        for (i = 0; i < amountOfVertices; ++i) {
            if (used[i] || vertexToInput[i] < 0 || min <= vertexToInput[i]) continue;
            min = vertexToInput[i];
            minIndex = i;
        }
        if (min == 0 || min == Integer.MAX_VALUE) {
            return minIndex;
        }
        for (i = 0; i < amountOfVertices; ++i) {
            if (vertexToInput[i] != min) continue;
            for (int j = 0; j < amountOfVertices; ++j) {
                if (adjacencyMatrix[j][i] <= 0 || !this.inputPorts[j]) continue;
                return i;
            }
        }
        return minIndex;
    }

    private void fromBottomToTop(boolean[] coreTree, int[] levels, int[][] adjacencyMatrix, int count) {
        int i;
        boolean check;
        int maxLevel = Arrays.stream(levels).max().orElse(0);
        for (int i2 = 0; i2 < count; ++i2) {
            if (coreTree[i2]) continue;
            levels[i2] = maxLevel;
        }
        do {
            check = false;
            for (i = 0; i < count; ++i) {
                for (int j = 0; j < count; ++j) {
                    if (adjacencyMatrix[i][j] <= 0 || coreTree[i] || levels[i] < levels[j]) continue;
                    levels[i] = levels[j] - 1;
                    check = true;
                }
            }
        } while (check);
        int min = Arrays.stream(levels).min().orElse(0);
        i = 0;
        while (i < levels.length) {
            int n = i++;
            levels[n] = levels[n] - min;
        }
    }

    private boolean[] buildCoreTree(boolean[] coreTree, int[] levels, int[][] adjacencyMatrix, int count, boolean fillCoreTree) {
        int maxLevel;
        int currLevel = maxLevel = Arrays.stream(levels).max().orElse(0);
        if (fillCoreTree) {
            for (int j = 0; j < count; ++j) {
                if (levels[j] != maxLevel) continue;
                coreTree[j] = true;
            }
        }
        int idle = 0;
        boolean direction = false;
        boolean idleCheck = false;
        while (idle < 10) {
            block2: for (int j = 0; j < count; ++j) {
                if (levels[j] != currLevel) continue;
                for (int i = 0; i < count; ++i) {
                    if (adjacencyMatrix[i][j] <= 0 || levels[i] != currLevel - 1 || !coreTree[i] && !coreTree[j] || !coreTree[i] && !coreTree[j] || coreTree[i] && coreTree[j]) continue;
                    coreTree[i] = true;
                    coreTree[j] = true;
                    idleCheck = true;
                    continue block2;
                }
            }
            currLevel = !direction ? --currLevel : ++currLevel;
            if (currLevel < 0) {
                if (!idleCheck) {
                    ++idle;
                }
                direction = true;
                idleCheck = false;
            }
            if (currLevel <= maxLevel) continue;
            if (!idleCheck) {
                ++idle;
            }
            direction = false;
            idleCheck = false;
        }
        return coreTree;
    }

    private void fromTopToBottom(boolean[] coreTree, int[] levels, int[][] adjacencyMatrix, int count) {
        int i;
        boolean check;
        for (int i2 = 0; i2 < count; ++i2) {
            if (coreTree[i2]) continue;
            levels[i2] = 0;
        }
        do {
            check = false;
            for (i = 0; i < count; ++i) {
                for (int j = 0; j < count; ++j) {
                    if (adjacencyMatrix[i][j] <= 0 || coreTree[j] || levels[i] < levels[j]) continue;
                    levels[j] = levels[i] + 1;
                    check = true;
                }
            }
        } while (check);
        int min = Arrays.stream(levels).min().orElse(0);
        i = 0;
        while (i < levels.length) {
            int n = i++;
            levels[n] = levels[n] - min;
        }
    }

    private void doDFS(int[][] adjacencyMatrix, int amountOfVertices, int startIndex, boolean[] _used, int[] _colors, int[] _stack) {
        int NO_COLOR = 0;
        int COLOR_GREY = 1;
        int COLOR_BLACK = 2;
        int stackCount = 0;
        _stack[stackCount++] = startIndex;
        while (stackCount > 0) {
            int vertexIndex = _stack[stackCount - 1];
            _colors[vertexIndex] = COLOR_GREY;
            _used[vertexIndex] = true;
            boolean check = true;
            for (int i = 0; i < amountOfVertices; ++i) {
                if (adjacencyMatrix[vertexIndex][i] <= 0) continue;
                int color = _colors[i];
                if (color == NO_COLOR) {
                    _stack[stackCount++] = i;
                    check = false;
                    break;
                }
                if (color != COLOR_GREY) continue;
                adjacencyMatrix[vertexIndex][i] = 0;
            }
            if (!check) continue;
            _colors[_stack[--stackCount]] = COLOR_BLACK;
        }
    }
}

