/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step1;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.step1.BaseLayeringOperation;
import vg.lib.layout.hierarchical.step1.data.LayeringOperationResult;
import vg.lib.operation.Operation;

public class CustomLayeringOperation
extends BaseLayeringOperation
implements Operation<LayeringOperationResult> {
    private static final Logger log = LoggerFactory.getLogger(CustomLayeringOperation.class);
    private static final int NO_COLOR = 0;
    private static final int COLOR_GREY = 1;
    private static final int COLOR_BLACK = 2;
    protected final int[] inputPortIndices;
    protected final int[] outputPortIndices;
    protected final int[] sortedInputPortIndices;
    protected final int[] sortedOutputPortIndices;
    protected final int[] vertexIndexToLayerBeforeMerge;
    protected final int[] vertexIndexToLayerAfterMerge;
    protected final int[] vertexIndexToLayer;
    protected final int[] vertexIndexToGroupIdBeforeMerge;
    protected final int[] vertexIndexToGroupId;

    public CustomLayeringOperation(List<UUID> vertices, List<UUID> inputPorts, List<UUID> outputPorts, Map<UUID, Map.Entry<UUID, UUID>> edgeIdToNodeIds, Map<UUID, Integer> portIdToSpecifiedOrder) {
        super(vertices, inputPorts, outputPorts, edgeIdToNodeIds, portIdToSpecifiedOrder);
        int[][] re = CustomLayeringOperation.convertToSortedVertexIndices(inputPorts, this.vertexToId, this.vertexIdToIndex, portIdToSpecifiedOrder);
        this.sortedInputPortIndices = re[0];
        this.inputPortIndices = re[1];
        re = CustomLayeringOperation.convertToSortedVertexIndices(outputPorts, this.vertexToId, this.vertexIdToIndex, portIdToSpecifiedOrder);
        this.sortedOutputPortIndices = re[0];
        this.outputPortIndices = re[1];
        this.vertexIndexToLayerBeforeMerge = new int[this.numberOfVertices];
        this.vertexIndexToLayerAfterMerge = new int[this.numberOfVertices];
        this.vertexIndexToLayer = new int[this.numberOfVertices];
        Arrays.fill(this.vertexIndexToLayer, -1);
        this.vertexIndexToGroupIdBeforeMerge = new int[this.numberOfVertices];
        this.vertexIndexToGroupId = new int[this.numberOfVertices];
        Arrays.fill(this.vertexIndexToGroupId, -1);
    }

    @Override
    public LayeringOperationResult execute() {
        this.removeCycles();
        this.splitVerticesIntoGroups();
        System.arraycopy(this.vertexIndexToGroupId, 0, this.vertexIndexToGroupIdBeforeMerge, 0, this.vertexIndexToGroupId.length);
        System.arraycopy(this.vertexIndexToLayer, 0, this.vertexIndexToLayerBeforeMerge, 0, this.vertexIndexToLayer.length);
        this.mergeGroups();
        System.arraycopy(this.vertexIndexToLayer, 0, this.vertexIndexToLayerAfterMerge, 0, this.vertexIndexToLayer.length);
        this.normalizeGroups();
        this.reGroupViaSpecifiedOrderForPorts();
        return new LayeringOperationResult(this.numberOfVertices, this.vertexToId, this.inputPorts, this.outputPorts, new boolean[this.numberOfVertices], this.vertexIndexToLayerBeforeMerge, this.vertexIndexToLayerAfterMerge, this.vertexIndexToLayer, this.vertexIndexToGroupIdBeforeMerge, this.vertexIndexToGroupId);
    }

    private void removeCycles() {
        int rootIndex;
        boolean[] vertexIndexToIsUsed = new boolean[this.numberOfVertices];
        int[] _colors = new int[this.numberOfVertices];
        int[] _stack = new int[this.numberOfVertices];
        while ((rootIndex = this.findNextRoot(vertexIndexToIsUsed)) >= 0) {
            int stackCount = 0;
            _stack[stackCount++] = rootIndex;
            while (stackCount > 0) {
                int vertexIndex = _stack[stackCount - 1];
                _colors[vertexIndex] = 1;
                vertexIndexToIsUsed[vertexIndex] = true;
                boolean check = true;
                for (int outputEdgeIndex : this.vertexIndexToOutputEdgeIndices[vertexIndex]) {
                    if (this.disabledEdges[outputEdgeIndex]) continue;
                    int trgVertexIndex = this.edgeIndexToTrgVertexIndex[outputEdgeIndex];
                    int color = _colors[trgVertexIndex];
                    if (color == 0) {
                        _stack[stackCount++] = trgVertexIndex;
                        check = false;
                        break;
                    }
                    if (color != 1) continue;
                    this.disabledEdges[outputEdgeIndex] = true;
                }
                if (!check) continue;
                _colors[_stack[--stackCount]] = 2;
            }
        }
    }

    private void splitVerticesIntoGroups() {
        int rootVertexIndex;
        int[] _stack = new int[this.numberOfVertices];
        boolean[] vertexIndexToIsUsed = new boolean[this.numberOfVertices];
        boolean[] edgeIndexToIsUsed = new boolean[this.numberOfEdges];
        int groupIdCounter = 0;
        while ((rootVertexIndex = this.findNextRoot(vertexIndexToIsUsed)) >= 0) {
            this.setLayerIfPossibleDFS(rootVertexIndex, groupIdCounter++, vertexIndexToIsUsed, edgeIndexToIsUsed, _stack, 0);
        }
    }

    private void mergeGroups() {
        int[] _stack = new int[this.numberOfVertices];
        boolean[] vertexIndexToIsUsed = new boolean[this.numberOfVertices];
        Arrays.fill(vertexIndexToIsUsed, true);
        boolean[] edgeIndexToIsUsed = new boolean[this.numberOfEdges];
        Arrays.fill(edgeIndexToIsUsed, true);
        int[] _stackOfEdgeIndices = new int[this.numberOfEdges];
        int stackCount = 0;
        for (int edgeIndex1 = 0; edgeIndex1 < this.numberOfEdges; ++edgeIndex1) {
            int trgVertexIndex1;
            int trgVertexGroupId1;
            int srcVertexIndex1;
            int srcVertexGroupId1;
            if (this.disabledEdges[edgeIndex1] || (srcVertexGroupId1 = this.vertexIndexToGroupId[srcVertexIndex1 = this.edgeIndexToSrcVertexIndex[edgeIndex1]]) == (trgVertexGroupId1 = this.vertexIndexToGroupId[trgVertexIndex1 = this.edgeIndexToTrgVertexIndex[edgeIndex1]])) continue;
            int maxSrcLayer = Integer.MIN_VALUE;
            int numberOfForwardEdges = 0;
            int numberOfBackwardEdges = 0;
            stackCount = 0;
            for (int edgeIndex2 = 0; edgeIndex2 < this.numberOfEdges; ++edgeIndex2) {
                if (this.disabledEdges[edgeIndex2]) continue;
                int srcVertexIndex2 = this.edgeIndexToSrcVertexIndex[edgeIndex2];
                int trgVertexIndex2 = this.edgeIndexToTrgVertexIndex[edgeIndex2];
                int srcVertexGroupId2 = this.vertexIndexToGroupId[srcVertexIndex2];
                int trgVertexGroupId2 = this.vertexIndexToGroupId[trgVertexIndex2];
                int srcVertexLayer2 = this.vertexIndexToLayer[srcVertexIndex2];
                if (srcVertexGroupId1 == srcVertexGroupId2 && trgVertexGroupId1 == trgVertexGroupId2) {
                    ++numberOfForwardEdges;
                    _stackOfEdgeIndices[stackCount++] = edgeIndex2;
                    if (srcVertexLayer2 > maxSrcLayer) {
                        maxSrcLayer = srcVertexLayer2;
                    }
                }
                if (srcVertexGroupId1 != trgVertexGroupId2 || trgVertexGroupId1 != srcVertexGroupId2) continue;
                ++numberOfBackwardEdges;
            }
            if (numberOfForwardEdges < numberOfBackwardEdges) continue;
            int bestShift = this.calcBestShift(_stackOfEdgeIndices, stackCount, maxSrcLayer);
            this.shiftGroup(trgVertexGroupId1, bestShift);
            this.updateGroupId(trgVertexGroupId1, srcVertexGroupId1);
            if (numberOfBackwardEdges <= 0) continue;
            this.resolveBackwardEdgesAfterMerge(srcVertexGroupId1, vertexIndexToIsUsed, edgeIndexToIsUsed, _stack);
        }
    }

    private void resolveBackwardEdgesAfterMerge(int groupId, boolean[] vertexIndexToIsUsed, boolean[] edgeIndexToIsUsed, int[] _stack) {
        for (int edgeIndex = 0; edgeIndex < this.numberOfEdges; ++edgeIndex) {
            if (this.disabledEdges[edgeIndex]) continue;
            int srcVertexIndex = this.edgeIndexToSrcVertexIndex[edgeIndex];
            int trgVertexIndex = this.edgeIndexToTrgVertexIndex[edgeIndex];
            if (this.vertexIndexToGroupId[srcVertexIndex] != groupId || this.vertexIndexToGroupId[trgVertexIndex] != groupId || this.vertexIndexToLayer[srcVertexIndex] < this.vertexIndexToLayer[trgVertexIndex]) continue;
            this.unsetLayerIfPossibleDFS(trgVertexIndex, groupId, vertexIndexToIsUsed, edgeIndexToIsUsed, _stack);
            int maxLayer = this.findMaxLayer(trgVertexIndex, groupId, edgeIndexToIsUsed);
            Validate.isTrue((maxLayer != Integer.MIN_VALUE ? 1 : 0) != 0);
            this.setLayerIfPossibleDFS(trgVertexIndex, groupId, vertexIndexToIsUsed, edgeIndexToIsUsed, _stack, maxLayer + 1);
        }
    }

    private int calcBestShift(int[] edgeIndices, int size, int maxSrcLayer) {
        int UPPER_BOUND = 250;
        int LOWER_BOUND = -1000;
        int result = UPPER_BOUND;
        int shift = UPPER_BOUND;
        while (shift >= LOWER_BOUND) {
            boolean doesConditionViolated = false;
            for (int i = 0; i < size; ++i) {
                int edgeIndex = edgeIndices[i];
                int trgVertexIndex = this.edgeIndexToTrgVertexIndex[edgeIndex];
                int trgVertexLayer = this.vertexIndexToLayer[trgVertexIndex];
                int srcVertexIndex = this.edgeIndexToSrcVertexIndex[edgeIndex];
                int srcVertexLayer = this.vertexIndexToLayer[srcVertexIndex];
                int diff = shift + trgVertexLayer - srcVertexLayer;
                if (diff > 0) continue;
                doesConditionViolated = true;
                break;
            }
            if (doesConditionViolated) break;
            result = shift--;
        }
        return result;
    }

    private void normalizeGroups() {
        boolean hasInputPorts = this.inputPortIndices.length > 0;
        boolean hasOutputPorts = this.outputPortIndices.length > 0;
        boolean[] groupIdToHasInputPorts = new boolean[this.numberOfVertices];
        int[] groupIdToNonPortMinLayer = new int[this.numberOfVertices];
        int[] groupIdToNonPortMaxLayer = new int[this.numberOfVertices];
        Arrays.fill(groupIdToNonPortMinLayer, Integer.MAX_VALUE);
        Arrays.fill(groupIdToNonPortMaxLayer, Integer.MIN_VALUE);
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            int groupId = this.vertexIndexToGroupId[vertexIndex];
            int layer = this.vertexIndexToLayer[vertexIndex];
            if (!this.inputPorts[vertexIndex] && !this.outputPorts[vertexIndex] && layer < groupIdToNonPortMinLayer[groupId]) {
                groupIdToNonPortMinLayer[groupId] = layer;
            }
            if (!this.inputPorts[vertexIndex] && !this.outputPorts[vertexIndex] && layer > groupIdToNonPortMaxLayer[groupId]) {
                groupIdToNonPortMaxLayer[groupId] = layer;
            }
            if (!this.inputPorts[vertexIndex]) continue;
            groupIdToHasInputPorts[groupId] = true;
        }
        int[] groupIdToTopLayer = new int[this.numberOfVertices];
        Arrays.fill(groupIdToTopLayer, Integer.MAX_VALUE);
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            int groupId = this.vertexIndexToGroupId[vertexIndex];
            if (this.inputPorts[vertexIndex]) {
                this.vertexIndexToLayer[vertexIndex] = groupIdToNonPortMinLayer[groupId] != Integer.MAX_VALUE ? groupIdToNonPortMinLayer[groupId] - 1 : 0;
            }
            if (this.outputPorts[vertexIndex]) {
                this.vertexIndexToLayer[vertexIndex] = groupIdToNonPortMaxLayer[groupId] != Integer.MIN_VALUE ? groupIdToNonPortMaxLayer[groupId] + 1 : 1;
            }
            if (this.vertexIndexToLayer[vertexIndex] >= groupIdToTopLayer[groupId]) continue;
            groupIdToTopLayer[groupId] = this.vertexIndexToLayer[vertexIndex];
        }
        int nonPortsMaxLayer = Integer.MIN_VALUE;
        int outputPortsLayer = 1;
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            int groupId = this.vertexIndexToGroupId[vertexIndex];
            int n = vertexIndex;
            this.vertexIndexToLayer[n] = this.vertexIndexToLayer[n] - groupIdToTopLayer[groupId];
            if (hasInputPorts && !groupIdToHasInputPorts[groupId]) {
                int n2 = vertexIndex;
                this.vertexIndexToLayer[n2] = this.vertexIndexToLayer[n2] + 1;
            }
            if (this.outputPorts[vertexIndex] && this.vertexIndexToLayer[vertexIndex] > outputPortsLayer) {
                outputPortsLayer = this.vertexIndexToLayer[vertexIndex];
            }
            if (this.inputPorts[vertexIndex] || this.outputPorts[vertexIndex] || this.vertexIndexToLayer[vertexIndex] <= nonPortsMaxLayer) continue;
            nonPortsMaxLayer = this.vertexIndexToLayer[vertexIndex];
        }
        if (outputPortsLayer <= nonPortsMaxLayer) {
            outputPortsLayer = nonPortsMaxLayer + 1;
        }
        int[] groupIdToNumberOfEdgesBetweenInputPorts = new int[this.numberOfVertices];
        int[] groupIdToNumberOfEdgesBetweenOutputPorts = new int[this.numberOfVertices];
        int[] groupIdToMinLengthToOutputPorts = new int[this.numberOfVertices];
        Arrays.fill(groupIdToMinLengthToOutputPorts, Integer.MAX_VALUE);
        for (int edgeIndex = 0; edgeIndex < this.numberOfEdges; ++edgeIndex) {
            int length;
            int srcVertexIndex = this.edgeIndexToSrcVertexIndex[edgeIndex];
            int trgVertexIndex = this.edgeIndexToTrgVertexIndex[edgeIndex];
            assert (this.vertexIndexToGroupId[srcVertexIndex] == this.vertexIndexToGroupId[trgVertexIndex]);
            int groupId = this.vertexIndexToGroupId[srcVertexIndex];
            if (this.inputPorts[srcVertexIndex] && !this.outputPorts[trgVertexIndex]) {
                int n = groupId;
                groupIdToNumberOfEdgesBetweenInputPorts[n] = groupIdToNumberOfEdgesBetweenInputPorts[n] + 1;
            }
            if (!this.inputPorts[srcVertexIndex] && this.outputPorts[trgVertexIndex]) {
                int n = groupId;
                groupIdToNumberOfEdgesBetweenOutputPorts[n] = groupIdToNumberOfEdgesBetweenOutputPorts[n] + 1;
            }
            if (!this.inputPorts[srcVertexIndex] && (length = outputPortsLayer - this.vertexIndexToLayer[srcVertexIndex]) < groupIdToMinLengthToOutputPorts[groupId]) {
                groupIdToMinLengthToOutputPorts[groupId] = length;
            }
            if (this.outputPorts[trgVertexIndex] || (length = outputPortsLayer - this.vertexIndexToLayer[trgVertexIndex]) >= groupIdToMinLengthToOutputPorts[groupId]) continue;
            groupIdToMinLengthToOutputPorts[groupId] = length;
        }
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            int groupId = this.vertexIndexToGroupId[vertexIndex];
            if (!hasOutputPorts || this.inputPorts[vertexIndex]) continue;
            if (this.outputPorts[vertexIndex]) {
                this.vertexIndexToLayer[vertexIndex] = outputPortsLayer;
                continue;
            }
            if (groupIdToNumberOfEdgesBetweenInputPorts[groupId] >= groupIdToNumberOfEdgesBetweenOutputPorts[groupId]) continue;
            int n = vertexIndex;
            this.vertexIndexToLayer[n] = this.vertexIndexToLayer[n] + (groupIdToMinLengthToOutputPorts[groupId] - 1);
        }
    }

    private void shiftGroup(int groupId, int shift) {
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            if (this.vertexIndexToGroupId[vertexIndex] != groupId) continue;
            int n = vertexIndex;
            this.vertexIndexToLayer[n] = this.vertexIndexToLayer[n] + shift;
        }
    }

    private void updateGroupId(int oldGroupId, int newGroupId) {
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            if (this.vertexIndexToGroupId[vertexIndex] != oldGroupId) continue;
            this.vertexIndexToGroupId[vertexIndex] = newGroupId;
        }
    }

    private int findNextRoot(boolean[] vertexIndexToIsUsed) {
        int minNumberOfInputEdgeIndices = Integer.MAX_VALUE;
        int maxNumberOfOutputEdgeIndices = Integer.MIN_VALUE;
        int moreSuitableTopVertexIndex = -1;
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            if (vertexIndexToIsUsed[vertexIndex]) continue;
            int numberOfInputEdgeIndices = 0;
            for (int edgeId : this.vertexIndexToInputEdgeIndices[vertexIndex]) {
                if (this.disabledEdges[edgeId]) continue;
                ++numberOfInputEdgeIndices;
            }
            int numberOfOutputEdgeIndices = 0;
            for (int edgeId : this.vertexIndexToOutputEdgeIndices[vertexIndex]) {
                if (this.disabledEdges[edgeId]) continue;
                ++numberOfOutputEdgeIndices;
            }
            if (numberOfInputEdgeIndices > minNumberOfInputEdgeIndices || numberOfInputEdgeIndices >= minNumberOfInputEdgeIndices && maxNumberOfOutputEdgeIndices >= numberOfOutputEdgeIndices) continue;
            minNumberOfInputEdgeIndices = numberOfInputEdgeIndices;
            maxNumberOfOutputEdgeIndices = numberOfOutputEdgeIndices;
            moreSuitableTopVertexIndex = vertexIndex;
        }
        return moreSuitableTopVertexIndex;
    }

    private void unsetLayerIfPossibleDFS(int startIndex, int groupId, boolean[] vertexIndexToIsUsed, boolean[] edgeIndexToIsUsed, int[] _stack) {
        int stackCount = 0;
        _stack[stackCount++] = startIndex;
        while (stackCount > 0) {
            int vertexIndex = _stack[--stackCount];
            vertexIndexToIsUsed[vertexIndex] = false;
            for (int outputEdgeIndex : this.vertexIndexToOutputEdgeIndices[vertexIndex]) {
                int trgVertexIndex;
                if (this.disabledEdges[outputEdgeIndex] || this.vertexIndexToGroupId[trgVertexIndex = this.edgeIndexToTrgVertexIndex[outputEdgeIndex]] != groupId) continue;
                edgeIndexToIsUsed[outputEdgeIndex] = false;
                if (!vertexIndexToIsUsed[trgVertexIndex]) continue;
                _stack[stackCount++] = trgVertexIndex;
            }
        }
    }

    private void setLayerIfPossibleDFS(int startIndex, int groupId, boolean[] vertexIndexToIsUsed, boolean[] edgeIndexToIsUsed, int[] _stack, int startLayer) {
        this.vertexIndexToLayer[startIndex] = startLayer;
        int stackCount = 0;
        _stack[stackCount++] = startIndex;
        while (stackCount > 0) {
            int vertexIndex = _stack[--stackCount];
            vertexIndexToIsUsed[vertexIndex] = true;
            this.vertexIndexToGroupId[vertexIndex] = groupId;
            for (int outputEdgeIndex : this.vertexIndexToOutputEdgeIndices[vertexIndex]) {
                int maxLayer;
                int trgVertexIndex;
                edgeIndexToIsUsed[outputEdgeIndex] = true;
                if (this.disabledEdges[outputEdgeIndex] || vertexIndexToIsUsed[trgVertexIndex = this.edgeIndexToTrgVertexIndex[outputEdgeIndex]] || (maxLayer = this.findMaxLayer(trgVertexIndex, groupId, edgeIndexToIsUsed)) < 0) continue;
                this.vertexIndexToLayer[trgVertexIndex] = maxLayer + 1;
                _stack[stackCount++] = trgVertexIndex;
            }
        }
    }

    private int findMaxLayer(int vertexIndex, int groupId, boolean[] edgeIndexToIsUsed) {
        int maxLayer = Integer.MIN_VALUE;
        for (int inputEdgeIndex : this.vertexIndexToInputEdgeIndices[vertexIndex]) {
            if (this.disabledEdges[inputEdgeIndex] || edgeIndexToIsUsed[inputEdgeIndex]) {
                int srcVertexLayer;
                int srcVertexIndex = this.edgeIndexToSrcVertexIndex[inputEdgeIndex];
                int srcVertexGroupId = this.vertexIndexToGroupId[srcVertexIndex];
                if (groupId != srcVertexGroupId || (srcVertexLayer = this.vertexIndexToLayer[srcVertexIndex]) <= maxLayer) continue;
                maxLayer = srcVertexLayer;
                continue;
            }
            maxLayer = -1;
            break;
        }
        return maxLayer;
    }

    private void reGroupViaSpecifiedOrderForPorts() {
        int groupId;
        int vertexIndex;
        int groupId2;
        int[] groupIdToSuperGroupId = new int[this.numberOfVertices];
        Arrays.fill(groupIdToSuperGroupId, -1);
        for (int sortedInputPortIndex : this.sortedInputPortIndices) {
            groupId2 = this.vertexIndexToGroupId[sortedInputPortIndex];
            groupIdToSuperGroupId[groupId2] = 0;
        }
        for (int sortedOutputPortIndex : this.sortedOutputPortIndices) {
            groupId2 = this.vertexIndexToGroupId[sortedOutputPortIndex];
            groupIdToSuperGroupId[groupId2] = 0;
        }
        int superGroupIdCounter = 2;
        for (vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            groupId = this.vertexIndexToGroupId[vertexIndex];
            if (groupIdToSuperGroupId[groupId] != -1) continue;
            groupIdToSuperGroupId[groupId] = this.inputPorts[vertexIndex] || this.outputPorts[vertexIndex] ? 1 : superGroupIdCounter++;
        }
        for (vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            groupId = this.vertexIndexToGroupId[vertexIndex];
            this.vertexIndexToGroupId[vertexIndex] = groupIdToSuperGroupId[groupId];
        }
    }

    private static int[][] convertToSortedVertexIndices(List<UUID> vertexIds, UUID[] vertexIndexToId, Map<UUID, Integer> vertexIdToIndex, Map<UUID, Integer> vertexIdToSpecifiedOrder) {
        int[] result = new int[vertexIds.size()];
        int index = 0;
        for (UUID vertexId : vertexIds) {
            if (!vertexIdToSpecifiedOrder.containsKey(vertexId)) continue;
            Integer vertexIndex = vertexIdToIndex.get(vertexId);
            result[index] = vertexIndex;
            ++index;
        }
        CustomLayeringOperation.sortVertexIndexToIdViaSpecifiedOrder(result, index, vertexIndexToId, vertexIdToSpecifiedOrder);
        int[] sortedVertexIndices = Arrays.copyOfRange(result, 0, index);
        for (UUID vertexId : vertexIds) {
            if (vertexIdToSpecifiedOrder.containsKey(vertexId)) continue;
            Integer vertexIndex = vertexIdToIndex.get(vertexId);
            result[index] = vertexIndex;
            ++index;
        }
        return new int[][]{sortedVertexIndices, result};
    }

    private static void sortVertexIndexToIdViaSpecifiedOrder(int[] vertexOrderToIndex, int size, UUID[] vertexIndexToId, Map<UUID, Integer> vertexIdToSpecifiedOrder) {
        for (int vertexOrder1 = 0; vertexOrder1 < size; ++vertexOrder1) {
            int vertexIndex1 = vertexOrderToIndex[vertexOrder1];
            UUID vertexId1 = vertexIndexToId[vertexIndex1];
            Integer specifiedVertexOrder1 = vertexIdToSpecifiedOrder.getOrDefault(vertexId1, -1);
            if (specifiedVertexOrder1 < 0) continue;
            for (int vertexOrder2 = vertexOrder1 + 1; vertexOrder2 < size; ++vertexOrder2) {
                int vertexIndex2 = vertexOrderToIndex[vertexOrder2];
                UUID vertexId2 = vertexIndexToId[vertexIndex2];
                Integer specifiedVertexOrder2 = vertexIdToSpecifiedOrder.getOrDefault(vertexId2, -1);
                if (specifiedVertexOrder2 < 0 || vertexOrder1 < vertexOrder2 && specifiedVertexOrder1 < specifiedVertexOrder2 || vertexOrder2 < vertexOrder1 && specifiedVertexOrder2 < specifiedVertexOrder1) continue;
                vertexOrderToIndex[vertexOrder1] = vertexIndex2;
                vertexOrderToIndex[vertexOrder2] = vertexIndex1;
            }
        }
    }
}

