/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step1;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.operation.Procedure;

public class CalcEdgeLevelGroupProcedure
implements Procedure {
    private final HierarchicalGraph graph;

    public CalcEdgeLevelGroupProcedure(HierarchicalGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute() {
        int lastLevelGroupId = 1;
        int[] levelGroupIds = new int[this.graph.getVertices().size()];
        Arrays.fill(levelGroupIds, -1);
        for (int rowIndex = this.graph.getStartLevelOfGraphWithInputPorts(); rowIndex <= this.graph.getFinishLevelOfGraphWithOutputPorts(); ++rowIndex) {
            List<HierarchicalVertex> row = this.graph.getRowByLevel(rowIndex);
            for (HierarchicalVertex vertex : row) {
                levelGroupIds[vertex.getIndex()] = -1;
            }
            for (HierarchicalVertex vertex : row) {
                int existedLevelGroupId;
                if (levelGroupIds[vertex.getIndex()] != -1) continue;
                levelGroupIds[vertex.getIndex()] = existedLevelGroupId = lastLevelGroupId++;
                Collection<HierarchicalVertex> parents = Collections.singletonList(vertex);
                boolean check = true;
                while (check) {
                    int levelGroupId;
                    check = false;
                    Collection<HierarchicalVertex> children = this.graph.getOutputVertices(parents).values();
                    for (HierarchicalVertex child : children) {
                        levelGroupId = levelGroupIds[child.getIndex()];
                        if (levelGroupId != -1) continue;
                        check = true;
                        levelGroupIds[child.getIndex()] = existedLevelGroupId;
                    }
                    parents = this.graph.getInputVertices(children).values();
                    for (HierarchicalVertex parent : parents) {
                        levelGroupId = levelGroupIds[parent.getIndex()];
                        if (levelGroupId != -1) continue;
                        check = true;
                        levelGroupIds[parent.getIndex()] = existedLevelGroupId;
                    }
                }
            }
            for (HierarchicalEdge edge : this.graph.getOutputEdges(row)) {
                int trgLevelGroupId;
                HierarchicalVertex srcVertex = edge.getSrcVertex();
                HierarchicalVertex trgVertex = edge.getTrgVertex();
                int srcLevelGroupId = levelGroupIds[srcVertex.getIndex()];
                Validate.isTrue((srcLevelGroupId == (trgLevelGroupId = levelGroupIds[trgVertex.getIndex()]) ? 1 : 0) != 0);
                srcVertex.bottomLevelGroupId = edge.levelGroupId = srcLevelGroupId;
                trgVertex.topLevelGroupId = edge.levelGroupId;
            }
        }
        HashSet<Integer> topLevelGroupIds = new HashSet<Integer>();
        HashSet<Integer> bottomLevelGroupIds = new HashSet<Integer>();
        for (HierarchicalVertex v : this.graph.getVertices()) {
            if (v.topLevelGroupId == -1) {
                v.topLevelGroupId = v.bottomLevelGroupId;
            }
            if (v.bottomLevelGroupId == -1) {
                v.bottomLevelGroupId = v.topLevelGroupId;
            }
            if (v.getInputEdges().isEmpty() && v.getOutputEdges().isEmpty()) {
                Validate.isTrue((v.topLevelGroupId == -1 ? 1 : 0) != 0);
                Validate.isTrue((v.bottomLevelGroupId == -1 ? 1 : 0) != 0);
            } else {
                Validate.isTrue((v.topLevelGroupId != -1 ? 1 : 0) != 0);
                Validate.isTrue((v.bottomLevelGroupId != -1 ? 1 : 0) != 0);
            }
            topLevelGroupIds.add(v.topLevelGroupId);
            bottomLevelGroupIds.add(v.bottomLevelGroupId);
        }
        for (int rowIndex = this.graph.getStartLevelOfGraphWithInputPorts(); rowIndex <= this.graph.getFinishLevelOfGraphWithOutputPorts(); ++rowIndex) {
            int index;
            HashMap<HierarchicalVertex, Long> unsorted;
            List<HierarchicalVertex> row = this.graph.getRowByLevel(rowIndex);
            for (Integer levelGroupId : topLevelGroupIds) {
                unsorted = new HashMap<HierarchicalVertex, Long>();
                for (HierarchicalVertex vertex : row) {
                    if (vertex.topLevelGroupId != levelGroupId) continue;
                    unsorted.put(vertex, vertex.getImportance());
                }
                index = -1;
                long lastImp = -1L;
                for (Map.Entry e : unsorted.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toList())) {
                    if (lastImp != (Long)e.getValue()) {
                        lastImp = (Long)e.getValue();
                    }
                    ((HierarchicalVertex)e.getKey()).topLevelGroupP = ++index;
                }
            }
            for (Integer levelGroupId : bottomLevelGroupIds) {
                unsorted = new HashMap();
                for (HierarchicalVertex vertex : row) {
                    if (vertex.bottomLevelGroupId != levelGroupId) continue;
                    unsorted.put(vertex, vertex.getImportance());
                }
                index = -1;
                long lastImp = -1L;
                for (Map.Entry e : unsorted.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toList())) {
                    if (lastImp != (Long)e.getValue()) {
                        lastImp = (Long)e.getValue();
                    }
                    ((HierarchicalVertex)e.getKey()).bottomLevelGroupP = ++index;
                }
            }
        }
    }
}

