/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.step1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BaseLayeringOperation {
    protected final int numberOfVertices;
    protected final UUID[] vertexToId;
    protected final Map<UUID, Integer> vertexIdToIndex;
    protected final int numberOfEdges;
    protected final UUID[] edgeToId;
    protected final int[] edgeIndexToSrcVertexIndex;
    protected final int[] edgeIndexToTrgVertexIndex;
    protected final int[][] vertexIndexToInputEdgeIndices;
    protected final int[][] vertexIndexToOutputEdgeIndices;
    protected final boolean[] disabledEdges;
    protected final boolean[] inputPorts;
    protected final boolean[] outputPorts;
    protected boolean hasInputPorts;
    protected Map<UUID, Map.Entry<UUID, UUID>> edgeIdToNodeIds;
    protected Map<UUID, Integer> portIdToSpecifiedOrder;

    protected BaseLayeringOperation(List<UUID> vertices, List<UUID> inputPorts, List<UUID> outputPorts, Map<UUID, Map.Entry<UUID, UUID>> edgeIdToNodeIds, Map<UUID, Integer> portIdToSpecifiedOrder) {
        this.numberOfVertices = vertices.size();
        this.vertexToId = new UUID[this.numberOfVertices];
        this.vertexIdToIndex = new HashMap<UUID, Integer>();
        this.inputPorts = new boolean[this.numberOfVertices];
        this.outputPorts = new boolean[this.numberOfVertices];
        for (int i = 0; i < this.numberOfVertices; ++i) {
            UUID vertexId = vertices.get(i);
            if (inputPorts.contains(vertexId)) {
                this.inputPorts[i] = true;
                this.hasInputPorts = true;
            }
            if (outputPorts.contains(vertexId)) {
                this.outputPorts[i] = true;
            }
            this.vertexToId[i] = vertexId;
            this.vertexIdToIndex.put(vertexId, i);
        }
        this.numberOfEdges = edgeIdToNodeIds.size();
        this.edgeToId = new UUID[this.numberOfEdges];
        this.disabledEdges = new boolean[this.numberOfEdges];
        this.edgeIndexToSrcVertexIndex = new int[this.numberOfEdges];
        this.edgeIndexToTrgVertexIndex = new int[this.numberOfEdges];
        HashMap tmpVertexIndexToInputEdgeIndices = new HashMap();
        HashMap tmpVertexIndexToOutputEdgeIndices = new HashMap();
        int edgeIndex = 0;
        for (Map.Entry<UUID, Map.Entry<UUID, UUID>> edgeIdToNodeIdsEntry : edgeIdToNodeIds.entrySet()) {
            this.edgeToId[edgeIndex] = edgeIdToNodeIdsEntry.getKey();
            UUID srcVertexId = edgeIdToNodeIdsEntry.getValue().getKey();
            UUID trgVertexId = edgeIdToNodeIdsEntry.getValue().getValue();
            int srcIndex = this.vertexIdToIndex.get(srcVertexId);
            int trgIndex = this.vertexIdToIndex.get(trgVertexId);
            this.edgeIndexToSrcVertexIndex[edgeIndex] = srcIndex;
            this.edgeIndexToTrgVertexIndex[edgeIndex] = trgIndex;
            tmpVertexIndexToInputEdgeIndices.putIfAbsent(trgIndex, new ArrayList());
            tmpVertexIndexToOutputEdgeIndices.putIfAbsent(srcIndex, new ArrayList());
            ((List)tmpVertexIndexToInputEdgeIndices.get(trgIndex)).add(edgeIndex);
            ((List)tmpVertexIndexToOutputEdgeIndices.get(srcIndex)).add(edgeIndex);
            ++edgeIndex;
        }
        this.edgeIdToNodeIds = edgeIdToNodeIds;
        this.vertexIndexToInputEdgeIndices = new int[this.numberOfVertices][];
        this.vertexIndexToOutputEdgeIndices = new int[this.numberOfVertices][];
        for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
            List inputEdgeIndices = tmpVertexIndexToInputEdgeIndices.getOrDefault(vertexIndex, List.of());
            this.vertexIndexToInputEdgeIndices[vertexIndex] = inputEdgeIndices.stream().mapToInt(Integer::intValue).toArray();
            List outputEdgeIndices = tmpVertexIndexToOutputEdgeIndices.getOrDefault(vertexIndex, List.of());
            this.vertexIndexToOutputEdgeIndices[vertexIndex] = outputEdgeIndices.stream().mapToInt(Integer::intValue).toArray();
        }
        this.portIdToSpecifiedOrder = portIdToSpecifiedOrder;
    }
}

