/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import vg.lib.layout.hierarchical.data.VertexType;

public class HierarchicalVertex
implements Comparable<HierarchicalVertex> {
    private final UUID vertexId;
    private int index;
    private int posX;
    private int posY;
    private int rowPosY;
    private final Point size;
    private final Point borderSize;
    private Point fragmentTextSize;
    private VertexType type;
    private String name;
    private int initialPortIndex = -1;
    private final Map<UUID, Boolean> inputEdgeToVisible = Maps.newLinkedHashMap();
    private final Map<UUID, Boolean> outputEdgeToVisible = Maps.newLinkedHashMap();
    private final Map<UUID, UUID> inputEdgeToVertexId = Maps.newLinkedHashMap();
    private final Map<UUID, UUID> outputEdgeToVertexId = Maps.newLinkedHashMap();
    private int level;
    private boolean partOfCoreTree;
    private long importance;
    private int order = -1;
    private int groupId = -1;
    private UUID longEdgeId;
    private UUID backEdgeId;
    private boolean necessaryPartOfLongEdge;
    private HierarchicalVertex companionVertex;
    public int topLevelGroupP = 0;
    public int topLevelGroupId = -1;
    public int bottomLevelGroupP = 0;
    public int bottomLevelGroupId = -1;
    public boolean inputBreakPoint = false;
    public boolean outputBreakPoint = false;
    public boolean containsInputBackEdges = false;
    public boolean containsOutputBackEdges = false;

    HierarchicalVertex(UUID vertexId, VertexType type, int layer, int groupId, Point size, Point borderSize, Point fragmentTextSize) {
        this.vertexId = vertexId;
        this.index = 0;
        this.type = type;
        this.level = layer;
        this.groupId = groupId;
        this.size = size == null ? new Point() : new Point(size);
        this.borderSize = borderSize == null ? new Point() : new Point(borderSize);
        this.fragmentTextSize = fragmentTextSize == null ? new Point() : new Point(fragmentTextSize);
    }

    public boolean isBreakPoint() {
        return this.inputBreakPoint | this.outputBreakPoint;
    }

    public HierarchicalVertex setOrder(int order) {
        this.order = order;
        return this;
    }

    public HierarchicalVertex setLevel(int level) {
        this.level = level;
        return this;
    }

    public HierarchicalVertex setGroupId(int groupId) {
        this.groupId = groupId;
        return this;
    }

    public int getWidth() {
        return this.size.x + 2 * this.borderSize.x;
    }

    public int getWidthWithoutBorder() {
        return this.size.x;
    }

    public int getHeight() {
        return this.size.y + 2 * this.borderSize.y;
    }

    public boolean isPartOfLongEdge() {
        return this.longEdgeId != null;
    }

    public boolean isPartOfBackwardEdge() {
        return this.backEdgeId != null;
    }

    public boolean isVertex() {
        return this.isRealVertex() || this.isFakeVertex();
    }

    public boolean isRealVertex() {
        return this.type == VertexType.VERTEX_TYPE;
    }

    public boolean isFakeVertex() {
        return this.type == VertexType.FAKE_VERTEX_TYPE || this.type == VertexType.TOP_BACK_VERTEX_TYPE || this.type == VertexType.MAIN_BACK_VERTEX_TYPE || this.type == VertexType.BOTTOM_BACK_VERTEX_TYPE || this.type == VertexType.TOP_COMPANION_VERTEX_TYPE || this.type == VertexType.BOTTOM_COMPANION_VERTEX_TYPE || this.isBeaconVertex();
    }

    public boolean isCompanionVertex() {
        return this.type == VertexType.TOP_COMPANION_VERTEX_TYPE || this.type == VertexType.BOTTOM_COMPANION_VERTEX_TYPE;
    }

    public boolean isTopCompanionVertex() {
        return this.type == VertexType.TOP_COMPANION_VERTEX_TYPE;
    }

    public boolean isBottomCompanionVertex() {
        return this.type == VertexType.BOTTOM_COMPANION_VERTEX_TYPE;
    }

    public boolean isTopBackVertex() {
        return this.type == VertexType.TOP_BACK_VERTEX_TYPE;
    }

    public boolean isBottomBackVertex() {
        return this.type == VertexType.BOTTOM_BACK_VERTEX_TYPE;
    }

    public boolean isMainBackVertex() {
        return this.type == VertexType.MAIN_BACK_VERTEX_TYPE;
    }

    public boolean isBackVertex() {
        return this.isBottomBackVertex() || this.isTopBackVertex() || this.isMainBackVertex() || this.isCompanionVertex();
    }

    public boolean isInputPort() {
        return this.type == VertexType.REAL_INPUT_PORT_TYPE || this.type == VertexType.FAKE_INPUT_PORT_TYPE;
    }

    public boolean isOutputPort() {
        return this.type == VertexType.REAL_OUTPUT_PORT_TYPE || this.type == VertexType.FAKE_OUTPUT_PORT_TYPE;
    }

    public boolean isPort() {
        return this.isInputPort() | this.isOutputPort();
    }

    public boolean isTopBeaconVertex() {
        return this.type == VertexType.TOP_BEACON_VERTEX_TYPE;
    }

    public boolean isBottomBeaconVertex() {
        return this.type == VertexType.BOTTOM_BEACON_VERTEX_TYPE;
    }

    public boolean isBeaconVertex() {
        return this.type == VertexType.TOP_BEACON_VERTEX_TYPE || this.type == VertexType.BOTTOM_BEACON_VERTEX_TYPE;
    }

    public void addInputEdge(UUID inEdgeId, UUID srcVertexId) {
        if (!this.inputEdgeToVisible.containsKey(inEdgeId)) {
            this.inputEdgeToVisible.put(inEdgeId, true);
            this.inputEdgeToVertexId.put(inEdgeId, srcVertexId);
        }
    }

    public void addOutputEdge(UUID outEdgeId, UUID trgVertexId) {
        if (!this.outputEdgeToVisible.containsKey(outEdgeId)) {
            this.outputEdgeToVisible.put(outEdgeId, true);
            this.outputEdgeToVertexId.put(outEdgeId, trgVertexId);
        }
    }

    public void setInputEdgeVisible(UUID inEdgeId, boolean visible) {
        Validate.isTrue((boolean)this.inputEdgeToVisible.containsKey(inEdgeId));
        this.inputEdgeToVisible.put(inEdgeId, visible);
    }

    public void setOutputEdgeVisible(UUID outEdgeId, boolean visible) {
        Validate.isTrue((boolean)this.outputEdgeToVisible.containsKey(outEdgeId));
        this.outputEdgeToVisible.put(outEdgeId, visible);
    }

    public List<UUID> getInputEdges() {
        ArrayList inEdges = Lists.newArrayListWithExpectedSize((int)this.inputEdgeToVisible.size());
        for (UUID edgeId : this.inputEdgeToVisible.keySet()) {
            if (!this.inputEdgeToVisible.get(edgeId).booleanValue()) continue;
            inEdges.add(edgeId);
        }
        return Collections.unmodifiableList(inEdges);
    }

    public List<UUID> getOutputEdges() {
        ArrayList outEdges = Lists.newArrayListWithExpectedSize((int)this.outputEdgeToVisible.size());
        for (UUID edgeId : this.outputEdgeToVisible.keySet()) {
            if (!this.outputEdgeToVisible.get(edgeId).booleanValue()) continue;
            outEdges.add(edgeId);
        }
        return Collections.unmodifiableList(outEdges);
    }

    public List<UUID> getInputVertexIds() {
        ArrayList inVertexIds = Lists.newArrayListWithExpectedSize((int)this.inputEdgeToVisible.size());
        for (UUID edgeId : this.inputEdgeToVisible.keySet()) {
            if (!this.inputEdgeToVisible.get(edgeId).booleanValue()) continue;
            inVertexIds.add(this.inputEdgeToVertexId.get(edgeId));
        }
        return Collections.unmodifiableList(inVertexIds);
    }

    public List<EdgeWithVertex> getInputEdgeWithVertexList() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)this.inputEdgeToVisible.size());
        for (UUID edgeId : this.inputEdgeToVisible.keySet()) {
            if (!this.inputEdgeToVisible.get(edgeId).booleanValue()) continue;
            result.add(new EdgeWithVertex(edgeId, this.inputEdgeToVertexId.get(edgeId)));
        }
        return Collections.unmodifiableList(result);
    }

    public List<UUID> getOutputVertexIds() {
        ArrayList outVertexIds = Lists.newArrayListWithExpectedSize((int)this.outputEdgeToVisible.size());
        for (UUID edgeId : this.outputEdgeToVisible.keySet()) {
            if (!this.outputEdgeToVisible.get(edgeId).booleanValue()) continue;
            outVertexIds.add(this.outputEdgeToVertexId.get(edgeId));
        }
        return Collections.unmodifiableList(outVertexIds);
    }

    public List<EdgeWithVertex> getOutputEdgeWithVertexList() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)this.outputEdgeToVisible.size());
        for (UUID edgeId : this.outputEdgeToVisible.keySet()) {
            if (!this.outputEdgeToVisible.get(edgeId).booleanValue()) continue;
            result.add(new EdgeWithVertex(edgeId, this.outputEdgeToVertexId.get(edgeId)));
        }
        return Collections.unmodifiableList(result);
    }

    public void removeInputEdge(UUID edgeId) {
        Validate.isTrue((boolean)this.inputEdgeToVisible.containsKey(edgeId));
        Validate.isTrue((boolean)this.inputEdgeToVertexId.containsKey(edgeId));
        this.inputEdgeToVisible.remove(edgeId);
        this.inputEdgeToVertexId.remove(edgeId);
    }

    public void removeOutputEdge(UUID edgeId) {
        Validate.isTrue((boolean)this.outputEdgeToVisible.containsKey(edgeId));
        Validate.isTrue((boolean)this.outputEdgeToVertexId.containsKey(edgeId));
        this.outputEdgeToVisible.remove(edgeId);
        this.outputEdgeToVertexId.remove(edgeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchicalVertex element = (HierarchicalVertex)o;
        return this.vertexId.equals(element.vertexId);
    }

    public int hashCode() {
        return this.vertexId.hashCode();
    }

    @Override
    public int compareTo(HierarchicalVertex o) {
        return Integer.compare(this.order, o.getOrder());
    }

    public String toString() {
        return this.name;
    }

    public static void setupDefaultOrderForElements(List<HierarchicalVertex> vertices) {
        int order = 0;
        for (HierarchicalVertex vertex : vertices) {
            vertex.setOrder(order++);
        }
    }

    public UUID getVertexId() {
        return this.vertexId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getRowPosY() {
        return this.rowPosY;
    }

    public void setRowPosY(int rowPosY) {
        this.rowPosY = rowPosY;
    }

    public Point getSize() {
        return this.size;
    }

    public Point getBorderSize() {
        return this.borderSize;
    }

    public Point getFragmentTextSize() {
        return this.fragmentTextSize;
    }

    public void setFragmentTextSize(Point fragmentTextSize) {
        this.fragmentTextSize = fragmentTextSize;
    }

    public VertexType getType() {
        return this.type;
    }

    public void setType(VertexType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getInitialPortIndex() {
        return this.initialPortIndex;
    }

    public void setInitialPortIndex(int initialPortIndex) {
        this.initialPortIndex = initialPortIndex;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isPartOfCoreTree() {
        return this.partOfCoreTree;
    }

    public void setPartOfCoreTree(boolean partOfCoreTree) {
        this.partOfCoreTree = partOfCoreTree;
    }

    public long getImportance() {
        return this.importance;
    }

    public void setImportance(long importance) {
        this.importance = importance;
    }

    public int getOrder() {
        return this.order;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public UUID getLongEdgeId() {
        return this.longEdgeId;
    }

    public void setLongEdgeId(UUID longEdgeId) {
        this.longEdgeId = longEdgeId;
    }

    public UUID getBackEdgeId() {
        return this.backEdgeId;
    }

    public void setBackEdgeId(UUID backEdgeId) {
        this.backEdgeId = backEdgeId;
    }

    public boolean isNecessaryPartOfLongEdge() {
        return this.necessaryPartOfLongEdge;
    }

    public void setNecessaryPartOfLongEdge(boolean necessaryPartOfLongEdge) {
        this.necessaryPartOfLongEdge = necessaryPartOfLongEdge;
    }

    public HierarchicalVertex getCompanionVertex() {
        return this.companionVertex;
    }

    public void setCompanionVertex(HierarchicalVertex companionVertex) {
        this.companionVertex = companionVertex;
    }

    public boolean isInputBreakPoint() {
        return this.inputBreakPoint;
    }

    public void setInputBreakPoint(boolean inputBreakPoint) {
        this.inputBreakPoint = inputBreakPoint;
    }

    public boolean isOutputBreakPoint() {
        return this.outputBreakPoint;
    }

    public void setOutputBreakPoint(boolean outputBreakPoint) {
        this.outputBreakPoint = outputBreakPoint;
    }

    public boolean isContainsInputBackEdges() {
        return this.containsInputBackEdges;
    }

    public void setContainsInputBackEdges(boolean containsInputBackEdges) {
        this.containsInputBackEdges = containsInputBackEdges;
    }

    public boolean isContainsOutputBackEdges() {
        return this.containsOutputBackEdges;
    }

    public void setContainsOutputBackEdges(boolean containsOutputBackEdges) {
        this.containsOutputBackEdges = containsOutputBackEdges;
    }

    public static class EdgeWithVertex {
        public UUID edgeId;
        public UUID vertexId;

        public EdgeWithVertex(UUID edgeId, UUID vertexId) {
            this.edgeId = edgeId;
            this.vertexId = vertexId;
        }
    }
}

