/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.data;

import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;

public class HierarchicalLongEdge {
    private final UUID longEdgeId;
    private final UUID originalEdgeId;
    private final List<HierarchicalVertex> fakeVertices;
    private final List<HierarchicalEdge> fakeEdges;

    public HierarchicalLongEdge(UUID longEdgeId, UUID originalEdgeId, List<HierarchicalVertex> fakeVertices, List<HierarchicalEdge> fakeEdges) {
        Validate.notNull((Object)longEdgeId);
        Validate.notNull((Object)originalEdgeId);
        Validate.notEmpty(fakeVertices);
        Validate.notEmpty(fakeEdges);
        this.longEdgeId = longEdgeId;
        this.originalEdgeId = originalEdgeId;
        this.fakeVertices = fakeVertices;
        this.fakeEdges = fakeEdges;
    }

    public HierarchicalEdge getAnyEdge() {
        return this.getFirstEdge();
    }

    public HierarchicalEdge getFirstEdge() {
        return this.fakeEdges.get(0);
    }

    public HierarchicalEdge getLastEdge() {
        return this.fakeEdges.get(this.fakeEdges.size() - 1);
    }

    public HierarchicalVertex getSrcVertex() {
        return this.getFirstEdge().getSrcVertex();
    }

    public HierarchicalVertex getTrgVertex() {
        return this.getLastEdge().getTrgVertex();
    }

    public UUID getBackId() {
        return this.getFirstEdge().getBackEdgeId();
    }

    public boolean isPartOfBackwardEdge() {
        return this.getFirstEdge().getBackEdgeId() != null;
    }

    public UUID getLongEdgeId() {
        return this.longEdgeId;
    }

    public UUID getOriginalEdgeId() {
        return this.originalEdgeId;
    }

    public List<HierarchicalVertex> getFakeVertices() {
        return this.fakeVertices;
    }

    public List<HierarchicalEdge> getFakeEdges() {
        return this.fakeEdges;
    }
}

