/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IntSummaryStatistics;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.config.VGConfigSettings;
import vg.lib.layout.hierarchical.data.Direction;
import vg.lib.layout.hierarchical.data.HierarchicalBackwardEdge;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalLongEdge;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.data.VertexType;
import vg.lib.layout.hierarchical.step1.CalcEdgeLevelGroupProcedure;
import vg.lib.layout.hierarchical.step1.CheckThatAllChildrenHasSameLevelAndGroupProcedure;
import vg.lib.layout.hierarchical.step1.CheckThatAllParentsHasSameLevelAndGroupProcedure;
import vg.lib.layout.hierarchical.step1.HandleEdgesBetweenOneLevelProcedure;
import vg.lib.layout.hierarchical.step1.InsertBeaconsProcedure;

public class HierarchicalGraph {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalGraph.class);
    public int crosses;
    private final Point vertexBorderSize;
    public final Point companionVertexSize;
    private final Point fakeVertexSize;
    private final Point fakeVertexBorderSize;
    public final boolean hasInputPorts;
    public final boolean hasOutputPorts;
    private int startLevelOfGraph = -1;
    private int startLevelOfGraphWithInputPorts = -1;
    private int finishLevelOfGraph = -1;
    private int finishLevelOfGraphWithOutputPorts = -1;
    private int rowSize = 0;
    private final List<HierarchicalVertex> vertices = Lists.newArrayList();
    private final Map<UUID, HierarchicalEdge> edges = new LinkedHashMap<UUID, HierarchicalEdge>();
    private final LinkedHashMap<UUID, HierarchicalLongEdge> longEdges = Maps.newLinkedHashMap();
    private final LinkedHashMap<UUID, HierarchicalBackwardEdge> backwardEdges = Maps.newLinkedHashMap();

    public HierarchicalGraph(Point companionVertexSize, Point fakeVertexSize, Point vertexBorderSize, boolean hasInputPorts, boolean hasOutputPorts) {
        this.companionVertexSize = companionVertexSize;
        this.fakeVertexSize = fakeVertexSize;
        this.vertexBorderSize = vertexBorderSize;
        this.fakeVertexBorderSize = vertexBorderSize;
        this.hasInputPorts = hasInputPorts;
        this.hasOutputPorts = hasOutputPorts;
    }

    public List<HierarchicalVertex> getInputPorts() {
        return this.vertices.stream().filter(HierarchicalVertex::isInputPort).sorted().collect(Collectors.toList());
    }

    public List<HierarchicalVertex> getOutputPorts() {
        return this.vertices.stream().filter(HierarchicalVertex::isOutputPort).sorted().collect(Collectors.toList());
    }

    public HierarchicalEdge getEdgeById(UUID id) {
        return this.edges.get(id);
    }

    public List<HierarchicalEdge> getInputEdges(HierarchicalVertex vertex) {
        return this.getInputEdges(Collections.singletonList(vertex));
    }

    public List<HierarchicalEdge> getInputEdges(Collection<HierarchicalVertex> vertices) {
        LinkedHashSet<UUID> inputEdgeIds = new LinkedHashSet<UUID>();
        LinkedHashSet<UUID> inputVertexIds = new LinkedHashSet<UUID>();
        for (HierarchicalVertex vertex : vertices) {
            inputEdgeIds.addAll(vertex.getInputEdges());
            inputVertexIds.addAll(vertex.getInputVertexIds());
        }
        List<HierarchicalEdge> inputEdges = this.getEdgesByIds(inputEdgeIds);
        List<HierarchicalVertex> inputVertices = this.getVerticesByIds(inputVertexIds);
        ArrayList<HierarchicalEdge> result = new ArrayList<HierarchicalEdge>(inputEdges.size());
        for (HierarchicalVertex inputVertex : inputVertices) {
            for (HierarchicalEdge inputEdge : inputEdges) {
                if (!Objects.equals(inputVertex, inputEdge.getSrcVertex())) continue;
                result.add(inputEdge);
            }
        }
        return result;
    }

    public List<HierarchicalEdge> getOutputEdgesSortedByOutputVertices(HierarchicalVertex vertex) {
        return this.getOutputEdgesSortedByOutputVertices(Collections.singletonList(vertex));
    }

    public List<HierarchicalEdge> getOutputEdgesSortedByOutputVertices(Collection<HierarchicalVertex> vertices) {
        LinkedHashSet<UUID> outputEdgeIds = new LinkedHashSet<UUID>();
        LinkedHashSet<UUID> outputVertexIds = new LinkedHashSet<UUID>();
        for (HierarchicalVertex vertex : vertices) {
            outputEdgeIds.addAll(vertex.getOutputEdges());
            outputVertexIds.addAll(vertex.getOutputVertexIds());
        }
        List<HierarchicalEdge> outputEdges = this.getEdgesByIds(outputEdgeIds);
        List<HierarchicalVertex> outputVertices = this.getVerticesByIds(outputVertexIds);
        ArrayList<HierarchicalEdge> result = new ArrayList<HierarchicalEdge>(outputEdges.size());
        for (HierarchicalVertex outputVertex : outputVertices) {
            for (HierarchicalEdge outputEdge : outputEdges) {
                if (!Objects.equals(outputVertex, outputEdge.getTrgVertex())) continue;
                result.add(outputEdge);
            }
        }
        return result;
    }

    public List<HierarchicalEdge> getInputEdgesDefault(HierarchicalVertex[] vertices) {
        LinkedHashSet<UUID> inputEdgeIds = new LinkedHashSet<UUID>();
        for (HierarchicalVertex vertex : vertices) {
            inputEdgeIds.addAll(vertex.getInputEdges());
        }
        return this.getEdges().values().stream().filter(edge -> inputEdgeIds.contains(edge.getId())).collect(Collectors.toList());
    }

    public List<HierarchicalEdge> getOutputEdgesDefault(List<HierarchicalVertex> vertices) {
        LinkedHashSet<UUID> outputEdgeIds = new LinkedHashSet<UUID>();
        for (HierarchicalVertex vertex : vertices) {
            outputEdgeIds.addAll(vertex.getOutputEdges());
        }
        return this.getEdges().values().stream().filter(edge -> outputEdgeIds.contains(edge.getId())).collect(Collectors.toList());
    }

    public List<HierarchicalEdge> getOutputEdgesDefault(HierarchicalVertex[] vertices) {
        LinkedHashSet<UUID> outputEdgeIds = new LinkedHashSet<UUID>();
        for (HierarchicalVertex vertex : vertices) {
            outputEdgeIds.addAll(vertex.getOutputEdges());
        }
        return this.getEdges().values().stream().filter(edge -> outputEdgeIds.contains(edge.getId())).collect(Collectors.toList());
    }

    public List<HierarchicalEdge> getOutputEdges(Collection<HierarchicalVertex> vertices) {
        LinkedHashSet<UUID> outputEdgeIds = new LinkedHashSet<UUID>();
        for (HierarchicalVertex vertex : vertices) {
            outputEdgeIds.addAll(vertex.getOutputEdges());
        }
        return this.getEdgesByIds(outputEdgeIds);
    }

    public List<HierarchicalEdge> getEdgesByIds(Collection<UUID> ids) {
        return ids.stream().map(this.edges::get).collect(Collectors.toList());
    }

    public HierarchicalVertex getVertexById(UUID id) {
        return this.vertices.stream().filter(x -> x.getVertexId().equals(id)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public HierarchicalVertex getVertexByName(int level, String name) {
        return this.vertices.stream().filter(x -> x.getLevel() == level && Objects.equals(x.getName(), name)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public List<HierarchicalVertex> getVerticesByIds(Collection<UUID> ids) {
        return this.vertices.stream().filter(x -> ids.contains(x.getVertexId())).sorted().collect(Collectors.toList());
    }

    public LinkedHashMap<UUID, HierarchicalVertex> getInputVertices(Collection<HierarchicalVertex> vertices) {
        LinkedHashMap<UUID, HierarchicalVertex> inputVertices = new LinkedHashMap<UUID, HierarchicalVertex>();
        for (HierarchicalVertex vertex : vertices) {
            for (HierarchicalVertex inputVertex : this.getVerticesByIds(vertex.getInputVertexIds())) {
                if (inputVertices.containsKey(inputVertex.getVertexId())) continue;
                inputVertices.put(inputVertex.getVertexId(), inputVertex);
            }
        }
        return inputVertices;
    }

    public LinkedHashMap<UUID, HierarchicalVertex> getOutputVertices(Collection<HierarchicalVertex> vertices) {
        LinkedHashMap<UUID, HierarchicalVertex> outputVertices = new LinkedHashMap<UUID, HierarchicalVertex>();
        for (HierarchicalVertex vertex : vertices) {
            for (HierarchicalVertex outputVertex : this.getVerticesByIds(vertex.getOutputVertexIds())) {
                if (outputVertices.containsKey(outputVertex.getVertexId())) continue;
                outputVertices.put(outputVertex.getVertexId(), outputVertex);
            }
        }
        return outputVertices;
    }

    public List<HierarchicalVertex> getRowByLevel(int level) {
        return this.vertices.stream().filter(x -> x.getLevel() == level).sorted().collect(Collectors.toList());
    }

    public void applyOrders(int level, List<String> orderedNames) {
        this.resetOrders(level);
        int index = 0;
        for (String name : orderedNames) {
            this.getVertexByName(level, name).setOrder(index++);
        }
    }

    public void resetOrders(int level) {
        this.getRowByLevel(level).forEach(v -> v.setOrder(-1));
    }

    public List<HierarchicalVertex> getFirstRow() {
        return this.getRowByLevel(this.startLevelOfGraph);
    }

    public List<HierarchicalVertex> getLastRow() {
        return this.getRowByLevel(this.finishLevelOfGraph);
    }

    public HierarchicalVertex addInputPort(UUID vertexId, int initialPortIndex, String name, int groupId, Point size) {
        VertexType inputPortType = initialPortIndex >= 0 ? VertexType.REAL_INPUT_PORT_TYPE : VertexType.FAKE_INPUT_PORT_TYPE;
        HierarchicalVertex port = this.addVertex(vertexId, inputPortType, name, 0, groupId, size, null);
        port.setInitialPortIndex(initialPortIndex);
        return port;
    }

    public HierarchicalVertex addOutputPort(UUID vertexId, int initialPortIndex, String name, int groupId, Point size) {
        return this.addOutputPort(vertexId, initialPortIndex, name, this.getFinishLevelOfGraph() + 1, groupId, size);
    }

    public HierarchicalVertex addOutputPort(UUID vertexId, int initialPortIndex, String name, int layer, int groupId, Point size) {
        VertexType outputPortType = initialPortIndex >= 0 ? VertexType.REAL_OUTPUT_PORT_TYPE : VertexType.FAKE_OUTPUT_PORT_TYPE;
        HierarchicalVertex port = this.addVertex(vertexId, outputPortType, name, layer, groupId, size, null);
        port.setInitialPortIndex(initialPortIndex);
        return port;
    }

    public HierarchicalVertex addFakeVertex(int layer, int groupId, String name) {
        HierarchicalVertex fake = HierarchicalGraph.createVertex(UUID.randomUUID(), VertexType.FAKE_VERTEX_TYPE, name, layer, groupId, this.fakeVertexSize, this.fakeVertexBorderSize, null);
        this.vertices.add(fake);
        return fake;
    }

    public HierarchicalVertex addRealVertex(UUID vertexId, String name, int layer, int groupId, Point size) {
        return this.addVertex(vertexId, VertexType.VERTEX_TYPE, name, layer, groupId, size, null);
    }

    public HierarchicalVertex addRealVertexWithDefaultGroupId(UUID vertexId, String name, int layer, Point size) {
        return this.addVertex(vertexId, VertexType.VERTEX_TYPE, name, layer, 0, size, null);
    }

    public HierarchicalVertex addVertex(UUID vertexId, VertexType vertexType, String name, int layer, int groupId, Point size) {
        return this.addVertex(vertexId, vertexType, name, layer, groupId, size, null);
    }

    public HierarchicalVertex addVertex(UUID vertexId, VertexType vertexType, String name, int layer, int groupId, Point size, Point fragmentTextSize) {
        HierarchicalVertex vertex = HierarchicalGraph.createVertex(vertexId, vertexType, name, layer, groupId, size, this.vertexBorderSize, fragmentTextSize);
        log.debug("Vertex was added: " + vertex.getName() + " - layer: " + layer);
        this.vertices.add(vertex);
        return vertex;
    }

    public void shiftLevelForGraphVertices(int shift) {
        this.shiftLevelForGraphVertices(-1, shift);
    }

    public void shiftLevelForGraphVertices(int startLevel, int shift) {
        this.vertices.forEach(vertex -> {
            if (vertex.isVertex() && vertex.getLevel() >= startLevel) {
                vertex.setLevel(vertex.getLevel() + shift);
            }
        });
        this.reCalculateRoots();
    }

    public void shiftLeftOrder(HierarchicalVertex vertex, int shift) {
        int order = vertex.getOrder();
        this.getRowByLevel(vertex.getLevel()).forEach(v -> {
            int vOrder = v.getOrder();
            if (vOrder <= order) {
                v.setOrder(vOrder - shift);
            }
        });
    }

    public void shiftRightOrder(HierarchicalVertex vertex, int shift) {
        int order = vertex.getOrder();
        this.getRowByLevel(vertex.getLevel()).forEach(v -> {
            int vOrder = v.getOrder();
            if (vOrder >= order) {
                v.setOrder(vOrder + shift);
            }
        });
    }

    public void extendRows(int parentRowIndex, int groupId, int amount, Direction direction) {
        this.vertices.forEach(vertex -> {
            if (!vertex.isVertex()) {
                return;
            }
            if (direction == Direction.TOP && vertex.getLevel() < parentRowIndex) {
                return;
            }
            if (direction == Direction.BOTTOM && vertex.getLevel() < parentRowIndex) {
                return;
            }
            if (vertex.getGroupId() != groupId) {
                return;
            }
            vertex.setLevel(vertex.getLevel() + amount);
        });
        this.reCalculateRoots();
    }

    public void removeVertex(UUID vertexId) {
        this.removeVertex(this.getVertexById(vertexId));
    }

    public void removeVertex(HierarchicalVertex vertex) {
        Validate.isTrue((boolean)vertex.getInputEdges().isEmpty());
        Validate.isTrue((boolean)vertex.getOutputEdges().isEmpty());
        this.vertices.remove(vertex);
    }

    public HierarchicalLongEdge convertToLongEdge(HierarchicalEdge edge) {
        HierarchicalLongEdge longEdge;
        if (!edge.isLongEdge()) {
            return null;
        }
        UUID longEdgeId = edge.getLongEdgeId() == null ? edge.getId() : edge.getLongEdgeId();
        int groupId = edge.getSrcVertex().getGroupId();
        int order = -1;
        long importance = 0L;
        HierarchicalLongEdge existedLongEdge = this.longEdges.get(longEdgeId);
        this.removeEdge(edge);
        boolean isNecessaryPartOfLongEdge = false;
        String fakeVertexName = "FAKE";
        if (edge.isFake() && edge.getLongEdgeId() != null) {
            if (edge.getSrcVertex().isFakeVertex() && !edge.getSrcVertex().isCompanionVertex()) {
                fakeVertexName = edge.getSrcVertex().getName();
            }
            if (edge.getTrgVertex().isFakeVertex() && !edge.getTrgVertex().isCompanionVertex()) {
                fakeVertexName = edge.getTrgVertex().getName();
            }
            isNecessaryPartOfLongEdge = edge.getSrcVertex().isNecessaryPartOfLongEdge() | edge.getTrgVertex().isNecessaryPartOfLongEdge();
            if (edge.getSrcVertex().isCompanionVertex()) {
                order = edge.getSrcVertex().getOrder();
                importance = edge.getSrcVertex().getImportance();
            } else if (edge.getTrgVertex().isCompanionVertex()) {
                order = edge.getTrgVertex().getOrder();
                importance = edge.getTrgVertex().getImportance();
            } else if (edge.getTrgVertex().isFakeVertex()) {
                order = edge.getTrgVertex().getOrder();
                importance = edge.getTrgVertex().getImportance();
            } else if (edge.getSrcVertex().isFakeVertex()) {
                order = edge.getSrcVertex().getOrder();
                importance = edge.getSrcVertex().getImportance();
            }
        } else {
            List<HierarchicalVertex> row;
            fakeVertexName = String.format("%s <-> %s -- F", edge.getSrcVertex().getName(), edge.getTrgVertex().getName());
            HierarchicalBackwardEdge backwardEdge = this.backwardEdges.get(longEdgeId);
            if (backwardEdge != null) {
                fakeVertexName = String.format("%s <-> %s -- B", backwardEdge.getSrcVertex().getName(), backwardEdge.getTrgVertex().getName());
            }
            if (edge.getSrcVertex().getLevel() == edge.getTrgVertex().getLevel() - 2 && (row = this.getRowByLevel(edge.getSrcVertex().getLevel() + 1)).stream().noneMatch(HierarchicalVertex::isRealVertex)) {
                isNecessaryPartOfLongEdge = true;
            }
        }
        HierarchicalVertex prevVertex = edge.getSrcVertex();
        for (int level = edge.getSrcVertex().getLevel() + 1; level <= edge.getTrgVertex().getLevel(); ++level) {
            HierarchicalVertex fakeVertex;
            if (level == edge.getTrgVertex().getLevel()) {
                fakeVertex = edge.getTrgVertex();
            } else {
                fakeVertex = this.addFakeVertex(level, groupId, fakeVertexName);
                fakeVertex.setLongEdgeId(longEdgeId);
                fakeVertex.setNecessaryPartOfLongEdge(isNecessaryPartOfLongEdge);
                fakeVertex.setBackEdgeId(prevVertex.getBackEdgeId());
                fakeVertex.setOrder(order);
                fakeVertex.setImportance(importance);
            }
            HierarchicalEdge fakeEdge = this.addFakeEdge(prevVertex, fakeVertex);
            fakeEdge.setBackEdgeId(edge.getBackEdgeId());
            fakeEdge.setLongEdgeId(longEdgeId);
            if (level == edge.getSrcVertex().getLevel() + 1 && edge.getSrcPortId() != null) {
                fakeEdge.setSrcPortId(edge.getSrcPortId(), edge.getSrcPortIndex(), edge.getSrcPortPosX(), edge.getSrcPortSizeX());
            }
            if (level == edge.getTrgVertex().getLevel() && edge.getTrgPortId() != null) {
                fakeEdge.setTrgPortId(edge.getTrgPortId(), edge.getTrgPortIndex(), edge.getTrgPortPosX(), edge.getTrgPortSizeX());
            }
            prevVertex = fakeVertex;
        }
        ArrayList<HierarchicalVertex> fakeVertices = new ArrayList<HierarchicalVertex>(this.vertices.stream().filter(x -> x.getLongEdgeId() != null && x.getLongEdgeId().equals(longEdgeId)).collect(Collectors.toMap(x -> x, HierarchicalVertex::getLevel)).entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new)).keySet());
        ArrayList<HierarchicalEdge> fakeEdges = new ArrayList<HierarchicalEdge>(this.edges.values().stream().filter(x -> x.getLongEdgeId() != null && x.getLongEdgeId().equals(longEdgeId)).collect(Collectors.toMap(x -> x, v -> v.getSrcVertex().getLevel())).entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new)).keySet());
        UUID originalEdgeId = longEdgeId;
        if (existedLongEdge != null) {
            originalEdgeId = existedLongEdge.getOriginalEdgeId();
        }
        if ((longEdge = new HierarchicalLongEdge(longEdgeId, originalEdgeId, fakeVertices, fakeEdges)).getSrcVertex().isCompanionVertex() && longEdge.getTrgVertex().isCompanionVertex()) {
            fakeVertices.forEach(v -> v.setType(VertexType.MAIN_BACK_VERTEX_TYPE));
        }
        this.longEdges.put(longEdgeId, longEdge);
        return longEdge;
    }

    public boolean rowIsBack(int level) {
        List<HierarchicalVertex> row = this.getRowByLevel(level);
        if (row.isEmpty()) {
            return false;
        }
        boolean containsBack = false;
        for (HierarchicalVertex v : row) {
            if (!v.isFakeVertex()) {
                return false;
            }
            containsBack |= v.isBackVertex();
        }
        return containsBack;
    }

    public void convertToBackwardEdge(HierarchicalEdge backwardEdge) {
        UUID edgeId = backwardEdge.getId();
        HierarchicalVertex srcVertex = backwardEdge.getSrcVertex();
        HierarchicalVertex trgVertex = backwardEdge.getTrgVertex();
        Validate.notNull((Object)edgeId, (String)"Argument 'edgeId'  can't be null.", (Object[])new Object[0]);
        Validate.isTrue((srcVertex.getLevel() >= trgVertex.getLevel() ? 1 : 0) != 0);
        this.removeEdge(backwardEdge);
        srcVertex.setContainsOutputBackEdges(true);
        trgVertex.setContainsInputBackEdges(true);
        String srcName = String.format("SC: %s [%s]", srcVertex.getName(), trgVertex.getName());
        String trgName = String.format("TC: %s [%s]", trgVertex.getName(), srcVertex.getName());
        HierarchicalVertex srcCompanionVertex = this.addFakeVertex(srcVertex.getLevel() + 1, srcVertex.getGroupId(), srcName);
        srcCompanionVertex.setCompanionVertex(srcVertex);
        srcCompanionVertex.setBackEdgeId(edgeId);
        srcCompanionVertex.setType(VertexType.BOTTOM_COMPANION_VERTEX_TYPE);
        srcCompanionVertex.getSize().x = this.companionVertexSize.x;
        srcCompanionVertex.getSize().y = this.companionVertexSize.y;
        srcCompanionVertex.getBorderSize().x = 0;
        HierarchicalVertex trgCompanionVertex = this.addFakeVertex(trgVertex.getLevel() - 1, trgVertex.getGroupId(), trgName);
        trgCompanionVertex.setCompanionVertex(trgVertex);
        trgCompanionVertex.setBackEdgeId(edgeId);
        trgCompanionVertex.setType(VertexType.TOP_COMPANION_VERTEX_TYPE);
        trgCompanionVertex.getSize().x = this.companionVertexSize.x;
        trgCompanionVertex.getSize().y = this.companionVertexSize.y;
        trgCompanionVertex.getBorderSize().x = 0;
        if (trgVertex.getLevel() == 0 || this.hasInputPorts && trgVertex.getLevel() == 1) {
            this.shiftLevelForGraphVertices(1);
        }
        HierarchicalEdge edge = this.addFakeEdge(trgCompanionVertex, srcCompanionVertex);
        edge.setBackEdgeId(edgeId);
        HierarchicalEdge topEdge = this.addEdge(trgCompanionVertex, trgVertex, null, null, backwardEdge.getTrgPortId(), -1, backwardEdge.getTrgPortIndex(), -1, backwardEdge.getTrgPortPosX(), 0, backwardEdge.getTrgPortSizeX());
        topEdge.setFake(true);
        topEdge.setBackEdgeId(edgeId);
        HierarchicalEdge bottomEdge = this.addEdge(srcVertex, srcCompanionVertex, null, backwardEdge.getSrcPortId(), null, backwardEdge.getSrcPortIndex(), -1, backwardEdge.getSrcPortPosX(), -1, backwardEdge.getSrcPortSizeX(), 0);
        bottomEdge.setFake(true);
        bottomEdge.setBackEdgeId(edgeId);
        HierarchicalBackwardEdge result = new HierarchicalBackwardEdge(edgeId, edge.getId(), topEdge.getId(), bottomEdge.getId(), srcVertex, trgVertex, srcCompanionVertex, trgCompanionVertex);
        this.backwardEdges.put(edgeId, result);
        List<HierarchicalVertex> row = this.getRowByLevel(trgCompanionVertex.getLevel());
        if (row.stream().anyMatch(vertex -> !vertex.isCompanionVertex())) {
            this.shiftLevelForGraphVertices(trgVertex.getLevel(), 1);
            for (HierarchicalVertex vertex2 : row) {
                if (!vertex2.isCompanionVertex()) continue;
                vertex2.setLevel(trgCompanionVertex.getLevel() + 1);
            }
        }
        if ((row = this.getRowByLevel(srcCompanionVertex.getLevel())).stream().anyMatch(vertex -> !vertex.isCompanionVertex())) {
            this.shiftLevelForGraphVertices(srcCompanionVertex.getLevel() + 1, 1);
            for (HierarchicalVertex vertex2 : row) {
                if (vertex2.isCompanionVertex()) continue;
                vertex2.setLevel(vertex2.getLevel() + 1);
            }
        }
    }

    public void removeLongEdges(Collection<UUID> edgeIds) {
        edgeIds.forEach(this::removeLongEdge);
    }

    public void removeLongEdge(UUID longEdgeId) {
        HierarchicalLongEdge longEdge = this.longEdges.get(longEdgeId);
        if (longEdge == null) {
            this.removeEdge(longEdgeId);
            return;
        }
        longEdge.getFakeEdges().forEach(this::removeEdge);
        longEdge.getFakeVertices().forEach(this::removeVertex);
        this.longEdges.remove(longEdgeId);
    }

    public HierarchicalEdge addEdge(HierarchicalEdge edge) {
        return this.doAddEdge(edge.getSrcVertex(), edge.getTrgVertex(), edge.hasLongEdgeId() ? edge.getLongEdgeId() : edge.getId(), edge.getSrcPortId(), edge.getTrgPortId(), edge.getSrcPortIndex(), edge.getTrgPortIndex(), edge.getSrcPortPosX(), edge.getTrgPortPosX(), edge.getSrcPortSizeX(), edge.getTrgPortSizeX());
    }

    public HierarchicalEdge addFakeEdge(HierarchicalVertex source, HierarchicalVertex target) {
        HierarchicalEdge edge = this.addEdge(source, target, null, null, null, -1, -1, -1, -1, 0, 0);
        edge.setFake(true);
        return edge;
    }

    public HierarchicalEdge addEdge(HierarchicalVertex source, HierarchicalVertex target) {
        HierarchicalEdge edge = this.addEdge(source, target, null, null, null, -1, -1, -1, -1, 0, 0);
        return edge;
    }

    public HierarchicalEdge addEdge(HierarchicalVertex source, HierarchicalVertex target, UUID edgeId, UUID srcPortId, UUID trgPortId, int srcPortIndex, int trgPortIndex, int srcPortPosX, int trgPortPosX, int srcPortSizeX, int trgPortSizeX) {
        return this.doAddEdge(source, target, edgeId, srcPortId, trgPortId, srcPortIndex, trgPortIndex, srcPortPosX, trgPortPosX, srcPortSizeX, trgPortSizeX);
    }

    public void removeEdge(UUID edgeId) {
        this.removeEdge(this.getEdgeById(edgeId));
    }

    public void removeEdge(HierarchicalEdge edge) {
        edge.getSrcVertex().removeOutputEdge(edge.getId());
        edge.getTrgVertex().removeInputEdge(edge.getId());
        this.edges.remove(edge.getId());
    }

    private HierarchicalEdge doAddEdge(HierarchicalVertex source, HierarchicalVertex target, UUID edgeId, UUID srcPortId, UUID trgPortId, int srcPortIndex, int trgPortIndex, int srcPortPosX, int trgPortPosX, int srcPortSizeX, int trgPortSizeX) {
        HierarchicalEdge edge;
        if (edgeId == null) {
            edgeId = UUID.randomUUID();
        } else {
            edge = this.getEdgeById(edgeId);
            if (edge != null) {
                return edge;
            }
        }
        source.addOutputEdge(edgeId, target.getVertexId());
        target.addInputEdge(edgeId, source.getVertexId());
        edge = new HierarchicalEdge(edgeId, source, target);
        if (srcPortId != null) {
            edge.setSrcPortId(srcPortId, srcPortIndex, srcPortPosX, srcPortSizeX);
        }
        if (trgPortId != null) {
            edge.setTrgPortId(trgPortId, trgPortIndex, trgPortPosX, trgPortSizeX);
        }
        this.edges.put(edgeId, edge);
        return edge;
    }

    public void resetOrders() {
        this.vertices.forEach(x -> x.setOrder(-1));
        HierarchicalVertex.setupDefaultOrderForElements(this.getInputPorts());
        HierarchicalVertex.setupDefaultOrderForElements(this.getOutputPorts());
    }

    public static HierarchicalVertex createVertex(UUID vertexId, VertexType vertexType, String name, int layer, int groupId, Point size, Point borderSize, Point fragmentTextSize) {
        HierarchicalVertex e = new HierarchicalVertex(vertexId, vertexType, layer, groupId, size, borderSize, fragmentTextSize);
        e.setName(name);
        return e;
    }

    public List<HierarchicalVertex> getVertices(int groupId) {
        return this.vertices.stream().filter(x -> x.getGroupId() == groupId).collect(Collectors.toList());
    }

    public List<HierarchicalVertex> getVertices(int groupId, int level) {
        return this.vertices.stream().filter(x -> x.getGroupId() == groupId && x.getLevel() == level).collect(Collectors.toList());
    }

    private TreeMap<Integer, List<HierarchicalVertex>> getGroups() {
        return this.vertices.stream().filter(x -> !x.isInputPort() && !x.isOutputPort()).collect(HierarchicalGraph.sortedGroupingBy(HierarchicalVertex::getGroupId));
    }

    public int[] getGroupIds() {
        return this.vertices.stream().map(HierarchicalVertex::getGroupId).collect(Collectors.toSet()).stream().mapToInt(Integer::intValue).sorted().toArray();
    }

    public List<HierarchicalVertex> getVerticesByGroupId(int groupId) {
        return this.vertices.stream().filter(vertex -> vertex.getGroupId() == groupId).collect(Collectors.toList());
    }

    public List<HierarchicalEdge> getEdgesByGroupId(int groupId) {
        return this.edges.values().stream().filter(edge -> edge.getGroupId() == groupId).collect(Collectors.toList());
    }

    public TreeMap<Integer, List<HierarchicalVertex>> getDefaultDetailedGroup() {
        return this.getDetailedGroups().get(0);
    }

    public Map<Integer, TreeMap<Integer, List<HierarchicalVertex>>> getDetailedGroups() {
        TreeMap<Integer, TreeMap<Integer, List<HierarchicalVertex>>> result = new TreeMap<Integer, TreeMap<Integer, List<HierarchicalVertex>>>();
        for (Map.Entry<Integer, List<HierarchicalVertex>> groupEntry : this.getGroups().entrySet()) {
            TreeMap<Integer, List<HierarchicalVertex>> sortedByLevel = groupEntry.getValue().stream().collect(HierarchicalGraph.sortedGroupingBy(HierarchicalVertex::getLevel));
            sortedByLevel.values().forEach(x -> x.sort(HierarchicalVertex::compareTo));
            result.put(groupEntry.getKey(), sortedByLevel);
        }
        return result;
    }

    public void build(List<UUID> initialVertices) {
        new HandleEdgesBetweenOneLevelProcedure(this).execute();
        this.reCalculateRoots();
        List backwardEdges = this.getEdges().values().stream().filter(edge -> edge.getSrcVertex().getLevel() >= edge.getTrgVertex().getLevel()).collect(Collectors.toList());
        for (HierarchicalEdge backwardEdge : backwardEdges) {
            this.convertToBackwardEdge(backwardEdge);
        }
        this.reCalculateRoots();
        List longEdges = this.getEdges().values().stream().filter(HierarchicalEdge::isLongEdge).collect(Collectors.toList());
        for (HierarchicalEdge longEdge : longEdges) {
            this.convertToLongEdge(longEdge);
        }
        this.reCalculateRoots();
        new InsertBeaconsProcedure(this).execute();
        log.debug("Calculate initial order for the vertices...");
        this.reCalculateInitialOrderForVertices(initialVertices);
        log.debug("Initial order for the vertices were calculated...");
        log.debug("Calculate initial order for the long edges...");
        this.reCalculateInitialOrderForLongEdges();
        log.debug("Initial order for the long edges were calculated...");
        new CalcEdgeLevelGroupProcedure(this).execute();
        new CheckThatAllParentsHasSameLevelAndGroupProcedure(this).execute();
        new CheckThatAllChildrenHasSameLevelAndGroupProcedure(this).execute();
    }

    public void printResultData(String message) {
        this.printResultData(message, -1);
    }

    public void printResultData(String message, int level) {
        this.printHierarchy(message);
    }

    public void printHierarchy(String message) {
        log.debug("################################################################################");
        log.debug(message);
        if (VGConfigSettings.DIAGNOSTIC_MODE) {
            log.debug("Print levels (amount: {}):", (Object)this.rowSize);
            for (int rowIndex = 0; rowIndex < this.rowSize; ++rowIndex) {
                List<HierarchicalVertex> row = this.getRowByLevel(rowIndex);
                HierarchicalGraph.printCollection(String.format("\nLevel %s:", rowIndex), row);
            }
            log.debug("Print edges (amount: {}):", (Object)this.edges.size());
            for (HierarchicalEdge edge : this.edges.values()) {
                log.debug(edge.toString());
            }
        }
        log.debug("################################################################################");
    }

    public void printTable(int level) {
        log.debug("################################################################################");
        int maxOrder = this.vertices.stream().mapToInt(HierarchicalVertex::getOrder).max().orElse(-1);
        for (int rowIndex = 0; rowIndex < this.rowSize; ++rowIndex) {
            List<HierarchicalVertex> row = this.getRowByLevel(rowIndex);
            row.forEach(x -> Validate.isTrue((x.getOrder() >= 0 ? 1 : 0) != 0, (String)String.format("Element '%s' hasn't order.", x.getVertexId()), (Object[])new Object[0]));
            char[] rowArray = new char[maxOrder + 1];
            Arrays.fill(rowArray, ' ');
            row.forEach(x -> {
                switch (x.getType()) {
                    case VERTEX_TYPE: {
                        rowArray[x.getOrder()] = 82;
                        break;
                    }
                    case FAKE_VERTEX_TYPE: {
                        rowArray[x.getOrder()] = 70;
                    }
                }
            });
            String levelRowPrefix = String.format("%3s", rowIndex);
            String levelPrefix = "| ";
            if (rowIndex == level) {
                levelPrefix = "> ";
            }
            log.debug(levelRowPrefix + levelPrefix + StringUtils.join(Arrays.asList(ArrayUtils.toObject((char[])rowArray)), (String)" | "));
        }
        log.debug("################################################################################");
    }

    public static void printCollection(String message, Collection<HierarchicalVertex> collection) {
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message);
            sb.append("\n");
        }
        for (HierarchicalVertex e : collection) {
            sb.append(String.format("    %s\n", e));
        }
        log.debug("----------------------------------------");
        log.debug(sb.toString());
        log.debug("----------------------------------------");
    }

    public void printElement(String message, HierarchicalVertex element) {
        String name = "";
        if (element != null) {
            name = element.getName();
        }
        if (name == null) {
            name = "";
        }
        log.debug(String.format("%s %5s %s\n", message, name, element));
    }

    public void reCalculateInitialOrderForVertices(List<UUID> initialVertices) {
        this.reCalculateRoots();
        if (initialVertices != null) {
            LinkedHashMap unsortedMap = Maps.newLinkedHashMap();
            this.vertices.forEach(x -> {
                int index = initialVertices.indexOf(x.getVertexId());
                if ((x.isPort() || x.isRealVertex()) && index >= 0) {
                    unsortedMap.put(x, Float.valueOf(index));
                } else if (x.getLongEdgeId() != null) {
                    HierarchicalLongEdge longEdge = this.longEdges.get(x.getLongEdgeId());
                    Validate.notNull((Object)longEdge);
                    int sourceElementIndex = initialVertices.indexOf(longEdge.getSrcVertex().getVertexId());
                    int targetElementIndex = initialVertices.indexOf(longEdge.getTrgVertex().getVertexId());
                    unsortedMap.put(x, Float.valueOf((float)sourceElementIndex + 0.01f * (float)targetElementIndex));
                } else {
                    unsortedMap.put(x, Float.valueOf(Float.MAX_VALUE));
                }
            });
            this.vertices.clear();
            unsortedMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(x -> this.vertices.add((HierarchicalVertex)x.getKey()));
        }
        this.reCalculateVertexIndices();
        this.reCalculateRoots();
    }

    public void reCalculateVertexIndices() {
        int index = 0;
        for (HierarchicalVertex vertex : this.vertices) {
            vertex.setIndex(index++);
        }
    }

    public void reCalculateInitialOrderForLongEdges() {
        LinkedHashMap unsortedMap = Maps.newLinkedHashMap();
        this.longEdges.values().forEach(longEdge -> {
            int sourceElementIndex = this.vertices.indexOf(longEdge.getSrcVertex());
            int targetElementIndex = this.vertices.indexOf(longEdge.getTrgVertex());
            unsortedMap.put(longEdge, Float.valueOf((float)longEdge.getFakeVertices().size() + (float)((double)sourceElementIndex * 0.01 + (double)(1.0E-4f * (float)targetElementIndex))));
        });
        this.longEdges.clear();
        unsortedMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(x -> this.longEdges.put(((HierarchicalLongEdge)x.getKey()).getLongEdgeId(), (HierarchicalLongEdge)x.getKey()));
    }

    public void reCalculateRoots() {
        this.startLevelOfGraph = -1;
        this.finishLevelOfGraph = -1;
        this.rowSize = 0;
        IntSummaryStatistics stats = this.vertices.stream().filter(HierarchicalVertex::isVertex).mapToInt(HierarchicalVertex::getLevel).summaryStatistics();
        if (stats.getCount() > 0L) {
            this.startLevelOfGraphWithInputPorts = this.startLevelOfGraph = stats.getMin();
            this.finishLevelOfGraphWithOutputPorts = this.finishLevelOfGraph = stats.getMax();
            this.rowSize = this.finishLevelOfGraph - this.startLevelOfGraph + 1;
        }
        List<HierarchicalVertex> inputPorts = this.getInputPorts();
        List<HierarchicalVertex> outputPorts = this.getOutputPorts();
        if (!inputPorts.isEmpty()) {
            --this.startLevelOfGraphWithInputPorts;
            ++this.rowSize;
            inputPorts.forEach(port -> port.setLevel(0));
        }
        if (!outputPorts.isEmpty()) {
            ++this.finishLevelOfGraphWithOutputPorts;
            ++this.rowSize;
            outputPorts.forEach(port -> port.setLevel(this.rowSize - 1));
        }
    }

    public static int shiftOrderForDetailedGroup(int startGroupOrder, Map<Integer, List<HierarchicalVertex>> detailedGroup) {
        int maxOrder = -1;
        for (Map.Entry<Integer, List<HierarchicalVertex>> levelEntry : detailedGroup.entrySet()) {
            for (HierarchicalVertex e : levelEntry.getValue()) {
                e.setOrder(e.getOrder() + startGroupOrder);
                if (maxOrder >= e.getOrder()) continue;
                maxOrder = e.getOrder();
            }
        }
        return maxOrder;
    }

    public static int shiftPosXForDetailedGroup(int startGroupPosX, Map<Integer, List<HierarchicalVertex>> detailedGroup) {
        int maxPosX = 0;
        for (Map.Entry<Integer, List<HierarchicalVertex>> levelEntry : detailedGroup.entrySet()) {
            for (HierarchicalVertex e : levelEntry.getValue()) {
                e.setPosX(e.getPosX() + startGroupPosX);
                if (maxPosX >= e.getPosX() + e.getWidth()) continue;
                maxPosX = e.getPosX() + e.getWidth();
            }
        }
        return maxPosX;
    }

    private static <T, K extends Comparable<K>> Collector<T, ?, TreeMap<K, List<T>>> sortedGroupingBy(Function<T, K> function) {
        return Collectors.groupingBy(function, TreeMap::new, Collectors.toList());
    }

    private static void checkThatAllVerticesHasSameLevel(Collection<HierarchicalVertex> vertices) {
        if (vertices == null || vertices.isEmpty()) {
            return;
        }
        HierarchicalVertex referenceVertex = vertices.iterator().next();
        for (HierarchicalVertex vertex : vertices) {
            if (referenceVertex.getLevel() == vertex.getLevel()) continue;
            HierarchicalGraph.printCollection("Two or more vertices has different levels.", vertices);
            throw new IllegalArgumentException(String.format("Two or more vertices (%s) has different levels.", vertices.stream().map(HierarchicalVertex::getName).collect(Collectors.joining(", "))));
        }
    }

    private static void checkThatAllVerticesHasSameGroup(Collection<HierarchicalVertex> vertices) {
        if (vertices == null || vertices.isEmpty()) {
            return;
        }
        HierarchicalVertex referenceVertex = vertices.iterator().next();
        for (HierarchicalVertex vertex : vertices) {
            if (referenceVertex.getGroupId() == vertex.getGroupId()) continue;
            HierarchicalGraph.printCollection("Two or more vertices has different group ids.", vertices);
            throw new IllegalArgumentException(String.format("Two or more vertices ('%s') has different group ids.", vertices.stream().map(HierarchicalVertex::getName).collect(Collectors.joining(", "))));
        }
    }

    public Point getVertexBorderSize() {
        return this.vertexBorderSize;
    }

    public int getStartLevelOfGraph() {
        return this.startLevelOfGraph;
    }

    public int getStartLevelOfGraphWithInputPorts() {
        return this.startLevelOfGraphWithInputPorts;
    }

    public int getFinishLevelOfGraph() {
        return this.finishLevelOfGraph;
    }

    public int getFinishLevelOfGraphWithOutputPorts() {
        return this.finishLevelOfGraphWithOutputPorts;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public List<HierarchicalVertex> getVertices() {
        return this.vertices;
    }

    public Map<UUID, HierarchicalEdge> getEdges() {
        return this.edges;
    }

    public LinkedHashMap<UUID, HierarchicalLongEdge> getLongEdges() {
        return this.longEdges;
    }

    public LinkedHashMap<UUID, HierarchicalBackwardEdge> getBackwardEdges() {
        return this.backwardEdges;
    }
}

