/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.data;

import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import vg.lib.layout.hierarchical.data.HierarchicalPort;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;

public class HierarchicalEdge {
    private final UUID id;
    private final HierarchicalVertex srcVertex;
    private final HierarchicalVertex trgVertex;
    private UUID srcPortId;
    private UUID trgPortId;
    private int srcPortIndex;
    private int trgPortIndex;
    private int srcPortPosX;
    private int trgPortPosX;
    private int srcPortSizeX;
    private int trgPortSizeX;
    private int srcPosX;
    private int trgPosX;
    private boolean fake;
    private UUID longEdgeId;
    private UUID backEdgeId;
    public int levelGroupId = -1;
    private boolean srcBetweenRealVertices;
    private boolean trgBetweenRealVertices;

    public HierarchicalEdge(UUID id, HierarchicalVertex srcVertex, HierarchicalVertex trgVertex) {
        this.id = id;
        this.srcVertex = srcVertex;
        this.trgVertex = trgVertex;
        this.srcPortId = null;
        this.trgPortId = null;
        this.srcPortIndex = -1;
        this.trgPortIndex = -1;
        this.srcPortPosX = -1;
        this.trgPortPosX = -1;
        this.fake = false;
        this.longEdgeId = null;
    }

    public void setSrcPortId(UUID srcPortId, int srcPortIndex, int srcPortPosX, int srcPortSizeX) {
        Validate.notNull((Object)srcPortId);
        this.srcPortId = srcPortId;
        this.srcPortIndex = srcPortIndex;
        this.srcPortPosX = srcPortPosX;
        this.srcPortSizeX = srcPortSizeX;
    }

    public HierarchicalPort getSrcPort() {
        if (!this.hasSrcPort()) {
            return null;
        }
        return new HierarchicalPort(this.srcPortId, this.srcPortIndex, this.srcPortPosX, this.srcPortSizeX);
    }

    public void setTrgPortId(UUID trgPortId, int trgPortIndex, int trgPortPosX, int trgPortSizeX) {
        Validate.notNull((Object)trgPortId);
        this.trgPortId = trgPortId;
        this.trgPortIndex = trgPortIndex;
        this.trgPortPosX = trgPortPosX;
        this.trgPortSizeX = trgPortSizeX;
    }

    public HierarchicalPort getTrgPort() {
        if (!this.hasTrgPort()) {
            return null;
        }
        return new HierarchicalPort(this.trgPortId, this.trgPortIndex, this.trgPortPosX, this.trgPortSizeX);
    }

    public boolean hasLongEdgeId() {
        return this.longEdgeId != null;
    }

    public boolean hasSrcPort() {
        return this.srcPortId != null;
    }

    public boolean hasTrgPort() {
        return this.trgPortId != null;
    }

    public boolean isLongEdge() {
        return Math.abs(this.trgVertex.getLevel() - this.srcVertex.getLevel()) > 1;
    }

    public boolean isLoopEdge() {
        return this.srcVertex == this.trgVertex;
    }

    public boolean isFakeEdge() {
        return this.srcVertex.isFakeVertex() || this.trgVertex.isFakeVertex();
    }

    public boolean isBackEdge() {
        return this.srcVertex.isBackVertex() || this.trgVertex.isBackVertex();
    }

    public boolean isTopBackEdge() {
        return this.srcVertex.isCompanionVertex() && this.trgVertex.isRealVertex() || this.srcVertex.isTopBackVertex() || this.trgVertex.isTopBackVertex();
    }

    public boolean isBottomBackEdge() {
        return this.srcVertex.isRealVertex() && this.trgVertex.isCompanionVertex() || this.srcVertex.isBottomBackVertex() || this.trgVertex.isBottomBackVertex();
    }

    public boolean isTopMainBackEdge() {
        return this.srcVertex.isCompanionVertex() && this.trgVertex.isBackVertex();
    }

    public boolean isBottomMainBackEdge() {
        return this.srcVertex.isBackVertex() && this.trgVertex.isCompanionVertex();
    }

    public boolean isMainBackEdge() {
        return this.srcVertex.isBackVertex() && this.trgVertex.isBackVertex();
    }

    public boolean isTopBeaconEdge() {
        return this.srcVertex.isTopBeaconVertex();
    }

    public boolean isBottomBeaconEdge() {
        return this.trgVertex.isBottomBeaconVertex();
    }

    public float getSrcPortCenterX() {
        return (float)this.srcPortPosX + (float)this.srcPortSizeX / 2.0f;
    }

    public int getRoundSrcPortCenterX() {
        return Math.round(this.getSrcPortCenterX());
    }

    public float getTrgPortCenterX() {
        return (float)this.trgPortPosX + (float)this.trgPortSizeX / 2.0f;
    }

    public int getRoundTrgPortCenterX() {
        return Math.round(this.getTrgPortCenterX());
    }

    public int getGroupId() {
        return this.srcVertex.getGroupId();
    }

    public String toString() {
        return this.srcVertex.getName() + " --> " + this.trgVertex.getName() + " : " + this.levelGroupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchicalEdge that = (HierarchicalEdge)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public UUID getId() {
        return this.id;
    }

    public HierarchicalVertex getSrcVertex() {
        return this.srcVertex;
    }

    public HierarchicalVertex getTrgVertex() {
        return this.trgVertex;
    }

    public UUID getSrcPortId() {
        return this.srcPortId;
    }

    public UUID getTrgPortId() {
        return this.trgPortId;
    }

    public int getSrcPortIndex() {
        return this.srcPortIndex;
    }

    public int getTrgPortIndex() {
        return this.trgPortIndex;
    }

    public int getSrcPortPosX() {
        return this.srcPortPosX;
    }

    public int getTrgPortPosX() {
        return this.trgPortPosX;
    }

    public int getSrcPortSizeX() {
        return this.srcPortSizeX;
    }

    public int getTrgPortSizeX() {
        return this.trgPortSizeX;
    }

    public int getSrcPosX() {
        return this.srcPosX;
    }

    public int getTrgPosX() {
        return this.trgPosX;
    }

    public void setSrcPosX(int srcPosX) {
        this.srcPosX = srcPosX;
    }

    public void setTrgPosX(int trgPosX) {
        this.trgPosX = trgPosX;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public UUID getLongEdgeId() {
        return this.longEdgeId;
    }

    public void setLongEdgeId(UUID longEdgeId) {
        this.longEdgeId = longEdgeId;
    }

    public UUID getBackEdgeId() {
        return this.backEdgeId;
    }

    public void setBackEdgeId(UUID backEdgeId) {
        this.backEdgeId = backEdgeId;
    }

    public boolean isSrcBetweenRealVertices() {
        return this.srcBetweenRealVertices;
    }

    public void setSrcBetweenRealVertices(boolean srcBetweenRealVertices) {
        this.srcBetweenRealVertices = srcBetweenRealVertices;
    }

    public boolean isTrgBetweenRealVertices() {
        return this.trgBetweenRealVertices;
    }

    public void setTrgBetweenRealVertices(boolean trgBetweenRealVertices) {
        this.trgBetweenRealVertices = trgBetweenRealVertices;
    }
}

