/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical.data;

import java.util.Objects;
import java.util.UUID;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;

public class HierarchicalBackwardEdge {
    private final UUID originalEdgeId;
    private final UUID topEdgeId;
    private final UUID bottomEdgeId;
    private final UUID edgeBetweenCompanionsId;
    private final HierarchicalVertex srcVertex;
    private final HierarchicalVertex trgVertex;
    private final HierarchicalVertex srcCompanionVertex;
    private final HierarchicalVertex trgCompanionVertex;
    public HierarchicalVertex srcCompanionCoupleVertex;
    public HierarchicalVertex trgCompanionCoupleVertex;

    public HierarchicalBackwardEdge(UUID originalEdgeId, UUID edgeBetweenCompanionsId, UUID topEdgeId, UUID bottomEdgeId, HierarchicalVertex srcVertex, HierarchicalVertex trgVertex, HierarchicalVertex srcCompanionVertex, HierarchicalVertex trgCompanionVertex) {
        this.originalEdgeId = originalEdgeId;
        this.edgeBetweenCompanionsId = edgeBetweenCompanionsId;
        this.topEdgeId = topEdgeId;
        this.bottomEdgeId = bottomEdgeId;
        this.srcVertex = srcVertex;
        this.trgVertex = trgVertex;
        this.srcCompanionVertex = srcCompanionVertex;
        this.trgCompanionVertex = trgCompanionVertex;
    }

    public boolean isLoop() {
        return this.srcVertex == this.trgVertex;
    }

    public int getGroupId() {
        return this.srcVertex.getGroupId();
    }

    public UUID getSrcCompanionInputVertex() {
        for (UUID id : this.srcCompanionVertex.getInputVertexIds()) {
            if (Objects.equals(id, this.srcVertex.getVertexId())) continue;
            return id;
        }
        return null;
    }

    public UUID getTrgCompanionOutputVertex() {
        for (UUID id : this.trgCompanionVertex.getOutputVertexIds()) {
            if (Objects.equals(id, this.trgVertex.getVertexId())) continue;
            return id;
        }
        return null;
    }

    public UUID getOriginalEdgeId() {
        return this.originalEdgeId;
    }

    public UUID getTopEdgeId() {
        return this.topEdgeId;
    }

    public UUID getBottomEdgeId() {
        return this.bottomEdgeId;
    }

    public UUID getEdgeBetweenCompanionsId() {
        return this.edgeBetweenCompanionsId;
    }

    public HierarchicalVertex getSrcVertex() {
        return this.srcVertex;
    }

    public HierarchicalVertex getTrgVertex() {
        return this.trgVertex;
    }

    public HierarchicalVertex getSrcCompanionVertex() {
        return this.srcCompanionVertex;
    }

    public HierarchicalVertex getTrgCompanionVertex() {
        return this.trgCompanionVertex;
    }
}

