/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical;

import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.layout.hierarchical.HierarchicalLayoutSettings;
import vg.lib.layout.hierarchical.data.HierarchicalBackwardEdge;
import vg.lib.layout.hierarchical.data.HierarchicalEdge;
import vg.lib.layout.hierarchical.data.HierarchicalGraph;
import vg.lib.layout.hierarchical.data.HierarchicalLongEdge;
import vg.lib.layout.hierarchical.data.HierarchicalVertex;
import vg.lib.layout.hierarchical.data.VertexType;
import vg.lib.layout.hierarchical.step1.CustomLayeringOperation;
import vg.lib.layout.hierarchical.step1.FineTuningLayeringOperation;
import vg.lib.layout.hierarchical.step1.data.LayeringOperationResult;
import vg.lib.layout.hierarchical.step2.SetOrderForVerticesByDefaultCrossingReductionProcedure;
import vg.lib.layout.hierarchical.step2.custom.CustomCrossingReductionProcedure;
import vg.lib.layout.hierarchical.step2.legacy.LegacyCrossingReductionProcedure;
import vg.lib.layout.hierarchical.step3.custom.CustomCoordinateAlignmentProcedure;
import vg.lib.layout.hierarchical.step3.legacy.ForceDirectedAlignmentProcedure;
import vg.lib.layout.hierarchical.step3.legacy.LeftAlignmentProcedure;
import vg.lib.layout.hierarchical.step3.legacy.operation.PrepareBackwardEdgesToAlignmentProcedure;
import vg.lib.layout.hierarchical.step3.legacy.operation.PrepareLongEdgesToAlignmentProcedure;
import vg.lib.operation.Operation;
import vg.lib.operation.OperationWithOneArg;
import vg.lib.operation.OperationWithTwoArgs;
import vg.lib.operation.ProcedureWithThreeArgs;

public class HierarchicalPlainLayout
implements Operation<Result> {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalPlainLayout.class);
    private final List<UUID> vertices;
    private final List<UUID> inputPortIds;
    private final List<UUID> outputPortIds;
    private final Map<UUID, Map.Entry<UUID, UUID>> edgeToNodes;
    private final Map<UUID, UUID> edgeToSrcPort;
    private final Map<UUID, UUID> edgeToTrgPort;
    private final Map<UUID, Integer> portIdToOrder;
    private final Map<UUID, Point> portIdToPos;
    private final Map<UUID, Point> portIdToSize;
    private final Map<UUID, String> vertexIdToName;
    private final Map<UUID, Point> vertexIdToSize;
    private final Map<UUID, Point> vertexIdToFragmentTextSize;
    private final HierarchicalLayoutSettings settings;
    private HierarchicalGraph graph;

    HierarchicalPlainLayout(List<UUID> vertices, List<UUID> inputPortIds, List<UUID> outputPortIds, Map<UUID, Map.Entry<UUID, UUID>> edgeToNodes, Map<UUID, UUID> edgeToSrcPort, Map<UUID, UUID> edgeToTrgPort, Map<UUID, Integer> portIdToOrder, Map<UUID, Point> portIdToPos, Map<UUID, Point> portIdToSize, Map<UUID, String> vertexIdToName, Map<UUID, Point> vertexIdToSize, Map<UUID, Point> vertexIdToFragmentTextSize, HierarchicalLayoutSettings settings) {
        this.vertices = vertices;
        this.inputPortIds = inputPortIds;
        this.outputPortIds = outputPortIds;
        this.edgeToNodes = edgeToNodes;
        this.edgeToSrcPort = edgeToSrcPort;
        this.edgeToTrgPort = edgeToTrgPort;
        this.portIdToOrder = portIdToOrder;
        this.portIdToPos = portIdToPos;
        this.portIdToSize = portIdToSize;
        this.vertexIdToName = vertexIdToName;
        this.vertexIdToSize = vertexIdToSize;
        this.vertexIdToFragmentTextSize = vertexIdToFragmentTextSize;
        this.settings = settings;
    }

    @Override
    public Result execute() {
        for (UUID vertex : this.vertices) {
            if (this.vertexIdToSize.containsKey(vertex)) continue;
            throw new IllegalArgumentException(String.format("Can't find size for vertex with id '%s'.", vertex));
        }
        this.graph = new HierarchicalGraph(new Point(20, 20), new Point(1, 1), new Point(this.settings.minHSpaceBetweenVertices, 0), !this.inputPortIds.isEmpty(), !this.outputPortIds.isEmpty());
        long t1 = System.currentTimeMillis();
        this.executeStep1();
        long t2 = System.currentTimeMillis();
        this.executeStep2();
        long t3 = System.currentTimeMillis();
        this.executeStep3();
        long t4 = System.currentTimeMillis();
        log.debug(String.format("Time:\nStep 1: %sms.\nStep 2: %sms\nStep 3: %sms.", t2 - t1, t3 - t2, t4 - t3));
        return this.prepareResult();
    }

    private void executeStep1() {
        log.debug("Step 1: prepare vertices and edges. Set level for each vertex.");
        this.prepareVertices();
        this.prepareEdges();
        this.graph.build(this.vertices);
        this.graph.printHierarchy("Print result after step 1.");
    }

    private void executeStep2() {
        log.debug("Step 2: crossing reduction step.");
        switch (this.settings.crossingReductionAlgorithm) {
            case 3: {
                new SetOrderForVerticesByDefaultCrossingReductionProcedure(this.graph).execute();
                break;
            }
            case 0: 
            case 1: {
                new LegacyCrossingReductionProcedure(this.graph).execute();
                break;
            }
            case 4: {
                new CustomCrossingReductionProcedure(this.graph).execute();
            }
        }
        Stream.concat(this.graph.getInputPorts().stream(), this.graph.getOutputPorts().stream()).forEach(port -> this.portIdToOrder.put(port.getVertexId(), port.getOrder()));
        this.graph.printHierarchy("Print result after step 2.");
    }

    private void executeStep3() {
        log.debug("Step 3: align the vertices and ports of the graph.");
        long startTime = System.currentTimeMillis();
        new PrepareBackwardEdgesToAlignmentProcedure(this.graph).execute();
        new PrepareLongEdgesToAlignmentProcedure(this.graph).execute();
        switch (this.settings.alignment) {
            case 4: {
                new ForceDirectedAlignmentProcedure(this.settings.collapseEdgeSrc, this.settings.collapseEdgeTrg, this.graph).execute();
                break;
            }
            case 5: {
                new CustomCoordinateAlignmentProcedure(this.graph).execute();
                break;
            }
            default: {
                new LeftAlignmentProcedure(this.graph).execute();
            }
        }
        long finishTime = System.currentTimeMillis();
        this.graph.printResultData(String.format("Print result after step 3 (%s ms).", finishTime - startTime));
    }

    private Result prepareResult() {
        log.debug("Prepare results of the algorithm.");
        final Result result = new Result();
        result.setCrosses(this.graph.crosses);
        var calcMaxRowHeightFunc = new OperationWithOneArg<List<HierarchicalVertex>, Integer>(){

            @Override
            public Integer execute(List<HierarchicalVertex> vertices) {
                int maxRowHeight = 0;
                for (HierarchicalVertex vertex : vertices) {
                    if (result.getGraphSize().x < vertex.getPosX() + vertex.getWidth()) {
                        result.getGraphSize().x = vertex.getPosX() + vertex.getWidth();
                    }
                    if (maxRowHeight >= vertex.getHeight()) continue;
                    maxRowHeight = vertex.getHeight();
                }
                return maxRowHeight;
            }
        };
        var calcSpaceBetweenRowsFunc = new OperationWithTwoArgs<List<HierarchicalEdge>, Integer, Integer>(){

            @Override
            public Integer execute(List<HierarchicalEdge> edges, Integer minVSpaceBetweenRows) {
                int maxEdgeWidth = 0;
                boolean allEdgesAreFake = true;
                boolean someEdgeIsBackward = false;
                boolean nextRowIsFake = true;
                boolean prevRowIsFake = true;
                for (HierarchicalEdge edge : edges) {
                    if (edge.getSrcVertex().isRealVertex()) {
                        prevRowIsFake = false;
                    }
                    if (edge.getTrgVertex().isRealVertex()) {
                        nextRowIsFake = false;
                    }
                    if (!edge.getSrcVertex().isFakeVertex()) {
                        allEdgesAreFake = false;
                    }
                    if (edge.isBackEdge()) {
                        someEdgeIsBackward = true;
                        continue;
                    }
                    int edgeWidth = Math.abs(edge.getSrcVertex().getPosX() + edge.getSrcPosX() - (edge.getTrgVertex().getPosX() + edge.getTrgPosX()));
                    if (maxEdgeWidth >= edgeWidth) continue;
                    maxEdgeWidth = edgeWidth;
                }
                if (someEdgeIsBackward && allEdgesAreFake && nextRowIsFake && prevRowIsFake) {
                    minVSpaceBetweenRows = Math.round((float)minVSpaceBetweenRows.intValue() * 0.15f);
                }
                if (allEdgesAreFake && !nextRowIsFake && prevRowIsFake) {
                    minVSpaceBetweenRows = Math.round((float)minVSpaceBetweenRows.intValue() * 0.75f);
                }
                if (allEdgesAreFake && !prevRowIsFake && nextRowIsFake) {
                    minVSpaceBetweenRows = Math.round((float)minVSpaceBetweenRows.intValue() * 0.75f);
                }
                int maxEdgeWidthExt = Math.round((float)maxEdgeWidth * 0.35f);
                return Math.max(maxEdgeWidthExt, minVSpaceBetweenRows);
            }
        };
        Function<HierarchicalVertex, Result.OutputEdge.AdditionalPoint> convertToAdditionalPointFunc = new Function<HierarchicalVertex, Result.OutputEdge.AdditionalPoint>(){

            @Override
            public Result.OutputEdge.AdditionalPoint apply(HierarchicalVertex vertex) {
                return new Result.OutputEdge.AdditionalPoint(vertex.getRowPosY(), new Point(vertex.getPosX(), vertex.getPosY()), new Point(vertex.getWidth(), vertex.getHeight()));
            }
        };
        OperationWithOneArg<List<HierarchicalVertex>, List<Result.OutputEdge.AdditionalPoint>> convertToAdditionalPointsFunc = new OperationWithOneArg<List<HierarchicalVertex>, List<Result.OutputEdge.AdditionalPoint>>(){
            final /* synthetic */ 3 val$convertToAdditionalPointFunc;
            {
                this.val$convertToAdditionalPointFunc = var2_2;
            }

            @Override
            public List<Result.OutputEdge.AdditionalPoint> execute(List<HierarchicalVertex> vertices) {
                return vertices.stream().map(this.val$convertToAdditionalPointFunc).collect(Collectors.toList());
            }
        };
        var setPosYProc = new ProcedureWithThreeArgs<List<HierarchicalVertex>, Integer, Integer>(){

            @Override
            public void execute(List<HierarchicalVertex> vertices, Integer rowPosY, Integer maxRowHeight) {
                for (HierarchicalVertex vertex : vertices) {
                    vertex.setPosY(rowPosY + maxRowHeight - vertex.getHeight());
                    vertex.setRowPosY(rowPosY);
                }
            }
        };
        int maxInputPortHeight = 0;
        int spaceBetweenInputPorts = this.settings.minVSpaceBetweenPorts;
        int spaceBetweenOutputPorts = this.settings.minVSpaceBetweenPorts;
        if (this.graph.hasInputPorts) {
            List<HierarchicalEdge> outputEdges = this.graph.getOutputEdges(this.graph.getInputPorts());
            maxInputPortHeight = calcMaxRowHeightFunc.execute(this.graph.getInputPorts());
            spaceBetweenInputPorts = calcSpaceBetweenRowsFunc.execute(outputEdges, outputEdges.size() > 0 ? this.settings.minVSpaceBetweenRows : this.settings.minVSpaceBetweenPorts);
            setPosYProc.execute(this.graph.getInputPorts(), 0, maxInputPortHeight);
        }
        for (Map.Entry entry : this.graph.getDetailedGroups().entrySet()) {
            int groupSizeY = maxInputPortHeight + spaceBetweenInputPorts;
            int count = 0;
            for (Map.Entry detailedGroupEntry : ((TreeMap)entry.getValue()).entrySet()) {
                List<HierarchicalVertex> row = ((List)detailedGroupEntry.getValue()).stream().sorted().collect(Collectors.toList());
                int maxRowHeight = calcMaxRowHeightFunc.execute(row);
                setPosYProc.execute(row, groupSizeY, maxRowHeight);
                groupSizeY += maxRowHeight;
                if (count != ((TreeMap)entry.getValue()).size() - 1) {
                    int spaceBetweenRows = calcSpaceBetweenRowsFunc.execute(this.graph.getOutputEdgesSortedByOutputVertices(row), this.settings.minVSpaceBetweenRows);
                    groupSizeY += spaceBetweenRows;
                }
                ++count;
            }
            result.getGraphSize().y = Math.max(result.getGraphSize().y, groupSizeY);
        }
        if (this.graph.hasOutputPorts) {
            List<HierarchicalEdge> inputEdges = this.graph.getInputEdges(this.graph.getOutputPorts());
            int maxOutputPortHeight = calcMaxRowHeightFunc.execute(this.graph.getOutputPorts());
            spaceBetweenOutputPorts = calcSpaceBetweenRowsFunc.execute(inputEdges, inputEdges.size() > 0 ? this.settings.minVSpaceBetweenRows : this.settings.minVSpaceBetweenPorts);
            result.getGraphSize().y += spaceBetweenOutputPorts;
            setPosYProc.execute(this.graph.getOutputPorts(), result.getGraphSize().y, maxOutputPortHeight);
            result.getGraphSize().y += maxOutputPortHeight;
        } else {
            result.getGraphSize().y += spaceBetweenOutputPorts;
        }
        this.graph.getEdges().values().forEach(edge -> {
            if (edge.isFake()) {
                return;
            }
            UUID edgeId = edge.getId();
            Result.OutputEdge outputEdge = new Result.OutputEdge(edgeId);
            outputEdge.setSrcId(edge.getSrcVertex().getVertexId());
            outputEdge.setTrgId(edge.getTrgVertex().getVertexId());
            outputEdge.setSrcPosX(edge.getSrcPosX());
            outputEdge.setTrgPosX(edge.getTrgPosX());
            result.getEdges().put(edge.getId(), outputEdge);
        });
        this.graph.getLongEdges().values().forEach(arg_0 -> HierarchicalPlainLayout.lambda$prepareResult$2(convertToAdditionalPointsFunc, result, arg_0));
        this.graph.getBackwardEdges().values().forEach(arg_0 -> this.lambda$prepareResult$3(convertToAdditionalPointsFunc, convertToAdditionalPointFunc, result, arg_0));
        for (int rowIndex = 0; rowIndex < this.graph.getRowSize(); ++rowIndex) {
            List<HierarchicalVertex> list = this.graph.getRowByLevel(rowIndex);
            list.forEach(x -> Validate.isTrue((x.getOrder() >= 0 ? 1 : 0) != 0, (String)String.format("Vertex '%s' hasn't order.", x.getName()), (Object[])new Object[0]));
            for (HierarchicalVertex vertex : list) {
                if (!vertex.isRealVertex() && !vertex.isPort()) continue;
                result.getVertices().put(vertex.getVertexId(), new Result.OutputVertex(vertex.getVertexId(), vertex.getLevel(), vertex.getOrder(), vertex.getRowPosY(), new Point(vertex.getPosX() + vertex.getBorderSize().x, vertex.getPosY()), new Point(vertex.getSize())));
            }
        }
        Validate.isTrue((result.getVertices().size() == this.vertices.size() ? 1 : 0) != 0, (String)"Amount of vertices in result is not equal with input.", (Object[])new Object[0]);
        Validate.isTrue((result.getEdges().size() == this.edgeToNodes.size() ? 1 : 0) != 0, (String)"Amount of edges in result is not equal with input.", (Object[])new Object[0]);
        return result;
    }

    private void prepareVertices() {
        log.debug("Prepare vertices...");
        LayeringOperationResult result = switch (this.settings.layeringAlgorithm) {
            case 2 -> new CustomLayeringOperation(this.vertices, this.inputPortIds, this.outputPortIds, this.edgeToNodes, this.portIdToOrder).execute();
            default -> new FineTuningLayeringOperation(this.vertices, this.inputPortIds, this.outputPortIds, this.edgeToNodes).execute();
        };
        for (int vertexIndex = 0; vertexIndex < result.numberOfVertices; ++vertexIndex) {
            UUID vertexId = result.vertices[vertexIndex];
            int groupId = result.vertexIndexToGroupId[vertexIndex];
            int layer = result.vertexIndexToLayer[vertexIndex];
            if (result.inputPorts[vertexIndex]) {
                this.graph.addInputPort(vertexId, this.portIdToOrder.getOrDefault(vertexId, -1), this.vertexIdToName.get(vertexId), groupId, this.vertexIdToSize.get(vertexId));
                continue;
            }
            if (result.outputPorts[vertexIndex]) {
                this.graph.addOutputPort(vertexId, this.portIdToOrder.getOrDefault(vertexId, -1), this.vertexIdToName.get(vertexId), layer, groupId, this.vertexIdToSize.get(vertexId));
                continue;
            }
            this.graph.addVertex(vertexId, VertexType.VERTEX_TYPE, this.vertexIdToName.get(vertexId), layer, groupId, this.vertexIdToSize.get(vertexId), this.vertexIdToFragmentTextSize.get(vertexId));
        }
        this.graph.reCalculateRoots();
        log.debug("Vertices were prepared...");
    }

    private void prepareEdges() {
        log.debug("Prepare the edges...");
        for (Map.Entry<UUID, Map.Entry<UUID, UUID>> edgeToNodesEntry : this.edgeToNodes.entrySet()) {
            UUID edgeId = edgeToNodesEntry.getKey();
            UUID srcVertexId = edgeToNodesEntry.getValue().getKey();
            UUID trgVertexId = edgeToNodesEntry.getValue().getValue();
            HierarchicalVertex srcVertex = this.graph.getVertexById(srcVertexId);
            HierarchicalVertex trgVertex = this.graph.getVertexById(trgVertexId);
            UUID srcPortId = this.edgeToSrcPort.get(edgeId);
            UUID trgPortId = this.edgeToTrgPort.get(edgeId);
            this.graph.addEdge(srcVertex, trgVertex, edgeId, srcPortId, trgPortId, this.portIdToOrder.getOrDefault(srcPortId, -1), this.portIdToOrder.getOrDefault(trgPortId, -1), this.portIdToPos.getOrDefault((Object)srcPortId, (Point)new Point((int)-1, (int)-1)).x, this.portIdToPos.getOrDefault((Object)trgPortId, (Point)new Point((int)-1, (int)-1)).x, this.portIdToSize.getOrDefault((Object)srcPortId, (Point)new Point((int)0, (int)0)).x, this.portIdToSize.getOrDefault((Object)trgPortId, (Point)new Point((int)0, (int)0)).x);
        }
        log.debug("The edges were prepared...");
    }

    private /* synthetic */ void lambda$prepareResult$3(4 convertToAdditionalPointsFunc, 3 convertToAdditionalPointFunc, Result result, HierarchicalBackwardEdge backwardEdge) {
        UUID edgeId = backwardEdge.getOriginalEdgeId();
        Result.OutputEdge outputEdge = new Result.OutputEdge(edgeId);
        outputEdge.setBackward(true);
        HierarchicalLongEdge topLongEdge = this.graph.getLongEdges().get(backwardEdge.getTopEdgeId());
        HierarchicalLongEdge bottomLongEdge = this.graph.getLongEdges().get(backwardEdge.getBottomEdgeId());
        HierarchicalLongEdge edgeBetweenCompanions = this.graph.getLongEdges().get(backwardEdge.getEdgeBetweenCompanionsId());
        if (topLongEdge != null && bottomLongEdge != null) {
            outputEdge.setSrcId(bottomLongEdge.getSrcVertex().getVertexId());
            outputEdge.setTrgId(topLongEdge.getTrgVertex().getVertexId());
            outputEdge.setSrcPosX(bottomLongEdge.getFirstEdge().getSrcPosX());
            outputEdge.setTrgPosX(topLongEdge.getLastEdge().getTrgPosX());
            outputEdge.topAdditionalPoints = convertToAdditionalPointsFunc.execute(topLongEdge.getFakeVertices());
            outputEdge.bottomAdditionalPoints = convertToAdditionalPointsFunc.execute(bottomLongEdge.getFakeVertices());
            outputEdge.additionalPoints = convertToAdditionalPointsFunc.execute(edgeBetweenCompanions.getFakeVertices());
        } else {
            HierarchicalEdge topEdge = this.graph.getEdgeById(backwardEdge.getTopEdgeId());
            HierarchicalEdge bottomEdge = this.graph.getEdgeById(backwardEdge.getBottomEdgeId());
            outputEdge.setSrcId(bottomEdge.getSrcVertex().getVertexId());
            outputEdge.setTrgId(topEdge.getTrgVertex().getVertexId());
            outputEdge.setSrcPosX(bottomEdge.getSrcPosX());
            outputEdge.setTrgPosX(topEdge.getTrgPosX());
            outputEdge.additionalPoints = convertToAdditionalPointsFunc.execute(edgeBetweenCompanions.getFakeVertices());
        }
        outputEdge.setSrcCompanion(convertToAdditionalPointFunc.apply(backwardEdge.getSrcCompanionVertex()));
        outputEdge.setTrgCompanion(convertToAdditionalPointFunc.apply(backwardEdge.getTrgCompanionVertex()));
        result.getEdges().put(edgeId, outputEdge);
    }

    private static /* synthetic */ void lambda$prepareResult$2(4 convertToAdditionalPointsFunc, Result result, HierarchicalLongEdge longEdge) {
        if (longEdge.isPartOfBackwardEdge()) {
            return;
        }
        UUID edgeId = longEdge.getOriginalEdgeId();
        Result.OutputEdge outputEdge = new Result.OutputEdge(edgeId);
        outputEdge.setSrcId(longEdge.getSrcVertex().getVertexId());
        outputEdge.setTrgId(longEdge.getTrgVertex().getVertexId());
        outputEdge.setSrcPosX(longEdge.getFirstEdge().getSrcPosX());
        outputEdge.setTrgPosX(longEdge.getLastEdge().getTrgPosX());
        outputEdge.additionalPoints = convertToAdditionalPointsFunc.execute(longEdge.getFakeVertices());
        result.getEdges().put(edgeId, outputEdge);
    }

    public static class Result {
        private final Map<UUID, OutputEdge> edges = new LinkedHashMap<UUID, OutputEdge>();
        private final Map<UUID, OutputVertex> vertices = new LinkedHashMap<UUID, OutputVertex>();
        private Point graphSize = new Point();
        private int crosses;

        public Map<UUID, OutputEdge> getEdges() {
            return this.edges;
        }

        public Map<UUID, OutputVertex> getVertices() {
            return this.vertices;
        }

        public Point getGraphSize() {
            return this.graphSize;
        }

        public void setGraphSize(Point graphSize) {
            this.graphSize = graphSize;
        }

        public int getCrosses() {
            return this.crosses;
        }

        public void setCrosses(int crosses) {
            this.crosses = crosses;
        }

        public static class OutputEdge {
            private final UUID edgeId;
            private UUID srcId;
            private UUID trgId;
            private boolean backward;
            private AdditionalPoint srcCompanion;
            private AdditionalPoint trgCompanion;
            private List<AdditionalPoint> additionalPoints = new ArrayList<AdditionalPoint>();
            private List<AdditionalPoint> topAdditionalPoints = new ArrayList<AdditionalPoint>();
            private List<AdditionalPoint> bottomAdditionalPoints = new ArrayList<AdditionalPoint>();
            private int srcPosX;
            private int trgPosX;

            OutputEdge(UUID edgeId) {
                this.edgeId = edgeId;
            }

            public int getTopPointX() {
                return this.topAdditionalPoints.get((int)0).pos.x;
            }

            public int getTopAdditionalPointX() {
                return this.additionalPoints.get((int)0).pos.x;
            }

            public int getBottomPointX() {
                return this.bottomAdditionalPoints.get((int)(this.bottomAdditionalPoints.size() - 1)).pos.x;
            }

            public int getBottomAdditionalPointX() {
                return this.additionalPoints.get((int)(this.additionalPoints.size() - 1)).pos.x;
            }

            public UUID getEdgeId() {
                return this.edgeId;
            }

            public UUID getSrcId() {
                return this.srcId;
            }

            public void setSrcId(UUID srcId) {
                this.srcId = srcId;
            }

            public UUID getTrgId() {
                return this.trgId;
            }

            public void setTrgId(UUID trgId) {
                this.trgId = trgId;
            }

            public boolean isBackward() {
                return this.backward;
            }

            public void setBackward(boolean backward) {
                this.backward = backward;
            }

            public AdditionalPoint getSrcCompanion() {
                return this.srcCompanion;
            }

            public void setSrcCompanion(AdditionalPoint srcCompanion) {
                this.srcCompanion = srcCompanion;
            }

            public AdditionalPoint getTrgCompanion() {
                return this.trgCompanion;
            }

            public void setTrgCompanion(AdditionalPoint trgCompanion) {
                this.trgCompanion = trgCompanion;
            }

            public List<AdditionalPoint> getAdditionalPoints() {
                return this.additionalPoints;
            }

            public void setAdditionalPoints(List<AdditionalPoint> additionalPoints) {
                this.additionalPoints = additionalPoints;
            }

            public List<AdditionalPoint> getTopAdditionalPoints() {
                return this.topAdditionalPoints;
            }

            public void setTopAdditionalPoints(List<AdditionalPoint> topAdditionalPoints) {
                this.topAdditionalPoints = topAdditionalPoints;
            }

            public List<AdditionalPoint> getBottomAdditionalPoints() {
                return this.bottomAdditionalPoints;
            }

            public void setBottomAdditionalPoints(List<AdditionalPoint> bottomAdditionalPoints) {
                this.bottomAdditionalPoints = bottomAdditionalPoints;
            }

            public int getSrcPosX() {
                return this.srcPosX;
            }

            public void setSrcPosX(int srcPosX) {
                this.srcPosX = srcPosX;
            }

            public int getTrgPosX() {
                return this.trgPosX;
            }

            public void setTrgPosX(int trgPosX) {
                this.trgPosX = trgPosX;
            }

            public static class AdditionalPoint {
                private int rowPosY;
                private Point pos;
                private Point size;

                public AdditionalPoint(int rowPosY, Point pos, Point size) {
                    this.rowPosY = rowPosY;
                    this.pos = pos;
                    this.size = size;
                }

                public float centerX() {
                    return (float)this.pos.x + (float)this.size.x / 2.0f;
                }

                public int roundCenterX() {
                    return Math.round(this.centerX());
                }

                public int xLeft() {
                    return this.pos.x;
                }

                public int xRight() {
                    return this.pos.x + this.size.x;
                }

                public int roundCenterY() {
                    return this.pos.y + this.size.y / 2;
                }

                public int yTop() {
                    return this.pos.y;
                }

                public int yBottom() {
                    return this.pos.y + this.size.y;
                }

                public int getRowPosY() {
                    return this.rowPosY;
                }

                public void setRowPosY(int rowPosY) {
                    this.rowPosY = rowPosY;
                }

                public Point getPos() {
                    return this.pos;
                }

                public void setPos(Point pos) {
                    this.pos = pos;
                }

                public Point getSize() {
                    return this.size;
                }

                public void setSize(Point size) {
                    this.size = size;
                }
            }
        }

        public static class OutputVertex
        implements Comparable<OutputVertex> {
            private final UUID vertexId;
            private int level;
            private int order;
            private int rowPosY;
            private Point pos;
            private Point size;

            OutputVertex(UUID vertexId, int level, int order, int rowPosY, Point pos, Point size) {
                this.vertexId = vertexId;
                this.level = level;
                this.order = order;
                this.rowPosY = rowPosY;
                this.pos = pos;
                this.size = size;
            }

            @Override
            public int compareTo(OutputVertex o) {
                return Integer.compare(this.order, o.getOrder());
            }

            public UUID getVertexId() {
                return this.vertexId;
            }

            public int getLevel() {
                return this.level;
            }

            public void setLevel(int level) {
                this.level = level;
            }

            public int getOrder() {
                return this.order;
            }

            public void setOrder(int order) {
                this.order = order;
            }

            public int getRowPosY() {
                return this.rowPosY;
            }

            public void setRowPosY(int rowPosY) {
                this.rowPosY = rowPosY;
            }

            public Point getPos() {
                return this.pos;
            }

            public void setPos(Point pos) {
                this.pos = pos;
            }

            public Point getSize() {
                return this.size;
            }

            public void setSize(Point size) {
                this.size = size;
            }
        }
    }
}

