/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical;

public class HierarchicalLayoutSettings {
    public static final int LEGACY_LAYERING_ALGORITHM = 1;
    public static final int CUSTOM_LAYERING_ALGORITHM = 2;
    public static final int GENERAL_CROSSING_REDUCTION_ALGORITHM = 0;
    public static final int LEGACY_CROSSING_REDUCTION_ALGORITHM = 1;
    public static final int CROSSING_REDUCTION_WITH_DEFAULT_ORDER_ALGORITHM = 3;
    public static final int CUSTOM_CROSSING_REDUCTION_ALGORITHM = 4;
    public static final int LEFT_ALIGNMENT_ALGORITHM = 1;
    public static final int GENERAL_ALIGNMENT_ALGORITHM = 3;
    public static final int LEGACY_ALIGNMENT_ALGORITHM = 4;
    public static final int ALIGNMENT_CUSTOM = 5;
    public static final int POLYLINE_ROUTING_STYLE = 0;
    public static final int ORTHOGONAL_ROUTING_STYLE = 1;
    public static final int SPLINE_ROUTING_STYLE = 2;
    public static final int FRAGMENT_LABEL_SHOW = 0;
    public static final int FRAGMENT_LABEL_HIDE = 1;
    public int minVSpaceBetweenPorts;
    public int minVSpaceBetweenRows;
    public int minHSpaceBetweenVertices;
    public int layeringAlgorithm;
    public int crossingReductionAlgorithm;
    public int alignment;
    public boolean collapseEdgeSrc;
    public boolean collapseEdgeTrg;
    public int routingStyle;
    public int fragmentLabel;

    public static HierarchicalLayoutSettingsBuilder builder() {
        return new HierarchicalLayoutSettingsBuilder();
    }

    public HierarchicalLayoutSettings() {
    }

    public HierarchicalLayoutSettings(int minVSpaceBetweenPorts, int minVSpaceBetweenRows, int minHSpaceBetweenVertices, int layeringAlgorithm, int crossingReductionAlgorithm, int alignment, boolean collapseEdgeSrc, boolean collapseEdgeTrg, int routingStyle, int fragmentLabel) {
        this.minVSpaceBetweenPorts = minVSpaceBetweenPorts;
        this.minVSpaceBetweenRows = minVSpaceBetweenRows;
        this.minHSpaceBetweenVertices = minHSpaceBetweenVertices;
        this.layeringAlgorithm = layeringAlgorithm;
        this.crossingReductionAlgorithm = crossingReductionAlgorithm;
        this.alignment = alignment;
        this.collapseEdgeSrc = collapseEdgeSrc;
        this.collapseEdgeTrg = collapseEdgeTrg;
        this.routingStyle = routingStyle;
        this.fragmentLabel = fragmentLabel;
    }

    public static class HierarchicalLayoutSettingsBuilder {
        private int minVSpaceBetweenPorts;
        private int minVSpaceBetweenRows;
        private int minHSpaceBetweenVertices;
        private int layeringAlgorithm;
        private int crossingReductionAlgorithm;
        private int alignment;
        private boolean collapseEdgeSrc;
        private boolean collapseEdgeTrg;
        private int routingStyle;
        private int fragmentLabel;

        HierarchicalLayoutSettingsBuilder() {
        }

        public HierarchicalLayoutSettingsBuilder minVSpaceBetweenPorts(int minVSpaceBetweenPorts) {
            this.minVSpaceBetweenPorts = minVSpaceBetweenPorts;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder minVSpaceBetweenRows(int minVSpaceBetweenRows) {
            this.minVSpaceBetweenRows = minVSpaceBetweenRows;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder minHSpaceBetweenVertices(int minHSpaceBetweenVertices) {
            this.minHSpaceBetweenVertices = minHSpaceBetweenVertices;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder layeringAlgorithm(int layeringAlgorithm) {
            this.layeringAlgorithm = layeringAlgorithm;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder crossingReductionAlgorithm(int crossingReductionAlgorithm) {
            this.crossingReductionAlgorithm = crossingReductionAlgorithm;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder alignment(int alignment) {
            this.alignment = alignment;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder collapseEdgeSrc(boolean collapseEdgeSrc) {
            this.collapseEdgeSrc = collapseEdgeSrc;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder collapseEdgeTrg(boolean collapseEdgeTrg) {
            this.collapseEdgeTrg = collapseEdgeTrg;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder routingStyle(int routingStyle) {
            this.routingStyle = routingStyle;
            return this;
        }

        public HierarchicalLayoutSettingsBuilder fragmentLabel(int fragmentLabel) {
            this.fragmentLabel = fragmentLabel;
            return this;
        }

        public HierarchicalLayoutSettings build() {
            return new HierarchicalLayoutSettings(this.minVSpaceBetweenPorts, this.minVSpaceBetweenRows, this.minHSpaceBetweenVertices, this.layeringAlgorithm, this.crossingReductionAlgorithm, this.alignment, this.collapseEdgeSrc, this.collapseEdgeTrg, this.routingStyle, this.fragmentLabel);
        }

        public String toString() {
            return "HierarchicalLayoutSettings.HierarchicalLayoutSettingsBuilder(minVSpaceBetweenPorts=" + this.minVSpaceBetweenPorts + ", minVSpaceBetweenRows=" + this.minVSpaceBetweenRows + ", minHSpaceBetweenVertices=" + this.minHSpaceBetweenVertices + ", layeringAlgorithm=" + this.layeringAlgorithm + ", crossingReductionAlgorithm=" + this.crossingReductionAlgorithm + ", alignment=" + this.alignment + ", collapseEdgeSrc=" + this.collapseEdgeSrc + ", collapseEdgeTrg=" + this.collapseEdgeTrg + ", routingStyle=" + this.routingStyle + ", fragmentLabel=" + this.fragmentLabel + ")";
        }
    }
}

