/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout.hierarchical;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.common.JsonUtils;
import vg.lib.layout.hierarchical.HierarchicalLayoutSettings;
import vg.lib.layout.hierarchical.HierarchicalPlainLayout;
import vg.lib.model.graphics.EdgeGraphics;
import vg.lib.model.graphics.VertexGraphics;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecord;
import vg.lib.model.record.AttributeRecordType;
import vg.lib.model.record.VertexRecord;
import vg.lib.operation.Operation;
import vg.lib.storage.GraphStorage;
import vg.lib.view.GraphViewUtils;

public class HierarchicalLayout
implements Operation<Integer> {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalLayout.class);
    private final GraphStorage graphStorage;
    private final HierarchicalLayoutSettings settings;

    public HierarchicalLayout(GraphStorage graphStorage, HierarchicalLayoutSettings settings) {
        this.graphStorage = graphStorage;
        this.settings = settings;
    }

    @Override
    public Integer execute() {
        HashMap portIdToOrder = new HashMap();
        HashMap portIdToPos = new HashMap();
        HashMap portIdToSize = new HashMap();
        ArrayList<Integer> parentIds = new ArrayList<Integer>();
        int graphModelId = this.graphStorage.findGraphModelRecords().get(0).getId();
        AtomicInteger order = new AtomicInteger(1);
        this.graphStorage.dfs(graphModelId, -1, graphModelRecord -> {}, graphModelRecord -> {}, vertexRecord -> {}, vertexRecord -> {
            boolean isFakePort;
            List<AttributeRecord> vertexAttributeRecords = this.graphStorage.findAttributeRecordsByOwner(graphModelId, vertexRecord.getId(), AttributeOwnerType.VERTEX);
            AttributeRecord vertexTypeAttributeRecord = GraphStorage.findVertexTypeAttributeRecord(vertexAttributeRecords).orElseThrow(IllegalArgumentException::new);
            boolean isPort = (vertexTypeAttributeRecord.getIntegerValue() & 0x80) > 0;
            boolean bl = isFakePort = (vertexTypeAttributeRecord.getIntegerValue() & 0x40) > 0;
            if (isPort && !isFakePort) {
                portIdToOrder.put(vertexRecord.getGlobalId(), order.getAndIncrement());
            }
        }, edgeRecord -> {});
        AtomicLong crosses = new AtomicLong();
        this.graphStorage.dfs(graphModelId, -1, graphModelRecord -> {}, graphModelRecord -> {
            int re = this.executePlainLayout(graphModelId, -1, this.graphStorage, portIdToOrder, portIdToPos, portIdToSize);
            crosses.addAndGet(re);
        }, vertexRecord -> {
            if (!vertexRecord.isComposite()) {
                return;
            }
            parentIds.add(vertexRecord.getId());
        }, vertexRecord -> {
            if (!vertexRecord.isComposite()) {
                return;
            }
            int re = this.executePlainLayout(graphModelId, vertexRecord.getId(), this.graphStorage, portIdToOrder, portIdToPos, portIdToSize);
            crosses.addAndGet(re);
        }, edgeRecord -> {});
        parentIds.forEach(parentId -> {
            List<AttributeRecord> parentAttributeRecords = this.graphStorage.findAttributeRecordsByOwner(graphModelId, (int)parentId, AttributeOwnerType.VERTEX);
            VertexGraphics parentVertexGraphics = GraphStorage.findVertexGraphicsAttributeRecord(parentAttributeRecords).map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            Rectangle parentBoundingBox = parentVertexGraphics.getBoundingBox();
            int parentX = parentBoundingBox.x;
            int parentY = parentBoundingBox.y;
            int border = parentVertexGraphics.getBorder();
            this.graphStorage.findVertexRecordsByParentId(graphModelId, (int)parentId).forEach(vertexRecord -> {
                VertexGraphics vertexGraphics = this.graphStorage.findAttributeRecordByOwnerAndName(graphModelId, vertexRecord.getId(), AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
                Rectangle vertexBoundingBox = vertexGraphics.getBoundingBox();
                int vertexX = vertexBoundingBox.x + parentX + border;
                int vertexY = vertexBoundingBox.y + parentY + border;
                vertexBoundingBox.x = vertexX;
                vertexBoundingBox.y = vertexY;
                this.graphStorage.createOrUpdateVertexAttribute(graphModelId, vertexRecord.getId(), "system_vertex_graphics", JsonUtils.toJson(vertexGraphics), AttributeRecordType.JSON, false);
            });
            this.graphStorage.findEdgeRecordsByParentId(graphModelId, (int)parentId, false).forEach(edgeRecord -> {
                EdgeGraphics edgeGraphics = this.graphStorage.findAttributeRecordByOwnerAndName(graphModelId, edgeRecord.getId(), AttributeOwnerType.EDGE, "system_edge_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), EdgeGraphics.class)).orElseThrow(IllegalArgumentException::new);
                edgeGraphics.getPoints().forEach(point -> {
                    point.x = point.x + parentX + border;
                    point.y = point.y + parentY + border;
                });
                edgeGraphics.getBoundingBox().x = edgeGraphics.getBoundingBox().x + parentX + border;
                edgeGraphics.getBoundingBox().y = edgeGraphics.getBoundingBox().y + parentY + border;
                this.graphStorage.createOrUpdateEdgeAttribute(graphModelId, edgeRecord.getId(), "system_edge_graphics", JsonUtils.toJson(edgeGraphics), AttributeRecordType.JSON, false);
            });
        });
        return crosses.intValue();
    }

    private int executePlainLayout(int graphModelId, int parentId, GraphStorage graphStorage, Map<UUID, Integer> portIdToIndex, Map<UUID, Point> portIdToPos, Map<UUID, Point> portIdToSize) {
        ArrayList<UUID> vertexIds = new ArrayList<UUID>();
        ArrayList<UUID> inputPortIds = new ArrayList<UUID>();
        ArrayList<UUID> outputPortIds = new ArrayList<UUID>();
        LinkedHashMap<UUID, Point> vertexIdToSize = new LinkedHashMap<UUID, Point>();
        LinkedHashMap<UUID, Point> vertexIdToFragmentTextSize = new LinkedHashMap<UUID, Point>();
        LinkedHashMap<UUID, String> vertexIdToName = new LinkedHashMap<UUID, String>();
        HashMap<Integer, UUID> vertexIdToGlobalId = new HashMap<Integer, UUID>();
        HashMap<UUID, Integer> vertexGlobalIdToId = new HashMap<UUID, Integer>();
        HashSet portIds = new HashSet();
        graphStorage.findVertexRecordsByParentId(graphModelId, parentId).forEach(vertexRecord -> {
            boolean isOutputPort;
            vertexIdToGlobalId.put(vertexRecord.getId(), vertexRecord.getGlobalId());
            vertexGlobalIdToId.put(vertexRecord.getGlobalId(), vertexRecord.getId());
            vertexIds.add(vertexRecord.getGlobalId());
            List<AttributeRecord> vertexAttributeRecords = graphStorage.findAttributeRecordsByOwner(graphModelId, vertexRecord.getId(), AttributeOwnerType.VERTEX);
            Integer vertexType = GraphStorage.findVertexTypeAttributeRecord(vertexAttributeRecords).map(AttributeRecord::getIntegerValue).orElseThrow(IllegalArgumentException::new);
            boolean isPort = (vertexType & 0x80) > 0;
            boolean bl = isOutputPort = (vertexType & 0x10) > 0;
            if (isPort) {
                portIds.add(vertexRecord.getGlobalId());
                if (isOutputPort) {
                    outputPortIds.add(vertexRecord.getGlobalId());
                } else {
                    inputPortIds.add(vertexRecord.getGlobalId());
                }
            }
            VertexGraphics vertexGraphics = GraphStorage.findVertexGraphicsAttributeRecord(vertexAttributeRecords).map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            Rectangle vertexBoundingBox = vertexGraphics.getBoundingBox();
            Point size = new Point(vertexBoundingBox.width, vertexBoundingBox.height);
            vertexIdToSize.put(vertexRecord.getGlobalId(), size);
            vertexIdToName.put(vertexRecord.getGlobalId(), "");
        });
        VertexRecord parentVertexRecord = graphStorage.findVertexRecord(graphModelId, parentId).orElse(null);
        boolean isVertexWithPorts = false;
        if (parentVertexRecord != null) {
            boolean containsNestedGraph;
            List<AttributeRecord> parentAttributeRecords = graphStorage.findAttributeRecordsByOwner(graphModelId, parentId, AttributeOwnerType.VERTEX);
            Integer parentType = GraphStorage.findVertexTypeAttributeRecord(parentAttributeRecords).map(AttributeRecord::getIntegerValue).orElseThrow(IllegalArgumentException::new);
            boolean containsPorts = (parentType & 2) > 0;
            boolean bl = containsNestedGraph = (parentType & 4) > 0;
            if (containsPorts && !containsNestedGraph) {
                VertexGraphics parentVertexGraphics = GraphStorage.findVertexGraphicsAttributeRecord(parentAttributeRecords).map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
                isVertexWithPorts = true;
                int width = parentVertexGraphics.getLabel().getWidth();
                int height = parentVertexGraphics.getLabel().getHeight();
                vertexIdToGlobalId.put(parentVertexRecord.getId(), parentVertexRecord.getGlobalId());
                vertexGlobalIdToId.put(parentVertexRecord.getGlobalId(), parentVertexRecord.getId());
                vertexIds.add(parentVertexRecord.getGlobalId());
                vertexIdToSize.put(parentVertexRecord.getGlobalId(), new Point(width, height));
                vertexIdToName.put(parentVertexRecord.getGlobalId(), "");
            }
        }
        LinkedHashMap<UUID, Map.Entry<UUID, UUID>> edgeToNodes = new LinkedHashMap<UUID, Map.Entry<UUID, UUID>>();
        LinkedHashMap<UUID, UUID> edgeToSrcPort = new LinkedHashMap<UUID, UUID>();
        LinkedHashMap<UUID, UUID> edgeToTrgPort = new LinkedHashMap<UUID, UUID>();
        HashMap edgeGlobalIdToId = new HashMap();
        graphStorage.findEdgeRecordsByParentId(graphModelId, parentId, false).forEach(edgeRecord -> {
            edgeGlobalIdToId.put(edgeRecord.getGlobalId(), edgeRecord.getId());
            List<AttributeRecord> edgeAttributeRecords = graphStorage.findAttributeRecordsByOwner(graphModelId, edgeRecord.getId(), AttributeOwnerType.EDGE);
            UUID sourcePortGlobalId = GraphStorage.findEdgeStorageSourcePortGlobalIdAttributeRecord(edgeAttributeRecords).map(AttributeRecord::getUUIDValue).orElse(null);
            UUID targetPortGlobalId = GraphStorage.findEdgeStorageTargetPortGlobalIdAttributeRecord(edgeAttributeRecords).map(AttributeRecord::getUUIDValue).orElse(null);
            if (sourcePortGlobalId != null) {
                edgeToSrcPort.put(edgeRecord.getGlobalId(), sourcePortGlobalId);
            }
            if (targetPortGlobalId != null) {
                edgeToTrgPort.put(edgeRecord.getGlobalId(), targetPortGlobalId);
            }
            UUID sourceId = (UUID)vertexIdToGlobalId.get(edgeRecord.getSourceId());
            UUID targetId = (UUID)vertexIdToGlobalId.get(edgeRecord.getTargetId());
            if (sourceId == null) {
                throw new IllegalArgumentException("Source id is null");
            }
            if (targetId == null) {
                throw new IllegalArgumentException("Target id is null");
            }
            edgeToNodes.put(edgeRecord.getGlobalId(), new AbstractMap.SimpleEntry<UUID, UUID>(sourceId, targetId));
        });
        log.debug("Prepare data and execute hierarchical layout, number of vertices {}, number of edges {}.", (Object)vertexIds.size(), (Object)edgeToNodes.size());
        HierarchicalPlainLayout.Result result = new HierarchicalPlainLayout(vertexIds, inputPortIds, outputPortIds, edgeToNodes, edgeToSrcPort, edgeToTrgPort, portIdToIndex, portIdToPos, portIdToSize, vertexIdToName, vertexIdToSize, vertexIdToFragmentTextSize, this.settings).execute();
        int parentLabelWidth = 0;
        if (parentVertexRecord != null) {
            VertexGraphics parentVertexGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, parentId, AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            parentVertexGraphics.setShapeType(VertexGraphics.ShapeType.RECTANGLE);
            if (this.settings.fragmentLabel == 0 && !isVertexWithPorts) {
                parentLabelWidth = parentVertexGraphics.getLabel().getWidth() + parentVertexGraphics.getBorder();
                parentVertexGraphics.getLabel().setVisible(true);
            }
            if (this.settings.fragmentLabel == 1 && !isVertexWithPorts) {
                parentVertexGraphics.getLabel().setVisible(false);
            }
            if (!isVertexWithPorts) {
                parentVertexGraphics.getLabel().setAlignment(VertexGraphics.LabelAlignment.LEFT);
            }
            int parentWidth = result.getGraphSize().x + 2 * parentVertexGraphics.getBorder() + parentLabelWidth;
            int parentHeight = result.getGraphSize().y + 2 * parentVertexGraphics.getBorder();
            parentVertexGraphics.getBoundingBox().width = parentWidth;
            parentVertexGraphics.getBoundingBox().height = parentHeight;
            graphStorage.createOrUpdateVertexAttribute(graphModelId, parentId, "system_vertex_graphics", JsonUtils.toJson(parentVertexGraphics), AttributeRecordType.JSON, false);
        }
        for (HierarchicalPlainLayout.Result.OutputVertex outputVertex : result.getVertices().values()) {
            int x = outputVertex.getPos().x;
            int y = outputVertex.getPos().y;
            Integer vertexId = (Integer)vertexGlobalIdToId.get(outputVertex.getVertexId());
            VertexGraphics vertexGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, vertexId, AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            if (isVertexWithPorts && vertexId == parentId) {
                int vertexLabelWidth;
                int border = vertexGraphics.getBorder();
                int width = result.getGraphSize().x + border * 2;
                int offsetX = (width - (vertexLabelWidth = vertexGraphics.getLabel().getWidth())) / 2;
                if (offsetX < border) {
                    offsetX = border;
                }
                int offsetY = outputVertex.getPos().y;
                vertexGraphics.getLabelOffset().x = offsetX;
                vertexGraphics.getLabelOffset().y = offsetY;
            } else {
                vertexGraphics.getBoundingBox().x = x + parentLabelWidth;
                vertexGraphics.getBoundingBox().y = y;
            }
            graphStorage.createOrUpdateVertexAttribute(graphModelId, vertexId, "system_vertex_graphics", JsonUtils.toJson(vertexGraphics), AttributeRecordType.JSON, false);
            if (!portIds.contains(outputVertex.getVertexId())) continue;
            Rectangle vertexBoundingBox = vertexGraphics.getBoundingBox();
            Point pos = new Point(vertexBoundingBox.x, vertexBoundingBox.y);
            Point size = new Point(vertexBoundingBox.width, vertexBoundingBox.height);
            portIdToPos.put(outputVertex.getVertexId(), pos);
            portIdToSize.put(outputVertex.getVertexId(), size);
        }
        for (HierarchicalPlainLayout.Result.OutputEdge outputEdge : result.getEdges().values()) {
            HierarchicalPlainLayout.Result.OutputVertex outputSrcVertex = result.getVertices().get(outputEdge.getSrcId());
            HierarchicalPlainLayout.Result.OutputVertex outputTrgVertex = result.getVertices().get(outputEdge.getTrgId());
            Integer edgeId = (Integer)edgeGlobalIdToId.get(outputEdge.getEdgeId());
            EdgeGraphics edgeGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, edgeId, AttributeOwnerType.EDGE, "system_edge_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), EdgeGraphics.class)).orElseThrow(IllegalArgumentException::new);
            Integer srcVertexId = (Integer)vertexGlobalIdToId.get(outputEdge.getSrcId());
            VertexGraphics srcVertexGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, srcVertexId, AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            Integer trgVertexId = (Integer)vertexGlobalIdToId.get(outputEdge.getTrgId());
            VertexGraphics trgVertexGraphics = graphStorage.findAttributeRecordByOwnerAndName(graphModelId, trgVertexId, AttributeOwnerType.VERTEX, "system_vertex_graphics").map(it -> JsonUtils.fromJson(it.getStringValue(), VertexGraphics.class)).orElseThrow(IllegalArgumentException::new);
            if (outputEdge.isBackward()) {
                edgeGraphics.setLineType(EdgeGraphics.LineType.DASHED);
                edgeGraphics.setPoints(this.handleBackwardEdge(outputEdge, outputSrcVertex, outputTrgVertex, this.settings, srcVertexGraphics, trgVertexGraphics, parentLabelWidth));
            } else {
                edgeGraphics.setLineType(EdgeGraphics.LineType.SOLID);
                edgeGraphics.setPoints(this.handleForwardEdge(outputEdge, outputSrcVertex, outputTrgVertex, this.settings, srcVertexGraphics, trgVertexGraphics, parentLabelWidth));
            }
            GraphViewUtils.EdgeLabelPlacement edgeBoundingBoxAndLabelOffset = GraphViewUtils.calculateEdgeBoundingBoxAndLabelOffset(edgeGraphics.getPoints(), edgeGraphics.getLabel().getWidth(), edgeGraphics.getLabel().getHeight());
            edgeGraphics.setBoundingBox(edgeBoundingBoxAndLabelOffset.boundingBox());
            edgeGraphics.setLabelOffset(edgeBoundingBoxAndLabelOffset.labelOffset());
            graphStorage.createOrUpdateEdgeAttribute(graphModelId, edgeId, "system_edge_graphics", JsonUtils.toJson(edgeGraphics), AttributeRecordType.JSON, false);
        }
        return result.getCrosses();
    }

    private List<Point> handleForwardEdge(HierarchicalPlainLayout.Result.OutputEdge outputEdge, HierarchicalPlainLayout.Result.OutputVertex outputSrcVertex, HierarchicalPlainLayout.Result.OutputVertex outputTrgVertex, HierarchicalLayoutSettings settings, VertexGraphics srcVertexGraphics, VertexGraphics trgVertexGraphics, int parentLabelWidth) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(outputSrcVertex.getPos().x + outputEdge.getSrcPosX(), outputSrcVertex.getPos().y + outputSrcVertex.getSize().y));
        for (HierarchicalPlainLayout.Result.OutputEdge.AdditionalPoint additionalPoint : outputEdge.getAdditionalPoints()) {
            points.add(new Point(Math.round(additionalPoint.centerX()), additionalPoint.getRowPosY()));
            points.add(new Point(Math.round(additionalPoint.centerX()), additionalPoint.roundCenterY()));
            points.add(new Point(Math.round(additionalPoint.centerX()), additionalPoint.getPos().y + additionalPoint.getSize().y));
        }
        points.add(new Point(outputTrgVertex.getPos().x + outputEdge.getTrgPosX(), outputTrgVertex.getPos().y));
        for (Point point : points) {
            point.x += parentLabelWidth;
        }
        Point startPoint = (Point)points.get(0);
        Point newStartPoint = GraphViewUtils.findPointOnVertexShape(GraphViewUtils.DirectionType.VERTICAL, srcVertexGraphics.getShapeType(), srcVertexGraphics.getBoundingBox(), startPoint);
        startPoint.x = newStartPoint.x;
        startPoint.y = newStartPoint.y;
        Point endPoint = (Point)points.get(points.size() - 1);
        Point newEndPoint = GraphViewUtils.findPointOnVertexShape(GraphViewUtils.DirectionType.VERTICAL, trgVertexGraphics.getShapeType(), trgVertexGraphics.getBoundingBox(), endPoint);
        endPoint.x = newEndPoint.x;
        endPoint.y = newEndPoint.y;
        if (settings.routingStyle == 2) {
            return GraphViewUtils.splineInterpolation(points);
        }
        return points;
    }

    private List<Point> handleBackwardEdge(HierarchicalPlainLayout.Result.OutputEdge outputEdge, HierarchicalPlainLayout.Result.OutputVertex outputSrcVertex, HierarchicalPlainLayout.Result.OutputVertex outputTrgVertex, HierarchicalLayoutSettings settings, VertexGraphics srcVertexGraphics, VertexGraphics trgVertexGraphics, int parentLabelWidth) {
        Point newEndPoint;
        Point endPoint;
        Point newStartPoint;
        int dx;
        float DX_P = 0.5f;
        ArrayList<Point> bottomPoints = new ArrayList<Point>();
        bottomPoints.add(new Point(outputSrcVertex.getPos().x + outputEdge.getSrcPosX(), outputSrcVertex.getPos().y + outputSrcVertex.getSize().y));
        for (HierarchicalPlainLayout.Result.OutputEdge.AdditionalPoint additionalPoint : outputEdge.getBottomAdditionalPoints()) {
            bottomPoints.add(new Point(additionalPoint.roundCenterX(), additionalPoint.yTop()));
            bottomPoints.add(new Point(additionalPoint.roundCenterX(), additionalPoint.roundCenterY()));
        }
        if (!outputEdge.getBottomAdditionalPoints().isEmpty() && settings.routingStyle == 2) {
            HierarchicalPlainLayout.Result.OutputEdge.AdditionalPoint bottomPoint = outputEdge.getBottomAdditionalPoints().get(outputEdge.getBottomAdditionalPoints().size() - 1);
            int dx2 = Math.round((float)outputEdge.getSrcCompanion().getSize().x * DX_P);
            if (outputEdge.getBottomPointX() < outputEdge.getBottomAdditionalPointX()) {
                bottomPoints.add(new Point(bottomPoint.roundCenterX() + dx2, bottomPoint.yBottom()));
            } else {
                bottomPoints.add(new Point(bottomPoint.roundCenterX() - dx2, bottomPoint.yBottom()));
            }
        } else {
            bottomPoints.add(new Point(outputEdge.getSrcCompanion().roundCenterX(), outputEdge.getSrcCompanion().roundCenterY()));
        }
        ArrayList<Point> middlePoints = new ArrayList<Point>();
        if (!outputEdge.getAdditionalPoints().isEmpty() && settings.routingStyle == 2) {
            HierarchicalPlainLayout.Result.OutputEdge.AdditionalPoint topPoint = outputEdge.getAdditionalPoints().get(0);
            dx = Math.round((float)outputEdge.getTrgCompanion().getSize().x * DX_P);
            if (outputEdge.getTopPointX() > outputEdge.getTopAdditionalPointX()) {
                middlePoints.add(new Point(topPoint.roundCenterX() + dx, topPoint.yTop()));
            } else {
                middlePoints.add(new Point(topPoint.roundCenterX() - dx, topPoint.yTop()));
            }
        }
        for (HierarchicalPlainLayout.Result.OutputEdge.AdditionalPoint additionalPoint : outputEdge.getAdditionalPoints()) {
            middlePoints.add(new Point(additionalPoint.roundCenterX(), additionalPoint.roundCenterY()));
        }
        if (!outputEdge.getAdditionalPoints().isEmpty() && settings.routingStyle == 2) {
            HierarchicalPlainLayout.Result.OutputEdge.AdditionalPoint bottomPoint = outputEdge.getAdditionalPoints().get(outputEdge.getAdditionalPoints().size() - 1);
            dx = Math.round((float)outputEdge.getSrcCompanion().getSize().x * DX_P);
            if (outputEdge.getBottomPointX() < outputEdge.getBottomAdditionalPointX()) {
                middlePoints.add(new Point(bottomPoint.roundCenterX() - dx, bottomPoint.yBottom()));
            } else {
                middlePoints.add(new Point(bottomPoint.roundCenterX() + dx, bottomPoint.yBottom()));
            }
        }
        Collections.reverse(middlePoints);
        ArrayList<Point> topPoints = new ArrayList<Point>();
        if (!outputEdge.getTopAdditionalPoints().isEmpty() && settings.routingStyle == 2) {
            HierarchicalPlainLayout.Result.OutputEdge.AdditionalPoint topPoint = outputEdge.getTopAdditionalPoints().get(0);
            int dx3 = Math.round((float)outputEdge.getTrgCompanion().getSize().x * DX_P);
            if (outputEdge.getTopPointX() > outputEdge.getTopAdditionalPointX()) {
                topPoints.add(new Point(topPoint.roundCenterX() - dx3, topPoint.yTop()));
            } else {
                topPoints.add(new Point(topPoint.roundCenterX() + dx3, topPoint.yTop()));
            }
        } else {
            topPoints.add(new Point(outputEdge.getTrgCompanion().roundCenterX(), outputEdge.getTrgCompanion().roundCenterY()));
        }
        for (HierarchicalPlainLayout.Result.OutputEdge.AdditionalPoint additionalPoint : outputEdge.getTopAdditionalPoints()) {
            topPoints.add(new Point(additionalPoint.roundCenterX(), additionalPoint.roundCenterY()));
            topPoints.add(new Point(additionalPoint.roundCenterX(), additionalPoint.yBottom()));
        }
        topPoints.add(new Point(outputTrgVertex.getPos().x + outputEdge.getTrgPosX(), outputTrgVertex.getPos().y));
        ArrayList<Point> points = new ArrayList<Point>();
        points.addAll(bottomPoints);
        points.addAll(middlePoints);
        points.addAll(topPoints);
        for (Point point : points) {
            point.x += parentLabelWidth;
        }
        Point startPoint = (Point)points.get(0);
        if (!GraphViewUtils.arePointsTooClose(startPoint, newStartPoint = GraphViewUtils.findPointOnVertexShape(GraphViewUtils.DirectionType.VERTICAL, srcVertexGraphics.getShapeType(), srcVertexGraphics.getBoundingBox(), startPoint), 2)) {
            points.add(0, newStartPoint);
        }
        if (!GraphViewUtils.arePointsTooClose(endPoint = (Point)points.get(points.size() - 1), newEndPoint = GraphViewUtils.findPointOnVertexShape(GraphViewUtils.DirectionType.VERTICAL, trgVertexGraphics.getShapeType(), trgVertexGraphics.getBoundingBox(), endPoint), 2)) {
            points.add(newEndPoint);
        }
        if (settings.routingStyle == 2) {
            return GraphViewUtils.splineInterpolation(points);
        }
        return points;
    }
}

