/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedHashMap;
import java.util.UUID;

public class LayoutResult {
    private LinkedHashMap<UUID, Vertex> vertices;
    private LinkedHashMap<UUID, Edge> edges;
    private Dimension boundingBoxSize;

    LayoutResult(LinkedHashMap<UUID, Vertex> vertices, LinkedHashMap<UUID, Edge> edges, Dimension boundingBoxSize) {
        this.vertices = vertices;
        this.edges = edges;
        this.boundingBoxSize = boundingBoxSize;
    }

    public static LayoutResultBuilder builder() {
        return new LayoutResultBuilder();
    }

    public LinkedHashMap<UUID, Vertex> getVertices() {
        return this.vertices;
    }

    public LinkedHashMap<UUID, Edge> getEdges() {
        return this.edges;
    }

    public Dimension getBoundingBoxSize() {
        return this.boundingBoxSize;
    }

    public static class LayoutResultBuilder {
        private LinkedHashMap<UUID, Vertex> vertices;
        private LinkedHashMap<UUID, Edge> edges;
        private Dimension boundingBoxSize;

        LayoutResultBuilder() {
        }

        public LayoutResultBuilder vertices(LinkedHashMap<UUID, Vertex> vertices) {
            this.vertices = vertices;
            return this;
        }

        public LayoutResultBuilder edges(LinkedHashMap<UUID, Edge> edges) {
            this.edges = edges;
            return this;
        }

        public LayoutResultBuilder boundingBoxSize(Dimension boundingBoxSize) {
            this.boundingBoxSize = boundingBoxSize;
            return this;
        }

        public LayoutResult build() {
            return new LayoutResult(this.vertices, this.edges, this.boundingBoxSize);
        }

        public String toString() {
            return "LayoutResult.LayoutResultBuilder(vertices=" + this.vertices + ", edges=" + this.edges + ", boundingBoxSize=" + this.boundingBoxSize + ")";
        }
    }

    public record Edge(UUID globalId, UUID sourceGlobalId, UUID targetGlobalId, Point[] points) {
    }

    public record Vertex(UUID globalId, Point position, Dimension size) {
    }
}

