/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.encoder.graphml;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import lombok.NonNull;
import vg.lib.encoder.GraphEncoder;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecord;
import vg.lib.model.record.EdgeRecord;
import vg.lib.model.record.GraphModelRecord;
import vg.lib.model.record.VertexRecord;
import vg.lib.storage.GraphStorage;

public class GraphMLEncoder
extends GraphEncoder {
    private static final int TAB_SIZE = 4;
    private static final String GRAPHML = "graphml";
    private static final String GRAPH = "graph";
    private static final String NODE = "node";
    private static final String PORT = "port";
    private static final String EDGE = "edge";
    private static final String DATA = "data";
    private static final String ID = "id";
    private static final String KEY = "key";
    private static final String DIRECTED = "directed";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String SOURCE_PORT = "sourceport";
    private static final String TARGET_PORT = "targetport";
    private final Map<Integer, List<AttributeRecord>> vertexIdToCachedAttributes;
    private final Map<Integer, List<AttributeRecord>> edgeIdToCachedAttributes;

    public GraphMLEncoder(int graphModelId, int parentId, @NonNull GraphStorage graphStorage, @NonNull OutputStream outputStream) {
        super(graphModelId, parentId, graphStorage, outputStream);
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        this.vertexIdToCachedAttributes = new HashMap<Integer, List<AttributeRecord>>();
        this.edgeIdToCachedAttributes = new HashMap<Integer, List<AttributeRecord>>();
    }

    @Override
    public void encode() throws GraphEncoder.GraphEncoderException {
        try {
            this.doEncode();
        }
        catch (Exception ex) {
            throw new GraphEncoder.GraphEncoderException(ex);
        }
    }

    private void doEncode() throws Exception {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(this.outputStream, "UTF-8");
        AtomicInteger indent = new AtomicInteger(0);
        this.graphStorage.dfs(this.graphModelId, this.parentId, graphModelRecord -> this.writeGraphModel(writer, indent, (GraphModelRecord)graphModelRecord, false), graphModelRecord -> this.writeGraphModel(writer, indent, (GraphModelRecord)graphModelRecord, true), vertexRecord -> this.writeVertex(writer, indent, (VertexRecord)vertexRecord, false), vertexRecord -> this.writeVertex(writer, indent, (VertexRecord)vertexRecord, true), edgeRecord -> this.writeEdge(writer, indent, (EdgeRecord)edgeRecord), null, this.vertexIdToCachedAttributes, this.edgeIdToCachedAttributes);
    }

    private void writeGraphModel(XMLStreamWriter writer, AtomicInteger indent, GraphModelRecord graphModelRecord, boolean isEnd) {
        boolean isGraphTagRequired = this.graphStorage.findVertexRecordsByParentId(this.graphModelId, this.parentId).stream().anyMatch(it -> !it.isComposite());
        if (isEnd) {
            if (isGraphTagRequired) {
                this.writeEndElement(writer, indent);
            }
            this.writeEndElement(writer, indent);
        } else {
            this.writeStartElement(writer, indent, GRAPHML, List.of());
            if (isGraphTagRequired) {
                this.writeStartElement(writer, indent, GRAPH, this.buildElementIdAttribute(graphModelRecord.getName()));
            }
        }
    }

    private void writeVertex(XMLStreamWriter writer, AtomicInteger indent, VertexRecord vertexRecord, boolean isEnd) {
        List<AttributeRecord> attributeRecords = this.vertexIdToCachedAttributes.get(vertexRecord.getId());
        if (attributeRecords == null) {
            attributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, vertexRecord.getId(), AttributeOwnerType.VERTEX);
            this.vertexIdToCachedAttributes.put(vertexRecord.getId(), attributeRecords);
        }
        Integer vertexType = GraphStorage.findVertexTypeAttributeRecord(attributeRecords).map(AttributeRecord::getIntegerValue).orElse(8);
        String vertexId = GraphStorage.findVertexOriginalIdAttributeRecord(attributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        String nestedGraphId = GraphStorage.findVertexNestedGraphOriginalIdAttributeRecord(attributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        List<AttributeRecord> visibleAttributeRecords = attributeRecords.stream().filter(it -> !it.isSystem()).toList();
        if (vertexRecord.isRoot() && vertexRecord.isComposite()) {
            if (isEnd) {
                this.writeEndElement(writer, indent);
            } else {
                this.writeStartElement(writer, indent, GRAPH, this.buildElementIdAttribute(nestedGraphId));
            }
            return;
        }
        if ((vertexType & 8) > 0) {
            boolean isVertexWithPorts;
            boolean bl = isVertexWithPorts = (vertexType & 2) > 0;
            if (!(!isVertexWithPorts && visibleAttributeRecords.isEmpty() || isEnd)) {
                this.writeStartElement(writer, indent, NODE, this.buildElementIdAttribute(vertexId));
                if (isVertexWithPorts) {
                    this.writePorts(writer, indent, vertexRecord);
                }
                if (!visibleAttributeRecords.isEmpty()) {
                    this.writeVisibleAttributes(writer, indent, visibleAttributeRecords);
                }
            }
            if (!isVertexWithPorts && visibleAttributeRecords.isEmpty() && !isEnd) {
                this.writeEmptyElement(writer, indent, NODE, this.buildElementIdAttribute(vertexId));
            }
            if ((isVertexWithPorts || !visibleAttributeRecords.isEmpty()) && isEnd) {
                this.writeEndElement(writer, indent);
            }
        }
        if ((vertexType & 4) > 0) {
            if (isEnd) {
                this.writeEndElement(writer, indent);
            } else {
                this.writeStartElement(writer, indent, GRAPH, this.buildElementIdAttribute(nestedGraphId));
            }
        }
    }

    private void writeEdge(XMLStreamWriter writer, AtomicInteger indent, EdgeRecord edgeRecord) {
        List<AttributeRecord> targetAttributeRecords;
        List<AttributeRecord> attributeRecords = this.edgeIdToCachedAttributes.get(edgeRecord.getId());
        if (attributeRecords == null) {
            attributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, edgeRecord.getId(), AttributeOwnerType.EDGE);
            this.edgeIdToCachedAttributes.put(edgeRecord.getId(), attributeRecords);
        }
        String edgeId = GraphStorage.findEdgeOriginalIdAttributeRecord(attributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        Integer edgeType = GraphStorage.findEdgeTypeAttributeRecord(attributeRecords).map(AttributeRecord::getIntegerValue).orElse(2048);
        if ((edgeType & 0x200) > 0) {
            return;
        }
        Boolean edgeIsDirected = GraphStorage.findEdgeIsDirectedAttributeRecord(attributeRecords).map(AttributeRecord::getBooleanValue).orElse(false);
        List<AttributeRecord> sourceAttributeRecords = this.vertexIdToCachedAttributes.get(edgeRecord.getSourceId());
        if (sourceAttributeRecords == null) {
            sourceAttributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, edgeRecord.getSourceId(), AttributeOwnerType.VERTEX);
            this.vertexIdToCachedAttributes.put(edgeRecord.getSourceId(), sourceAttributeRecords);
        }
        if ((targetAttributeRecords = this.vertexIdToCachedAttributes.get(edgeRecord.getTargetId())) == null) {
            targetAttributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, edgeRecord.getTargetId(), AttributeOwnerType.VERTEX);
            this.vertexIdToCachedAttributes.put(edgeRecord.getTargetId(), targetAttributeRecords);
        }
        String sourceId = GraphStorage.findVertexOriginalIdAttributeRecord(sourceAttributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        String targetId = GraphStorage.findVertexOriginalIdAttributeRecord(targetAttributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        if (sourceId == null || targetId == null) {
            throw new IllegalArgumentException("Source and target vertex IDs must not be null.");
        }
        String sourcePortId = null;
        UUID storageSourcePortGlobalId = GraphStorage.findEdgeStorageSourcePortGlobalIdAttributeRecord(attributeRecords).map(AttributeRecord::getUUIDValue).orElse(null);
        if (storageSourcePortGlobalId != null) {
            Integer storageSourcePortId = this.graphStorage.findVertexRecord(this.graphModelId, storageSourcePortGlobalId).map(VertexRecord::getId).orElse(-1);
            List<AttributeRecord> sourcePortAttributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, storageSourcePortId, AttributeOwnerType.VERTEX);
            sourcePortId = GraphStorage.findVertexOriginalIdAttributeRecord(sourcePortAttributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        }
        String targetPortId = null;
        UUID storageTargetPortGlobalId = GraphStorage.findEdgeStorageTargetPortGlobalIdAttributeRecord(attributeRecords).map(AttributeRecord::getUUIDValue).orElse(null);
        if (storageTargetPortGlobalId != null) {
            Integer storageTargetPortId = this.graphStorage.findVertexRecord(this.graphModelId, storageTargetPortGlobalId).map(VertexRecord::getId).orElse(-1);
            List<AttributeRecord> targetPortAttributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, storageTargetPortId, AttributeOwnerType.VERTEX);
            targetPortId = GraphStorage.findVertexOriginalIdAttributeRecord(targetPortAttributeRecords).map(AttributeRecord::getStringValue).orElse(null);
        }
        ArrayList<Map.Entry<String, String>> elementAttributes = new ArrayList<Map.Entry<String, String>>();
        if (edgeId != null) {
            elementAttributes.add(Map.entry(ID, edgeId));
        }
        elementAttributes.add(Map.entry(SOURCE, sourceId));
        elementAttributes.add(Map.entry(TARGET, targetId));
        if (sourcePortId != null) {
            elementAttributes.add(Map.entry(SOURCE_PORT, sourcePortId));
        }
        if (targetPortId != null) {
            elementAttributes.add(Map.entry(TARGET_PORT, targetPortId));
        }
        elementAttributes.add(Map.entry(DIRECTED, edgeIsDirected.toString()));
        List<AttributeRecord> visibleAttributeRecords = attributeRecords.stream().filter(it -> !it.isSystem()).toList();
        if (visibleAttributeRecords.isEmpty()) {
            this.writeEmptyElement(writer, indent, EDGE, elementAttributes);
        } else {
            this.writeStartElement(writer, indent, EDGE, elementAttributes);
            this.writeVisibleAttributes(writer, indent, visibleAttributeRecords);
            this.writeEndElement(writer, indent);
        }
    }

    private void writePorts(XMLStreamWriter writer, AtomicInteger indent, VertexRecord vertexRecord) {
        List<VertexRecord> portRecords = this.graphStorage.findVertexRecordsByParentIdAndVertexType(this.graphModelId, vertexRecord.getId(), 128);
        for (VertexRecord portRecord : portRecords) {
            List<AttributeRecord> attributeRecords = this.graphStorage.findAttributeRecordsByOwner(this.graphModelId, portRecord.getId(), AttributeOwnerType.VERTEX);
            String portId = GraphStorage.findVertexOriginalIdAttributeRecord(attributeRecords).map(AttributeRecord::getStringValue).orElse(null);
            List<AttributeRecord> visibleAttributeRecords = attributeRecords.stream().filter(it -> !it.isSystem()).toList();
            if (visibleAttributeRecords.isEmpty()) {
                this.writeEmptyElement(writer, indent, PORT, this.buildElementIdAttribute(portId));
                continue;
            }
            this.writeStartElement(writer, indent, PORT, this.buildElementIdAttribute(portId));
            this.writeVisibleAttributes(writer, indent, visibleAttributeRecords);
            this.writeEndElement(writer, indent);
        }
    }

    private void writeVisibleAttributes(XMLStreamWriter writer, AtomicInteger indent, List<AttributeRecord> attributeRecords) {
        for (AttributeRecord attributeRecord : attributeRecords) {
            boolean isMultiLine = attributeRecord.getStringValue().contains("\n");
            if (!isMultiLine) {
                writer.writeCharacters(" ".repeat(indent.get()));
            }
            writer.writeStartElement(DATA);
            writer.writeAttribute(KEY, attributeRecord.getName());
            writer.writeCharacters(attributeRecord.getStringValue());
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
    }

    private void writeEmptyElement(XMLStreamWriter writer, AtomicInteger indent, String element, List<Map.Entry<String, String>> elementAttributes) {
        writer.writeCharacters(" ".repeat(indent.get()));
        writer.writeEmptyElement(element);
        this.writeElementAttributes(writer, elementAttributes);
        writer.writeCharacters("\n");
    }

    private void writeStartElement(XMLStreamWriter writer, AtomicInteger indent, String element, List<Map.Entry<String, String>> elementAttributes) {
        writer.writeCharacters(" ".repeat(indent.get()));
        writer.writeStartElement(element);
        this.writeElementAttributes(writer, elementAttributes);
        writer.writeCharacters("\n");
        indent.addAndGet(4);
    }

    private void writeElementAttributes(XMLStreamWriter writer, List<Map.Entry<String, String>> elementAttributes) {
        for (Map.Entry<String, String> elementAttribute : elementAttributes) {
            writer.writeAttribute(elementAttribute.getKey(), elementAttribute.getValue());
        }
    }

    private void writeEndElement(XMLStreamWriter writer, AtomicInteger indent) {
        indent.addAndGet(-4);
        writer.writeCharacters(" ".repeat(indent.get()));
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    private List<Map.Entry<String, String>> buildElementIdAttribute(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return List.of(Map.entry(ID, value));
    }
}

