/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.encoder;

import java.io.OutputStream;
import lombok.NonNull;
import vg.lib.encoder.GraphEncoder;
import vg.lib.encoder.graphml.GraphMLEncoder;
import vg.lib.storage.GraphStorage;

public class GraphEncoderFactory {
    public static GraphEncoder buildGraphEncoder(@NonNull String targetType, int graphModelId, int parentId, @NonNull GraphStorage graphStorage, @NonNull OutputStream outputStream) {
        if (targetType == null) {
            throw new NullPointerException("targetType is marked non-null but is null");
        }
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (targetType.equals("graphml")) {
            return new GraphMLEncoder(graphModelId, parentId, graphStorage, outputStream);
        }
        throw new IllegalArgumentException(String.format("Unsupported target type: %s.", targetType));
    }
}

