/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.encoder;

import java.io.OutputStream;
import lombok.NonNull;
import vg.lib.progress.Progress;
import vg.lib.progress.ProgressImpl;
import vg.lib.storage.GraphStorage;

public abstract class GraphEncoder {
    protected int graphModelId;
    protected int parentId;
    protected GraphStorage graphStorage;
    protected OutputStream outputStream;
    protected final ProgressImpl progress;

    public GraphEncoder(int graphModelId, int parentId, @NonNull GraphStorage graphStorage, @NonNull OutputStream outputStream) {
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        this.graphModelId = graphModelId;
        this.parentId = parentId;
        this.graphStorage = graphStorage;
        this.outputStream = outputStream;
        this.progress = new ProgressImpl("Encoding ...");
    }

    public Progress getProgress() {
        return this.progress;
    }

    public abstract void encode() throws GraphEncoderException;

    public static class GraphEncoderException
    extends Exception {
        public GraphEncoderException(Exception exception) {
            super(String.format("Can't encode graph content. Original error: '%s'.", exception.getMessage()), exception);
        }
    }
}

