/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.decoder.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.NonNull;
import vg.lib.decoder.GraphDecoder;
import vg.lib.decoder.GraphDecoderFactory;
import vg.lib.decoder.graphml.GraphMLDecoder;
import vg.lib.storage.GraphStorage;

public class ZipDecoder
extends GraphMLDecoder {
    public ZipDecoder(@NonNull String graphName, @NonNull InputStream inputStream, @NonNull GraphStorage graphStorage) {
        super(graphName, inputStream, graphStorage);
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
    }

    @Override
    public int decode() throws GraphDecoder.GraphDecoderException {
        int n;
        List<String> supportedFormats = GraphDecoderFactory.SUPPORTED_FORMATS.stream().filter(it -> !"zip".equals(it)).toList();
        ZipInputStream zis = new ZipInputStream(this.inputStream);
        try {
            int lastIndex;
            ZipEntry entry = zis.getNextEntry();
            String fileName = null;
            String fileExtension = null;
            if (entry != null && (lastIndex = (fileName = entry.getName()).lastIndexOf(46)) != -1) {
                fileExtension = fileName.substring(lastIndex + 1);
            }
            if (fileExtension == null || !supportedFormats.contains(fileExtension)) {
                throw new GraphDecoder.GraphDecoderException(String.format("Zip container must contain one of the supported formats: %s.", String.join((CharSequence)", ", supportedFormats)));
            }
            n = GraphDecoderFactory.buildGraphDecoder(fileExtension, fileName, zis, this.graphStorage).decode();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new GraphDecoder.GraphDecoderException(ex);
            }
        }
        zis.close();
        return n;
    }
}

