/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.decoder.graphml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.IntStream;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import vg.lib.model.record.AttributeOwnerType;
import vg.lib.model.record.AttributeRecord;
import vg.lib.model.record.AttributeRecordType;
import vg.lib.storage.GraphStorage;

class GraphMLParser
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(GraphMLParser.class);
    private static final String ID = "id";
    private static final String GRAPH = "graph";
    private static final String EDGEDEF = "edgedefault";
    private static final String DIRECTED = "directed";
    private static final String UNDIRECTED = "undirected";
    private static final String PORT = "port";
    private static final String NAME = "name";
    private static final String KEY = "key";
    private static final String FOR = "for";
    private static final String ALL = "all";
    private static final String ATTRNAME = "attr.name";
    private static final String ATTRTYPE = "attr.type";
    private static final String DEFAULT = "default";
    private static final String NODE = "node";
    private static final String EDGE = "edge";
    private static final String SOURCE = "source";
    private static final String SOURCE_PORT = "sourceport";
    private static final String TARGET = "target";
    private static final String TARGET_PORT = "targetport";
    private static final String DATA = "data";
    private static final String GRAPHML = "graphml";
    private static final String INT = "int";
    private static final String INTEGER = "integer";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String REAL = "real";
    private static final String BOOLEAN = "boolean";
    private static final String STRING = "string";
    private final GraphStorage graphStorage;
    private final int graphModelId;
    private String m_key;
    private String m_id;
    private String m_for;
    private String m_name;
    private String m_type;
    private String m_default;
    private final StringBuffer stringBuffer = new StringBuffer();
    private final Map<GraphMlElementType, Map<String, GraphMlAttribute>> elementTypeToAttributes = new HashMap<GraphMlElementType, Map<String, GraphMlAttribute>>();
    private final Map<String, VertexIdsWithParentIds> originalIdToVertexIdWithParentIds = new HashMap<String, VertexIdsWithParentIds>();
    private final Map<Integer, Map<String, Integer>> vertexIdToOriginalPortIdToPortId = new HashMap<Integer, Map<String, Integer>>();
    private final Map<Integer, Boolean> parentIdToIsDirected = new HashMap<Integer, Boolean>();
    private final Stack<Integer> parentIds = new Stack();
    private final Stack<GraphMlElement> currentElements = new Stack();

    GraphMLParser(int graphModelId, GraphStorage graphStorage) {
        this.graphModelId = graphModelId;
        this.graphStorage = graphStorage;
        this.elementTypeToAttributes.put(GraphMlElementType.GRAPHML, new LinkedHashMap());
        this.elementTypeToAttributes.put(GraphMlElementType.GRAPH, new LinkedHashMap());
        this.elementTypeToAttributes.put(GraphMlElementType.NODE, new LinkedHashMap());
        this.elementTypeToAttributes.put(GraphMlElementType.PORT, new LinkedHashMap());
        this.elementTypeToAttributes.put(GraphMlElementType.EDGE, new LinkedHashMap());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.stringBuffer.append(ch, start, length);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        this.stringBuffer.setLength(0);
        switch (qName) {
            case "graphml": {
                this.currentElements.push(new GraphMlElement(this.graphModelId, GraphMlElementType.GRAPHML, new LinkedHashMap<String, GraphMlAttribute>()));
                this.parentIds.push(-1);
                break;
            }
            case "graph": {
                int vertexId;
                GraphMlElement currentElement = this.currentElements.peek();
                if (currentElement.type != GraphMlElementType.NODE && currentElement.type != GraphMlElementType.GRAPHML) {
                    throw new IllegalArgumentException(String.format("Element '%s' should be placed in '%s' or '%s' elements.", GRAPH, NODE, GRAPHML));
                }
                String edgeDef = attributes.getValue(EDGEDEF);
                if (edgeDef != null && !edgeDef.equalsIgnoreCase(DIRECTED) && !edgeDef.equalsIgnoreCase(UNDIRECTED)) {
                    throw new IllegalArgumentException(String.format("Unknown token '%s'.", attributes));
                }
                boolean directed = DIRECTED.equalsIgnoreCase(edgeDef);
                String originalGraphId = attributes.getValue(ID);
                if (currentElement.type == GraphMlElementType.GRAPHML) {
                    vertexId = this.graphStorage.createVertex(this.graphModelId, -1);
                    this.addVertexIdWithParentIds(originalGraphId, vertexId, this.parentIds);
                    this.graphStorage.createVertexAttribute(this.graphModelId, vertexId, "system_vertex_nested_graph_original_id", originalGraphId, AttributeRecordType.STRING, false);
                } else {
                    vertexId = currentElement.elementId;
                    currentElement.attributes.put("system_vertex_nested_graph_original_id", new GraphMlAttribute("system_vertex_nested_graph_original_id", "system_vertex_nested_graph_original_id", originalGraphId, AttributeRecordType.STRING));
                }
                this.parentIds.push(vertexId);
                this.parentIdToIsDirected.put(vertexId, directed);
                LinkedHashMap<String, GraphMlAttribute> clonedDefaultAttributes = this.cloneDefaultAttributes(GraphMlElementType.GRAPH);
                this.currentElements.push(new GraphMlElement(vertexId, GraphMlElementType.GRAPH, clonedDefaultAttributes));
                break;
            }
            case "node": {
                String originalVertexId = attributes.getValue(ID);
                if (originalVertexId == null || originalVertexId.isBlank()) {
                    throw new IllegalArgumentException(String.format("Missing '%s' attribute for node element.", ID));
                }
                Integer parentId = this.parentIds.peek();
                int vertexId = this.graphStorage.createVertex(this.graphModelId, parentId);
                LinkedHashMap<String, GraphMlAttribute> clonedDefaultAttributes = this.cloneDefaultAttributes(GraphMlElementType.NODE);
                clonedDefaultAttributes.put("system_vertex_original_id", new GraphMlAttribute("system_vertex_original_id", "system_vertex_original_id", originalVertexId, AttributeRecordType.STRING));
                this.currentElements.push(new GraphMlElement(vertexId, GraphMlElementType.NODE, clonedDefaultAttributes));
                this.addVertexIdWithParentIds(originalVertexId, vertexId, this.parentIds);
                break;
            }
            case "port": {
                String originalPortId;
                String originalPortName = attributes.getValue(NAME);
                String string = originalPortId = originalPortName == null ? attributes.getValue(ID) : originalPortName;
                if (originalPortId == null || originalPortId.isBlank()) {
                    throw new IllegalArgumentException(String.format("Missing '%s' or '%s' attribute for port element.", NAME, ID));
                }
                int currentVertexId = this.findCurrentVertexOrGraphId();
                if (currentVertexId < 0) {
                    throw new IllegalArgumentException(String.format("Can not parse port element: %s. Current vertex id is empty.", originalPortId));
                }
                Map originalPortIdToPortId = this.vertexIdToOriginalPortIdToPortId.compute(currentVertexId, (key, existing) -> {
                    if (existing == null) {
                        existing = new HashMap();
                    }
                    return existing;
                });
                int portId = this.graphStorage.createPort(this.graphModelId, currentVertexId, false, originalPortIdToPortId.size());
                LinkedHashMap<String, GraphMlAttribute> clonedDefaultAttributes = this.cloneDefaultAttributes(GraphMlElementType.PORT);
                clonedDefaultAttributes.put("system_vertex_original_id", new GraphMlAttribute("system_vertex_original_id", "system_vertex_original_id", originalPortId, AttributeRecordType.STRING));
                this.currentElements.push(new GraphMlElement(portId, GraphMlElementType.PORT, clonedDefaultAttributes));
                originalPortIdToPortId.put(originalPortId, portId);
                break;
            }
            case "edge": {
                String originalEdgeId = attributes.getValue(ID);
                if (originalEdgeId == null || originalEdgeId.isBlank()) {
                    originalEdgeId = "";
                }
                String originalSourceId = attributes.getValue(SOURCE);
                String originalTargetId = attributes.getValue(TARGET);
                if (originalSourceId == null || originalTargetId == null || originalSourceId.isBlank() || originalTargetId.isBlank()) {
                    throw new IllegalArgumentException(String.format("Parameter 'source' or 'target' is required for edge (%s) elements.", originalEdgeId));
                }
                int sourceVertexId = this.findVertexId(originalSourceId, this.parentIds);
                int targetVertexId = this.findVertexId(originalTargetId, this.parentIds);
                if (sourceVertexId < 0 || targetVertexId < 0) {
                    throw new IllegalArgumentException(String.format("Could not find source or target vertices ids for edge: %s, source: %s, target: %s.", originalEdgeId, originalSourceId, originalTargetId));
                }
                GraphMlElement currentElement = this.currentElements.peek();
                if (currentElement.type != GraphMlElementType.GRAPH) {
                    throw new IllegalArgumentException(String.format("Current element type '%s' should be graph.", new Object[]{currentElement.type}));
                }
                String originalSourcePortId = attributes.getValue(SOURCE_PORT);
                String originalTargetPortId = attributes.getValue(TARGET_PORT);
                int sourcePortId = this.findPortId(sourceVertexId, originalSourcePortId);
                int targetPortId = this.findPortId(targetVertexId, originalTargetPortId);
                Boolean directed = this.parentIdToIsDirected.getOrDefault(currentElement.elementId, false);
                if (Boolean.getBoolean(attributes.getValue(DIRECTED))) {
                    directed = true;
                }
                int edgeId = this.graphStorage.createEdge(this.graphModelId, sourceVertexId, targetVertexId, sourcePortId, targetPortId, directed);
                LinkedHashMap<String, GraphMlAttribute> clonedDefaultAttributes = this.cloneDefaultAttributes(GraphMlElementType.EDGE);
                clonedDefaultAttributes.put("system_edge_original_id", new GraphMlAttribute("system_edge_original_id", "system_edge_original_id", originalEdgeId, AttributeRecordType.STRING));
                this.currentElements.push(new GraphMlElement(edgeId, GraphMlElementType.EDGE, clonedDefaultAttributes));
                break;
            }
            case "key": {
                GraphMlElement currentElement = this.currentElements.peek();
                if (currentElement.type != GraphMlElementType.GRAPHML) {
                    throw new IllegalArgumentException("Section 'key' should be placed in 'graphml' section.");
                }
                this.m_for = attributes.getValue(FOR);
                this.m_id = attributes.getValue(ID);
                this.m_name = attributes.getValue(ATTRNAME);
                this.m_type = attributes.getValue(ATTRTYPE);
                break;
            }
            case "data": {
                this.m_key = attributes.getValue(KEY);
                if (this.m_key != null && !this.m_key.isBlank()) break;
                throw new IllegalArgumentException("Key must not be null or empty.");
            }
            default: {
                log.error("Unknown token '{}'.", (Object)qName);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        switch (qName) {
            case "graphml": 
            case "graph": {
                this.currentElements.pop();
                this.parentIds.pop();
                break;
            }
            case "node": {
                GraphMlElement currentElement = this.currentElements.pop();
                if (currentElement.type != GraphMlElementType.NODE) {
                    throw new IllegalArgumentException(String.format("Current element type '%s' should be node.", new Object[]{currentElement.type}));
                }
                this.graphStorage.createAttributes(this.graphModelId, this.toAttributeRecords(currentElement.elementId, currentElement.type, currentElement.attributes));
                break;
            }
            case "port": {
                GraphMlElement currentElement = this.currentElements.pop();
                if (currentElement.type != GraphMlElementType.PORT) {
                    throw new IllegalArgumentException(String.format("Current element type '%s' should be port.", new Object[]{currentElement.type}));
                }
                this.graphStorage.createAttributes(this.graphModelId, this.toAttributeRecords(currentElement.elementId, currentElement.type, currentElement.attributes));
                break;
            }
            case "edge": {
                GraphMlElement currentElement = this.currentElements.pop();
                if (currentElement.type != GraphMlElementType.EDGE) {
                    throw new IllegalArgumentException(String.format("Current element type '%s' should be edge.", new Object[]{currentElement.type}));
                }
                this.graphStorage.createAttributes(this.graphModelId, this.toAttributeRecords(currentElement.elementId, currentElement.type, currentElement.attributes));
                break;
            }
            case "default": {
                this.m_default = StringEscapeUtils.unescapeJava((String)this.stringBuffer.toString());
                break;
            }
            case "key": {
                if (this.m_id == null || this.m_id.isBlank()) {
                    throw new IllegalArgumentException("Id in key element must not be null or blank.");
                }
                String value = this.m_default;
                if (value != null && value.isBlank()) {
                    value = null;
                }
                AttributeRecordType type = GraphMLParser.toAttributeRecordType(this.m_type);
                GraphMlAttribute attribute = new GraphMlAttribute(this.m_id, this.m_name, value, type);
                if (this.m_for == null || this.m_for.isBlank() || this.m_for.equalsIgnoreCase(ALL)) {
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.GRAPHML).put(this.m_id, attribute);
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.GRAPH).put(this.m_id, attribute);
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.NODE).put(this.m_id, attribute);
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.PORT).put(this.m_id, attribute);
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.EDGE).put(this.m_id, attribute);
                } else if (this.m_for.equalsIgnoreCase(GRAPHML)) {
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.GRAPHML).put(this.m_id, attribute);
                } else if (this.m_for.equalsIgnoreCase(GRAPH)) {
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.GRAPH).put(this.m_id, attribute);
                } else if (this.m_for.equalsIgnoreCase(NODE)) {
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.NODE).put(this.m_id, attribute);
                } else if (this.m_for.equalsIgnoreCase(PORT)) {
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.PORT).put(this.m_id, attribute);
                } else if (this.m_for.equalsIgnoreCase(EDGE)) {
                    this.elementTypeToAttributes.get((Object)GraphMlElementType.EDGE).put(this.m_id, attribute);
                } else {
                    throw new IllegalArgumentException(String.format("Unrecognized group '%s' in 'key' section, id = '%s'.", this.m_for, this.m_id));
                }
                this.m_default = null;
                break;
            }
            case "data": {
                GraphMlElement currentElement = this.currentElements.peek();
                this.mergeAttributes(currentElement.attributes, currentElement.type, this.m_key, StringEscapeUtils.unescapeJava((String)this.stringBuffer.toString()));
                break;
            }
        }
    }

    private void addVertexIdWithParentIds(String originalId, int vertexId, List<Integer> parentIds) {
        if (originalId == null) {
            return;
        }
        int[] vertexIdWithParentIds = IntStream.concat(parentIds.stream().mapToInt(Integer::intValue), IntStream.of(vertexId)).toArray();
        this.originalIdToVertexIdWithParentIds.compute(originalId, (key, existing) -> {
            if (existing == null) {
                existing = new VertexIdsWithParentIds();
            }
            existing.addVertexIdWithParentIds(vertexIdWithParentIds);
            return existing;
        });
    }

    private int findVertexId(String originalId, List<Integer> parentIds) {
        VertexIdsWithParentIds vertexIdWithParentIds = this.originalIdToVertexIdWithParentIds.get(originalId);
        if (vertexIdWithParentIds == null) {
            return -1;
        }
        if (vertexIdWithParentIds.vertexIdsWithParentIds.size() == 1) {
            int[] any = vertexIdWithParentIds.vertexIdsWithParentIds.get(0);
            return any[any.length - 1];
        }
        return vertexIdWithParentIds.findVertexId(parentIds);
    }

    private int findPortId(int vertexId, String originalPortId) {
        if (originalPortId == null || originalPortId.isBlank()) {
            return -1;
        }
        Map<String, Integer> originalPortIdToPortId = this.vertexIdToOriginalPortIdToPortId.get(vertexId);
        if (originalPortIdToPortId == null) {
            return -1;
        }
        return originalPortIdToPortId.getOrDefault(originalPortId, -1);
    }

    private int findCurrentVertexOrGraphId() {
        if (this.currentElements.isEmpty()) {
            return -1;
        }
        GraphMlElement element = this.currentElements.peek();
        return element.type == GraphMlElementType.NODE || element.type == GraphMlElementType.GRAPH ? element.elementId : -1;
    }

    private LinkedHashMap<String, GraphMlAttribute> cloneDefaultAttributes(GraphMlElementType elementType) {
        Map attributes = this.elementTypeToAttributes.getOrDefault((Object)elementType, Collections.emptyMap());
        LinkedHashMap<String, GraphMlAttribute> result = new LinkedHashMap<String, GraphMlAttribute>();
        for (Map.Entry entry : attributes.entrySet()) {
            if (entry.getValue() == null || ((GraphMlAttribute)entry.getValue()).value == null) continue;
            GraphMlAttribute copy = new GraphMlAttribute(((GraphMlAttribute)entry.getValue()).id, ((GraphMlAttribute)entry.getValue()).name, ((GraphMlAttribute)entry.getValue()).value, ((GraphMlAttribute)entry.getValue()).type);
            result.put((String)entry.getKey(), copy);
        }
        return result;
    }

    private void mergeAttributes(LinkedHashMap<String, GraphMlAttribute> existingAttributes, GraphMlElementType elementType, String attributeId, String attributeValue) {
        GraphMlAttribute defaultAttribute;
        GraphMlAttribute existingAttribute = existingAttributes.get(attributeId);
        existingAttribute = existingAttribute != null ? new GraphMlAttribute(attributeId, existingAttribute.name, attributeValue, existingAttribute.type) : ((defaultAttribute = this.elementTypeToAttributes.get((Object)elementType).get(attributeId)) != null ? new GraphMlAttribute(attributeId, defaultAttribute.name, attributeValue, defaultAttribute.type) : new GraphMlAttribute(attributeId, attributeId, attributeValue, AttributeRecordType.STRING));
        existingAttributes.put(attributeId, existingAttribute);
    }

    private List<AttributeRecord> toAttributeRecords(int elementId, GraphMlElementType elementType, Map<String, GraphMlAttribute> attributes) {
        AttributeOwnerType ownerType = switch (elementType) {
            case GraphMlElementType.EDGE -> AttributeOwnerType.EDGE;
            case GraphMlElementType.GRAPHML -> AttributeOwnerType.GRAPH_MODEL;
            default -> AttributeOwnerType.VERTEX;
        };
        return attributes.values().stream().map(attr -> new AttributeRecord(this.graphModelId, elementId, ownerType, attr.getNameOrId(), attr.value(), attr.type(), !attr.isSystem())).toList();
    }

    private static AttributeRecordType toAttributeRecordType(String graphMlAttributeType) {
        if (graphMlAttributeType == null || graphMlAttributeType.equals(STRING)) {
            return AttributeRecordType.STRING;
        }
        if (graphMlAttributeType.equals(BOOLEAN)) {
            return AttributeRecordType.BOOLEAN;
        }
        if (graphMlAttributeType.equals(DOUBLE) || graphMlAttributeType.equals(FLOAT) || graphMlAttributeType.equals(REAL)) {
            return AttributeRecordType.DOUBLE;
        }
        if (graphMlAttributeType.equals(INT) || graphMlAttributeType.equals(INTEGER) || graphMlAttributeType.equals(LONG)) {
            return AttributeRecordType.INTEGER;
        }
        return AttributeRecordType.STRING;
    }

    private static enum GraphMlElementType {
        GRAPHML,
        GRAPH,
        NODE,
        PORT,
        EDGE;

    }

    private record GraphMlElement(int elementId, GraphMlElementType type, LinkedHashMap<String, GraphMlAttribute> attributes) {
    }

    private record GraphMlAttribute(String id, String name, String value, AttributeRecordType type) {
        String getNameOrId() {
            if (this.name == null || this.name.isBlank()) {
                return this.id;
            }
            return this.name;
        }

        boolean isSystem() {
            return this.getNameOrId().startsWith("system_");
        }
    }

    private static class VertexIdsWithParentIds {
        private final ArrayList<int[]> vertexIdsWithParentIds = new ArrayList();

        public void addVertexIdWithParentIds(int[] vertexIdWithParentIds) {
            this.vertexIdsWithParentIds.add(vertexIdWithParentIds);
        }

        public int findVertexId(List<Integer> parentIds) {
            for (int[] vertexIdWithParentIds : this.vertexIdsWithParentIds) {
                Integer lastParentId;
                int lastParentIndex;
                if (vertexIdWithParentIds.length - 1 < parentIds.size() || vertexIdWithParentIds[lastParentIndex = parentIds.size() - 1] != (lastParentId = parentIds.get(lastParentIndex))) continue;
                return vertexIdWithParentIds[vertexIdWithParentIds.length - 1];
            }
            return -1;
        }
    }
}

