/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.decoder.graphml;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import lombok.NonNull;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import vg.lib.decoder.GraphDecoder;
import vg.lib.decoder.graphml.GraphMLParser;
import vg.lib.storage.GraphStorage;

public class GraphMLDecoder
extends GraphDecoder {
    public GraphMLDecoder(@NonNull String graphName, @NonNull InputStream inputStream, @NonNull GraphStorage graphStorage) {
        super(graphName, inputStream, graphStorage);
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
    }

    @Override
    public int decode() throws GraphDecoder.GraphDecoderException {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            int graphId = this.graphStorage.createGraphModel(this.graphName);
            GraphMLParser handler = new GraphMLParser(graphId, this.graphStorage);
            saxParser.parse(this.inputStream, (DefaultHandler)handler);
            return graphId;
        }
        catch (SAXParseException ex) {
            throw new GraphDecoder.GraphDecoderException(String.format("%s Line number: %s, column number:%s.", ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber()), ex);
        }
        catch (Exception ex) {
            throw new GraphDecoder.GraphDecoderException(ex);
        }
    }
}

