/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.decoder.gml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.decoder.GraphDecoder;
import vg.lib.model.record.AttributeRecordType;
import vg.lib.storage.GraphStorage;

public class GMLDecoder
extends GraphDecoder {
    private static final Logger log = LoggerFactory.getLogger(GMLDecoder.class);
    private static final String GRAPH = "graph";
    private static final String NODE = "node";
    private static final String EDGE = "edge";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String BEGIN_STMT = "[";
    private static final String END_STMT = "]";
    private static final String ID = "id";
    private GMLTokenizer currGMLTokenizer;
    private Map<String, Integer> nodes;

    public GMLDecoder(@NonNull String graphName, @NonNull InputStream inputStream, @NonNull GraphStorage graphStorage) {
        super(graphName, inputStream, graphStorage);
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
    }

    @Override
    public int decode() throws GraphDecoder.GraphDecoderException {
        try {
            this.currGMLTokenizer = new GMLTokenizer(this.inputStream);
            int graphModelId = this.graphStorage.createGraphModel(this.graphName);
            int graphId = this.graphStorage.createVertex(graphModelId, -1);
            this.nodes = Maps.newHashMap();
            while (this.currGMLTokenizer.peekToken() != null) {
                if (this.isNextAttr()) {
                    this.parseAttr();
                    continue;
                }
                if (this.isNextGraph()) {
                    this.parseGraph(graphModelId, graphId);
                    continue;
                }
                throw new GMLDecoderException(this.currGMLTokenizer.getCurrentLineNumber(), this.currGMLTokenizer.peekToken(), "graph|ID ID");
            }
            return graphModelId;
        }
        catch (IOException ex) {
            throw new GraphDecoder.GraphDecoderException(ex);
        }
    }

    private void parseGraph(int graphModelId, int graphId) throws IOException {
        if (!this.isNextGraph()) {
            throw new GMLDecoderException(this.currGMLTokenizer.getCurrentLineNumber(), this.currGMLTokenizer.peekToken(), GRAPH);
        }
        this.currGMLTokenizer.nextToken();
        this.currGMLTokenizer.nextToken();
        this.parseStmtList(graphModelId, graphId);
        if (this.currGMLTokenizer.peekToken() == null || !this.currGMLTokenizer.peekToken().equalsIgnoreCase(END_STMT)) {
            throw new GMLDecoderException(this.currGMLTokenizer.getCurrentLineNumber(), this.currGMLTokenizer.peekToken(), END_STMT);
        }
        this.currGMLTokenizer.nextToken();
    }

    private void parseStmtList(int graphModelId, int graphId) throws IOException {
        while (this.isNextStmt()) {
            this.parseStmt(graphModelId, graphId);
        }
    }

    private void parseStmt(int graphModelId, int graphId) throws IOException {
        if (!this.isNextStmt()) {
            return;
        }
        if (this.isNextNode()) {
            this.parseNode(graphModelId, graphId);
        } else if (this.isNextEdge()) {
            this.parseEdge(graphModelId);
        } else if (this.isNextAttr()) {
            AbstractMap.SimpleEntry<String, String> simpleEntry = this.parseAttr();
        }
    }

    private void parseNode(int graphModelId, int graphId) throws IOException {
        this.currGMLTokenizer.nextToken();
        this.currGMLTokenizer.nextToken();
        int vertexId = this.graphStorage.createVertex(graphModelId, graphId);
        while (this.isNextAttr()) {
            AbstractMap.SimpleEntry<String, String> pair = this.parseAttr();
            if (pair.getKey().equalsIgnoreCase(ID)) {
                if (this.nodes.containsKey(pair.getValue())) {
                    throw new GMLDecoderException(this.currGMLTokenizer.getCurrentLineNumber(), "The graph contains nodes with same id: " + pair.getValue());
                }
                this.nodes.put(pair.getValue(), vertexId);
                this.graphStorage.setVertexOriginalIdAttribute(graphModelId, vertexId, pair.getValue());
                continue;
            }
            this.graphStorage.createVertexAttribute(graphModelId, vertexId, pair.getKey(), pair.getValue(), AttributeRecordType.STRING, true);
        }
        this.currGMLTokenizer.nextToken();
    }

    private void parseEdge(int graphModelId) throws IOException {
        this.currGMLTokenizer.nextToken();
        this.currGMLTokenizer.nextToken();
        String sourceIdStr = null;
        String targetIdStr = null;
        HashMap attributes = Maps.newHashMap();
        while (this.isNextAttr()) {
            AbstractMap.SimpleEntry<String, String> pair = this.parseAttr();
            if (pair.getKey().equalsIgnoreCase(SOURCE)) {
                sourceIdStr = pair.getValue();
                continue;
            }
            if (pair.getKey().equalsIgnoreCase(TARGET)) {
                targetIdStr = pair.getValue();
                continue;
            }
            attributes.put(pair.getKey(), pair.getValue());
        }
        if (sourceIdStr == null || targetIdStr == null) {
            throw new GMLDecoderException(this.currGMLTokenizer.getCurrentLineNumber(), String.format("Can't find source id (%s) and target id (%s) in the edge statement", sourceIdStr, targetIdStr));
        }
        if (!this.nodes.containsKey(sourceIdStr) || !this.nodes.containsKey(targetIdStr)) {
            throw new GMLDecoderException(this.currGMLTokenizer.getCurrentLineNumber(), String.format("Can't find source id (%s) and target id (%s) for the edge", sourceIdStr, targetIdStr));
        }
        int edgeId = this.graphStorage.createEdge(graphModelId, this.nodes.get(sourceIdStr), this.nodes.get(targetIdStr), -1, -1, false);
        for (String name : attributes.keySet()) {
            this.graphStorage.createEdgeAttribute(graphModelId, edgeId, name, (String)attributes.get(name), AttributeRecordType.STRING, true);
        }
        this.currGMLTokenizer.nextToken();
    }

    private AbstractMap.SimpleEntry<String, String> parseAttr() throws IOException {
        if (!this.isNextAttr()) {
            throw new GMLDecoderException(this.currGMLTokenizer.getCurrentLineNumber(), this.currGMLTokenizer.peekToken(), "ID ID");
        }
        String key = this.readID(this.currGMLTokenizer.nextToken());
        String value = this.readID(this.currGMLTokenizer.nextToken());
        return new AbstractMap.SimpleEntry<String, String>(key, value);
    }

    private boolean isNextGraph() throws IOException {
        return this.currGMLTokenizer.peekToken() != null && this.currGMLTokenizer.peekToken(1) != null && this.currGMLTokenizer.peekToken().equalsIgnoreCase(GRAPH) && this.currGMLTokenizer.peekToken(1).equalsIgnoreCase(BEGIN_STMT);
    }

    private boolean isNextNode() throws IOException {
        return this.currGMLTokenizer.peekToken() != null && this.currGMLTokenizer.peekToken().equals(NODE);
    }

    private boolean isNextEdge() throws IOException {
        return this.currGMLTokenizer.peekToken() != null && this.currGMLTokenizer.peekToken().equals(EDGE);
    }

    private boolean isNextStmt() throws IOException {
        return this.currGMLTokenizer.peekToken() != null && !this.currGMLTokenizer.peekToken().equals(END_STMT);
    }

    private boolean isNextAttr() throws IOException {
        return this.currGMLTokenizer.peekToken() != null && this.currGMLTokenizer.peekToken(1) != null && GMLDecoder.isTokenID(this.currGMLTokenizer.peekToken()) && GMLDecoder.isTokenID(this.currGMLTokenizer.peekToken(1));
    }

    private static boolean isTokenID(String token) {
        if (token == null) {
            return false;
        }
        if (token.startsWith("\"") && token.endsWith("\"")) {
            return true;
        }
        if (token.startsWith("'") && token.endsWith("'")) {
            return true;
        }
        if (token.startsWith("<") && token.endsWith(">")) {
            return true;
        }
        Pattern idPattern = Pattern.compile("^[a-zA-Z_\\x200-\\x377][a-zA-Z0-9_\\x200-\\x377]+$");
        Pattern numberPattern = Pattern.compile("^[0-9]+|[0-9]+.[0-9]+");
        return idPattern.matcher(token).matches() || numberPattern.matcher(token).matches();
    }

    private static class GMLTokenizer {
        private String prevToken = null;
        private StreamTokenizer tokenizer;
        private List<String> tokens;
        private List<Integer> lineNumbers;

        public GMLTokenizer(InputStream inputStream) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.tokenizer = new StreamTokenizer(bufferedReader);
            this.tokenizer.slashSlashComments(true);
            this.tokenizer.slashStarComments(true);
            this.tokens = Lists.newArrayList();
            this.lineNumbers = Lists.newArrayList();
            this.readTokens(100);
        }

        public boolean hasNextToken() throws IOException {
            if (this.tokens.size() == 0) {
                this.readTokens(100);
            }
            return this.tokens.size() != 0;
        }

        public String nextToken() throws IOException {
            if (this.hasNextToken()) {
                String value = this.tokens.get(0);
                this.tokens.remove(0);
                this.lineNumbers.remove(0);
                return value;
            }
            return null;
        }

        public String peekToken() throws IOException {
            return this.peekToken(0);
        }

        public String peekToken(int number) throws IOException {
            if (this.tokens.size() <= number) {
                this.readTokens(number - this.tokens.size() + 5);
                if (this.tokens.size() > number) {
                    return this.tokens.get(number);
                }
            } else {
                return this.tokens.get(number);
            }
            return null;
        }

        private void readTokens(int count) throws IOException {
            while (count > 0) {
                Object value = null;
                int tokenValueType = this.tokenizer.nextToken();
                if (tokenValueType != -1) {
                    switch (tokenValueType) {
                        case -3: {
                            value = this.tokenizer.sval;
                            break;
                        }
                        case -2: {
                            if ((double)((int)this.tokenizer.nval) == this.tokenizer.nval) {
                                value = Integer.toString((int)this.tokenizer.nval);
                                break;
                            }
                            value = Double.toString(this.tokenizer.nval);
                            break;
                        }
                        default: {
                            value = (char)tokenValueType == '\"' || (char)tokenValueType == '\'' ? Character.toString((char)tokenValueType) + this.tokenizer.sval + Character.toString((char)tokenValueType) : Character.toString((char)tokenValueType);
                        }
                    }
                }
                if (value != null) {
                    this.tokens.add((String)value);
                    this.lineNumbers.add(this.tokenizer.lineno());
                    this.prevToken = value;
                }
                --count;
            }
        }

        private int getCurrentLineNumber() {
            return this.lineNumbers.size() == 0 ? -1 : this.lineNumbers.get(0);
        }
    }

    public static class GMLDecoderException
    extends RuntimeException {
        public GMLDecoderException(int lineNumber, String message) {
            super(message);
        }

        public GMLDecoderException(int lineNumber, String token, String expectedToken) {
            super("Can't parse following token: " + token + ", expected token: " + expectedToken + ", line number: " + lineNumber);
        }
    }
}

