/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.decoder.dot;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.decoder.GraphDecoder;
import vg.lib.model.record.AttributeRecordType;
import vg.lib.storage.GraphStorage;

public class DotDecoder
extends GraphDecoder {
    private static final Logger log = LoggerFactory.getLogger(DotDecoder.class);
    private static final String STRICT = "strict";
    private static final String UNDIRECTED_GRAPH = "graph";
    private static final String DIRECTED_GRAPH = "digraph";
    private static final String GRAPH = "graph";
    private static final String NODE = "node";
    private static final String EDGE = "edge";
    private static final String SUBGRAPH = "subgraph";
    private static final String BEGIN_ATTR = "[";
    private static final String END_ATTR = "]";
    private static final String BEGIN_STMT = "{";
    private static final String END_STMT = "}";
    private static final String DELIMITER = ";";
    private static final String EQUAL = "=";
    private static final String COMMA = ",";
    private static final String DIRECTED_EDGE = "->";
    private static final String UNDIRECTED_EDGE = "--";
    private static final String COLON = ":";
    private DotTokenizer currDotTokenizer;
    private DotGraph rootDotGraph;
    private DotGraph currDotGraph;

    public DotDecoder(@NonNull String graphName, @NonNull InputStream inputStream, @NonNull GraphStorage graphStorage) {
        super(graphName, inputStream, graphStorage);
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
    }

    @Override
    public int decode() throws GraphDecoder.GraphDecoderException {
        this.rootDotGraph = this.currDotGraph = new DotGraph();
        try {
            this.currDotTokenizer = new DotTokenizer(this.inputStream);
        }
        catch (IOException ex) {
            throw new GraphDecoder.GraphDecoderException(ex);
        }
        int graphModelId = this.graphStorage.createGraphModel(this.graphName);
        while (this.currDotTokenizer.peekTokenString() != null) {
            if (this.isNextGraph()) {
                this.parseGraph(graphModelId);
                continue;
            }
            throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), this.currDotTokenizer.peekTokenString(), "graph");
        }
        return graphModelId;
    }

    private void parseGraph(int graphModelId) throws GraphDecoder.GraphDecoderException {
        log.debug("Method 'parseGraph' was called with graphModelId '{}'.", (Object)graphModelId);
        String id = null;
        if (DotDecoder.isStrictToken(this.currDotTokenizer.peekTokenString())) {
            this.currDotTokenizer.nextToken();
        }
        boolean directed = DotDecoder.isDirectedGraphToken(this.currDotTokenizer.peekTokenString());
        if (DotDecoder.isDirectedGraphToken(this.currDotTokenizer.peekTokenString()) | DotDecoder.isUndirectedGraphToken(this.currDotTokenizer.peekTokenString())) {
            this.currDotTokenizer.nextToken();
        }
        if (this.isNextId()) {
            id = this.readID(this.currDotTokenizer.peekTokenString());
            this.currDotTokenizer.nextToken();
        }
        if (!DotDecoder.isBeginStmtToken(this.currDotTokenizer.peekTokenString())) {
            throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), this.currDotTokenizer.peekTokenString(), BEGIN_STMT);
        }
        this.currDotTokenizer.nextToken();
        int vertexId = this.graphStorage.createVertex(graphModelId, -1);
        if (id != null) {
            this.graphStorage.createVertexAttribute(graphModelId, vertexId, "system_vertex_nested_graph_original_id", id, AttributeRecordType.STRING, false);
        }
        this.currDotGraph = this.currDotGraph.addChild();
        this.parseStmtList(graphModelId, vertexId, directed, id);
        this.currDotGraph = this.rootDotGraph.getParent(this.currDotGraph);
        if (!DotDecoder.isEndStmtToken(this.currDotTokenizer.nextToken())) {
            throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), this.currDotTokenizer.peekTokenString(), END_STMT);
        }
    }

    private void parseStmtList(int graphModelId, int vertexOwnerId, boolean directed, String subGraphId) throws GraphDecoder.GraphDecoderException {
        log.debug("Method 'parseStmtList' was called with graphModelId '{}', vertexOwnerId '{}', directed '{}', subGraphId '{}'.", new Object[]{graphModelId, vertexOwnerId, directed, subGraphId});
        while (this.isNextStmt()) {
            if (DotDecoder.isDelimiterToken(this.currDotTokenizer.peekTokenString())) {
                this.currDotTokenizer.nextToken();
            }
            this.parseStmt(graphModelId, vertexOwnerId, directed, subGraphId);
        }
        log.debug("Method 'parseStmtList' was finished with graphModelId '{}', vertexOwnerId '{}', directed '{}', subGraphId '{}'.", new Object[]{graphModelId, vertexOwnerId, directed, subGraphId});
    }

    private void parseStmt(int graphModelId, int vertexOwnerId, boolean directed, String subGraphId) throws GraphDecoder.GraphDecoderException {
        log.debug("Method 'parseStmt' was called with graphModelId '{}', vertexOwnerId '{}', directed '{}', subGraphId '{}'.", new Object[]{graphModelId, vertexOwnerId, directed, subGraphId});
        if (!this.isNextStmt()) {
            return;
        }
        if (this.isNextAttrStmt()) {
            this.parseAttrStmt(graphModelId);
        } else if (this.isNextSubGraph()) {
            this.parseSubGraph(graphModelId, vertexOwnerId, directed, subGraphId);
        } else if (this.isNextAttr()) {
            Map.Entry<String, String> pair = this.parseAttr();
            this.graphStorage.createVertexAttribute(graphModelId, vertexOwnerId, pair.getKey(), pair.getValue(), AttributeRecordType.STRING, true);
        } else {
            this.parseNodeAndEdgeStmt(graphModelId, vertexOwnerId, directed, subGraphId);
        }
    }

    private String parseNodeId() throws GraphDecoder.GraphDecoderException {
        String id = this.readID(this.currDotTokenizer.nextToken());
        if (this.isNextPort()) {
            this.parsePort();
        }
        return id;
    }

    private void parsePort() throws GraphDecoder.GraphDecoderException {
        if (this.isNextCompassPT()) {
            this.parseCompassPT();
        } else {
            if (!DotDecoder.isColonToken(this.currDotTokenizer.nextToken())) {
                throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), this.currDotTokenizer.peekTokenString(), COLON);
            }
            if (this.isNextId()) {
                this.readID(this.currDotTokenizer.nextToken());
            }
            if (this.isNextCompassPT()) {
                this.parseCompassPT();
            }
        }
    }

    private void parseCompassPT() {
        this.currDotTokenizer.nextToken();
        this.currDotTokenizer.nextToken();
    }

    private void parseNodeAndEdgeStmt(int graphModelId, int vertexOwnerId, boolean directed, String subGraphId) throws GraphDecoder.GraphDecoderException {
        int sourceVertexId;
        log.debug("'parseNodeAndEdgeStmt' was called with graphModelId '{}', vertexOwnerId '{}', directed '{}', subGraphId '{}'.", new Object[]{graphModelId, vertexOwnerId, directed, subGraphId});
        if (this.isNextSubGraph()) {
            sourceVertexId = this.parseSubGraph(graphModelId, vertexOwnerId, directed, subGraphId);
            log.debug("Source subgraph id '{}'.", (Object)sourceVertexId);
        } else {
            String nodeId = this.parseNodeId();
            log.debug("Source node id '{}'.", (Object)nodeId);
            sourceVertexId = this.currDotGraph.getVertexDataBaseId(nodeId);
            if (sourceVertexId < 0) {
                sourceVertexId = this.graphStorage.createVertex(graphModelId, vertexOwnerId);
                log.debug("Source node id '{}' was not found. New source vertex id '{}'.", (Object)nodeId, (Object)sourceVertexId);
                this.currDotGraph.addVertex(nodeId, sourceVertexId);
                this.graphStorage.setVertexOriginalIdAttribute(graphModelId, sourceVertexId, nodeId);
            }
            if (!DotDecoder.isNextEdgeOp(this.currDotTokenizer.peekTokenString()) && this.isBeginNextAttrList()) {
                LinkedHashMap<String, String> result = this.parseAttrList();
                for (Map.Entry<String, String> entry : result.entrySet()) {
                    String value = entry.getValue();
                    if (entry.getKey().equalsIgnoreCase("label")) {
                        value = value.replace("l\n", "\n");
                        value = value.replace("|", "");
                    }
                    this.graphStorage.createVertexAttribute(graphModelId, sourceVertexId, entry.getKey(), value, AttributeRecordType.STRING, true);
                }
                return;
            }
        }
        List<Integer> dataBaseEdgeIds = this.parseEdgeRHS(graphModelId, vertexOwnerId, sourceVertexId, new ArrayList<Integer>(), directed, subGraphId);
        if (this.isBeginNextAttrList()) {
            LinkedHashMap<String, String> result = this.parseAttrList();
            block1: for (Integer dataBaseEdgeId : dataBaseEdgeIds) {
                for (Map.Entry<String, String> entry : result.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key.equalsIgnoreCase("style") && value.equalsIgnoreCase("invis")) {
                        this.graphStorage.deleteEdgeRecordById(graphModelId, dataBaseEdgeId);
                        continue block1;
                    }
                    this.graphStorage.createEdgeAttribute(graphModelId, dataBaseEdgeId, key, result.get(key), AttributeRecordType.STRING, true);
                }
            }
        }
    }

    private List<Integer> parseEdgeRHS(int graphModelId, int vertexOwnerId, int sourceVertexId, List<Integer> edgeIds, boolean directed, String subGraphId) throws GraphDecoder.GraphDecoderException {
        int targetVertexId;
        log.debug("'parseEdgeRHS' was called with graphModelId {}, vertexOwnerId {}, sourceVertexId {}, directed {}, subGraphId '{}'.", new Object[]{graphModelId, vertexOwnerId, sourceVertexId, directed, subGraphId});
        this.parseEdgeOP();
        if (this.isNextSubGraph()) {
            targetVertexId = this.parseSubGraph(graphModelId, vertexOwnerId, directed, subGraphId);
        } else {
            String nodeId = this.parseNodeId();
            targetVertexId = this.currDotGraph.getVertexDataBaseId(nodeId);
            if (targetVertexId < 0) {
                targetVertexId = this.graphStorage.createVertex(graphModelId, vertexOwnerId);
                log.debug("Target node id '{}' was not found. New target vertex id '{}'.", (Object)nodeId, (Object)targetVertexId);
                this.currDotGraph.addVertex(nodeId, targetVertexId);
                this.graphStorage.setVertexOriginalIdAttribute(graphModelId, targetVertexId, nodeId);
            }
        }
        try {
            int createdEdgeId = this.graphStorage.createEdge(graphModelId, sourceVertexId, targetVertexId, -1, -1, directed);
            edgeIds.add(createdEdgeId);
        }
        catch (IllegalArgumentException ex) {
            log.error(ex.getMessage());
        }
        if (this.isNextEdgeRHS()) {
            this.parseEdgeRHS(graphModelId, vertexOwnerId, targetVertexId, edgeIds, directed, subGraphId);
        }
        return edgeIds;
    }

    private void parseEdgeOP() throws GraphDecoder.GraphDecoderException {
        if (!this.isNextEdgeRHS()) {
            throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), this.currDotTokenizer.peekTokenString(), "->|--");
        }
        String token = this.currDotTokenizer.nextToken();
        Validate.isTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)token, (CharSequence)DIRECTED_EDGE));
    }

    private void parseAttrStmt(int graphId) throws GraphDecoder.GraphDecoderException {
        log.debug("'parseAttrStmt' was called with graphId {}.", (Object)graphId);
        String token = this.currDotTokenizer.nextToken();
        if (token == null) {
            throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), null, "graph|node|edge");
        }
        switch (token) {
            case "graph": 
            case "node": 
            case "edge": {
                LinkedHashMap<String, String> attrList = this.parseAttrList();
                String skippedAttributes = attrList.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).collect(Collectors.joining(", "));
                log.debug("Skip following attributes: {}.", (Object)skippedAttributes);
                break;
            }
            default: {
                throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), token, "graph|node|edge");
            }
        }
    }

    private LinkedHashMap<String, String> parseAttrList() throws GraphDecoder.GraphDecoderException {
        log.debug("'parseAttrList' was called.");
        if (!this.isBeginNextAttrList()) {
            throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), this.currDotTokenizer.peekTokenString(), BEGIN_ATTR);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.currDotTokenizer.nextToken();
        while (!this.isNextEndAttrList()) {
            Map.Entry<String, String> pair = this.parseAttr();
            result.put(pair.getKey(), pair.getValue());
            if (DotDecoder.isDelimiterToken(this.currDotTokenizer.peekTokenString()) || DotDecoder.isCommaToken(this.currDotTokenizer.peekTokenString())) {
                this.currDotTokenizer.nextToken();
            }
            if (this.isNextAttr() || this.currDotTokenizer.peekTokenString() != null && this.currDotTokenizer.peekTokenString().equals(END_ATTR)) continue;
            throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), this.currDotTokenizer.peekTokenString(), END_ATTR);
        }
        this.currDotTokenizer.nextToken();
        return result;
    }

    private Map.Entry<String, String> parseAttr() throws GraphDecoder.GraphDecoderException {
        if (!this.isNextAttr()) {
            throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), this.currDotTokenizer.peekTokenString(), "ID=ID");
        }
        String key = this.readID(this.currDotTokenizer.nextToken());
        this.currDotTokenizer.nextToken();
        String value = this.readID(this.currDotTokenizer.nextToken());
        return new AbstractMap.SimpleEntry<String, String>(key, value);
    }

    private int parseSubGraph(int graphModelId, int vertexOwnerId, boolean directed, String subGraphId) throws GraphDecoder.GraphDecoderException {
        log.debug("'parseSubGraph' with graphModelId '{}', vertexOwnerId '{}', directed '{}', subGraphId '{}'.", new Object[]{graphModelId, vertexOwnerId, directed, subGraphId});
        int dbSubGraphId = -1;
        if (this.currDotTokenizer.hasNextToken()) {
            String token = this.currDotTokenizer.nextToken();
            if (Objects.equals(token, SUBGRAPH)) {
                token = this.currDotTokenizer.nextToken();
            }
            if (token != null && !token.equals(BEGIN_STMT)) {
                subGraphId = token;
                token = this.currDotTokenizer.nextToken();
            }
            if (Objects.equals(token, BEGIN_STMT)) {
                dbSubGraphId = this.graphStorage.createVertex(graphModelId, vertexOwnerId);
                if (subGraphId != null) {
                    this.graphStorage.setVertexOriginalIdAttribute(graphModelId, dbSubGraphId, subGraphId);
                    this.graphStorage.createVertexAttribute(graphModelId, dbSubGraphId, "system_graph_model_selected_elements", subGraphId, AttributeRecordType.STRING, false);
                }
                this.currDotGraph = this.currDotGraph.addChild();
                this.parseStmtList(graphModelId, dbSubGraphId, directed, subGraphId);
                this.currDotGraph = this.rootDotGraph.getParent(this.currDotGraph);
            }
            if ((token = this.currDotTokenizer.nextToken()) == null || !token.equals(END_STMT)) {
                throw new GraphDecoder.GraphDecoderException(this.currDotTokenizer.getCurrentLineNumber(), token, END_STMT);
            }
        }
        return dbSubGraphId;
    }

    private boolean isNextStmt() {
        return this.currDotTokenizer.peekTokenString() != null && !this.currDotTokenizer.peekTokenString().equals(END_STMT);
    }

    private boolean isNextSubGraph() {
        return this.currDotTokenizer.peekTokenString() != null && (this.currDotTokenizer.peekTokenString().equals(SUBGRAPH) || this.currDotTokenizer.peekTokenString().equals(BEGIN_STMT));
    }

    private boolean isNextPort() {
        String token = this.currDotTokenizer.peekTokenString();
        return token != null && token.equals(COLON);
    }

    private boolean isNextCompassPT() {
        if (!DotDecoder.isColonToken(this.currDotTokenizer.peekTokenString())) {
            return false;
        }
        Pattern pattern = Pattern.compile("^n$|^ne$|^e$|^se$|^s$|^sw$|^w$|^nw$|^c$|^_$");
        return this.currDotTokenizer.peekTokenString(1) != null && pattern.matcher(this.currDotTokenizer.peekTokenString(1)).matches();
    }

    private boolean isNextGraph() {
        return this.currDotTokenizer.hasNextToken() && (DotDecoder.isStrictToken(this.currDotTokenizer.peekTokenString()) || DotDecoder.isDirectedGraphToken(this.currDotTokenizer.peekTokenString()) || DotDecoder.isUndirectedGraphToken(this.currDotTokenizer.peekTokenString()));
    }

    private boolean isNextAttrStmt() {
        String token = this.currDotTokenizer.peekTokenString();
        String nextToken = this.currDotTokenizer.peekTokenString(1);
        if (token == null || nextToken == null) {
            return false;
        }
        return (token.equals("graph") || token.equals(NODE) || token.equals(EDGE)) && nextToken.equals(BEGIN_ATTR);
    }

    private boolean isBeginNextAttrList() {
        return this.currDotTokenizer.peekTokenString() != null && this.currDotTokenizer.peekTokenString().equals(BEGIN_ATTR);
    }

    private boolean isNextEndAttrList() {
        return this.currDotTokenizer.peekTokenString() != null && this.currDotTokenizer.peekTokenString().equals(END_ATTR);
    }

    private boolean isNextAttr() {
        return this.currDotTokenizer.peekTokenString() != null && this.currDotTokenizer.peekTokenString(1) != null && this.currDotTokenizer.peekTokenString(2) != null && DotDecoder.isTokenId(this.currDotTokenizer.peekTokenString()) && this.currDotTokenizer.peekTokenString(1).equals(EQUAL) && DotDecoder.isTokenId(this.currDotTokenizer.peekTokenString(2));
    }

    private boolean isNextEdgeRHS() {
        return DotDecoder.isNextEdgeOp(this.currDotTokenizer.peekTokenString());
    }

    private boolean isNextId() {
        return DotDecoder.isTokenId(this.currDotTokenizer.peekTokenString());
    }

    private static boolean isTokenId(String token) {
        if (token == null) {
            return false;
        }
        if (token.startsWith("\"") && token.endsWith("\"")) {
            return true;
        }
        if (token.startsWith("'") && token.endsWith("'")) {
            return true;
        }
        if (token.startsWith("<") && token.endsWith(">")) {
            return true;
        }
        if (token.contains(" ")) {
            return false;
        }
        Pattern idPattern = Pattern.compile("^[a-zA-Z0-9_\\x200-\\x377]+$");
        Pattern numberPattern = Pattern.compile("^[0-9]+|[0-9]+.[0-9]+");
        return idPattern.matcher(token).matches() || numberPattern.matcher(token).matches();
    }

    private static boolean isBeginStmtToken(String token) {
        return token != null && token.equalsIgnoreCase(BEGIN_STMT);
    }

    private static boolean isEndStmtToken(String token) {
        return token != null && token.equalsIgnoreCase(END_STMT);
    }

    private static boolean isDirectedGraphToken(String token) {
        return token != null && token.equalsIgnoreCase(DIRECTED_GRAPH);
    }

    private static boolean isUndirectedGraphToken(String token) {
        return token != null && token.equalsIgnoreCase("graph");
    }

    private static boolean isStrictToken(String token) {
        return token != null && token.equalsIgnoreCase(STRICT);
    }

    private static boolean isDelimiterToken(String token) {
        return token != null && token.equalsIgnoreCase(DELIMITER);
    }

    private static boolean isCommaToken(String token) {
        return token != null && token.equalsIgnoreCase(COMMA);
    }

    private static boolean isColonToken(String token) {
        return token != null && token.equalsIgnoreCase(COLON);
    }

    private static boolean isNextEdgeOp(String token) {
        return token != null && (token.equals(DIRECTED_EDGE) || token.equals(UNDIRECTED_EDGE));
    }

    private static class DotGraph {
        private final List<DotGraph> graphs = new ArrayList<DotGraph>();
        private final Map<String, Integer> vertexDotIdToDataBaseId = new LinkedHashMap<String, Integer>();

        private DotGraph() {
        }

        private DotGraph getParent(DotGraph child) {
            if (this.graphs.contains(child)) {
                return this;
            }
            for (DotGraph graph : this.graphs) {
                DotGraph parent = graph.getParent(child);
                if (parent == null) continue;
                return parent;
            }
            return null;
        }

        private DotGraph addChild() {
            DotGraph child = new DotGraph();
            this.graphs.add(child);
            return child;
        }

        private int getVertexDataBaseId(String nodeId) {
            Integer id = this.vertexDotIdToDataBaseId.get(nodeId);
            if (id == null) {
                for (DotGraph graph : this.graphs) {
                    id = graph.getVertexDataBaseId(nodeId);
                    if (id == -1) continue;
                    return id;
                }
                return -1;
            }
            return id;
        }

        private void addVertex(String dotVertexId, int vertexId) {
            this.vertexDotIdToDataBaseId.put(dotVertexId, vertexId);
        }
    }

    private static class DotTokenizer {
        private String content;
        private List<Token> tokens;

        DotTokenizer(InputStream inputStream) throws IOException {
            this.content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            char[] charContent = this.content.toCharArray();
            this.tokens = new ArrayList<Token>();
            int pos = 0;
            int line = 0;
            StringBuilder token = new StringBuilder();
            for (int i = 0; i < charContent.length; ++i) {
                char currByte = charContent[i];
                if (token.length() == 0) {
                    pos = i;
                }
                if (currByte == '\n') {
                    ++line;
                }
                if (currByte == '\"' || currByte == '\'' || currByte == '\n' || currByte == '\r' || currByte == ' ' || currByte == '\t' || currByte == '{' || currByte == '}' || currByte == '[' || currByte == ']' || currByte == '-' || currByte == '>' || currByte == '=' || currByte == ',' || currByte == ';' || currByte == ':') {
                    if (token.length() != 0) {
                        if (token.length() == 1 && token.toString().getBytes()[0] == 45 && (currByte == '-' || currByte == '>')) {
                            token.append(currByte);
                        }
                        this.tokens.add(new Token(token.toString(), pos, line));
                        token.setLength(0);
                        if (currByte != '{' && currByte != '}' && currByte != '[' && currByte != ']' && currByte != '=' && currByte != ',' && currByte != ';' && currByte != ':') continue;
                        token.append(currByte);
                        this.tokens.add(new Token(token.toString(), pos, line));
                        token.setLength(0);
                        continue;
                    }
                    if (currByte == '-') {
                        token.append(currByte);
                    }
                    if (currByte == '\'' || currByte == '\"') {
                        token.append(currByte);
                        ++i;
                        while (i < charContent.length) {
                            char nextByte = charContent[i];
                            token.append(nextByte);
                            if (nextByte == currByte && !token.toString().endsWith("\\" + nextByte)) break;
                            ++i;
                        }
                        String comment = token.toString().replace("\\l", "").replace("\\", "");
                        this.tokens.add(new Token(comment, pos, line));
                        token.setLength(0);
                    }
                    if (currByte != '{' && currByte != '}' && currByte != '[' && currByte != ']' && currByte != '=' && currByte != ',' && currByte != ';' && currByte != ':') continue;
                    token.append(currByte);
                    this.tokens.add(new Token(token.toString(), pos, line));
                    token.setLength(0);
                    continue;
                }
                token.append(currByte);
            }
        }

        synchronized boolean hasNextToken() {
            return this.tokens.size() != 0;
        }

        synchronized String nextToken() {
            if (this.hasNextToken()) {
                return this.tokens.remove(0).getToken();
            }
            return null;
        }

        synchronized int getContentLength() {
            return this.content.length();
        }

        synchronized Token peekToken() {
            if (this.tokens.size() > 0) {
                return this.tokens.get(0);
            }
            return null;
        }

        synchronized String peekTokenString() {
            return this.peekTokenString(0);
        }

        synchronized String peekTokenString(int number) {
            if (this.tokens.size() > number) {
                return this.tokens.get(number).getToken();
            }
            return null;
        }

        private synchronized int getCurrentLineNumber() {
            if (this.tokens.size() > 0) {
                return this.tokens.get(0).getLine() + 1;
            }
            return -1;
        }

        private static class Token {
            private String token;
            private int pos;
            private int line;

            private Token(String token, int pos, int line) {
                this.token = token;
                this.pos = pos;
                this.line = line;
            }

            private String getToken() {
                return this.token;
            }

            private int getPos() {
                return this.pos;
            }

            private int getLine() {
                return this.line;
            }

            public String toString() {
                return this.token;
            }
        }
    }
}

