/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.decoder;

import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import vg.lib.decoder.GraphDecoder;
import vg.lib.decoder.dot.DotDecoder;
import vg.lib.decoder.gml.GMLDecoder;
import vg.lib.decoder.graphml.GraphMLDecoder;
import vg.lib.decoder.zip.ZipDecoder;
import vg.lib.storage.GraphStorage;

public class GraphDecoderFactory {
    public static final String GRAPHML_FORMAT = "graphml";
    public static final String GML_FORMAT = "gml";
    public static final String ZIP_FORMAT = "zip";
    public static final String DOT_FORMAT = "dot";
    public static final String GV_FORMAT = "gv";
    public static final List<String> SUPPORTED_FORMATS = List.of("graphml", "gml", "dot", "gv", "zip");

    public static GraphDecoder buildGraphDecoder(@NonNull String sourceType, @NonNull String graphName, @NonNull InputStream inputStream, @NonNull GraphStorage graphStorage) {
        if (sourceType == null) {
            throw new NullPointerException("sourceType is marked non-null but is null");
        }
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
        return switch (sourceType) {
            case GRAPHML_FORMAT -> new GraphMLDecoder(graphName, inputStream, graphStorage);
            case DOT_FORMAT, GV_FORMAT -> new DotDecoder(graphName, inputStream, graphStorage);
            case GML_FORMAT -> new GMLDecoder(graphName, inputStream, graphStorage);
            case ZIP_FORMAT -> new ZipDecoder(graphName, inputStream, graphStorage);
            default -> throw new IllegalArgumentException(String.format("Unsupported source type: %s.", sourceType));
        };
    }
}

