/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.decoder;

import java.io.InputStream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import vg.lib.progress.Progress;
import vg.lib.progress.ProgressImpl;
import vg.lib.storage.GraphStorage;

public abstract class GraphDecoder {
    protected String graphName;
    protected InputStream inputStream;
    protected GraphStorage graphStorage;
    protected final ProgressImpl progress;

    public GraphDecoder(@NonNull String graphName, @NonNull InputStream inputStream, @NonNull GraphStorage graphStorage) {
        if (graphName == null) {
            throw new NullPointerException("graphName is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (graphStorage == null) {
            throw new NullPointerException("graphStorage is marked non-null but is null");
        }
        this.graphName = graphName;
        this.inputStream = inputStream;
        this.graphStorage = graphStorage;
        this.progress = new ProgressImpl("Decoding ...");
    }

    public Progress getProgress() {
        return this.progress;
    }

    public abstract int decode() throws GraphDecoderException;

    protected String readID(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return token;
        }
        if (token.startsWith("\"") && token.endsWith("\"")) {
            token = token.substring(1).substring(0, token.length() - 2);
        }
        if (token.startsWith("'") && token.endsWith("'")) {
            token = token.substring(1).substring(0, token.length() - 2);
        }
        return token;
    }

    public static class GraphDecoderException
    extends Exception {
        public GraphDecoderException(String message) {
            super(message);
        }

        public GraphDecoderException(String message, Exception exception) {
            super(message, exception);
        }

        public GraphDecoderException(int lineNumber, String token, String expectedToken) {
            super("Can't parse following token: '" + token + "', expected token: '" + expectedToken + "', line number: " + lineNumber + ".");
        }

        public GraphDecoderException(Exception exception) {
            super(String.format("Can't decode input content. Original error: '%s'.", exception.getMessage()), exception);
        }
    }
}

