/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.config;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;

public class VGModifierKeyConfig {
    private static final VGModifierKeyConfig instance = new VGModifierKeyConfig();
    private volatile boolean ctrlPressed = false;
    private volatile boolean shiftPressed = false;
    private volatile boolean commandPressed = false;

    private VGModifierKeyConfig() {
        this.installGlobalListener();
    }

    private void installGlobalListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                boolean isPressed = keyEvent.getID() == 401;
                this.ctrlPressed = isPressed && keyEvent.isControlDown();
                this.shiftPressed = isPressed && keyEvent.isShiftDown();
                this.commandPressed = isPressed && keyEvent.isMetaDown();
            }
        }, 8L);
    }

    public static VGModifierKeyConfig getInstance() {
        return instance;
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed;
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    public boolean isCommandPressed() {
        return this.commandPressed;
    }
}

