/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.config;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.model.graphics.GraphModelAttributesMapping;
import vg.lib.model.graphics.VertexGraphics;

public class VGConfigSettings {
    private static final Logger log = LoggerFactory.getLogger(VGConfigSettings.class);
    public static final Color DEFAULT_VERTEX_COLOR = Color.decode("0xFFCC33");
    public static final Color DEFAULT_EDGE_COLOR = Color.decode("0x000000");
    public static final Color PORT_COLOR = new Color(252, 251, 227);
    public static final Color FAKE_PORT_COLOR = new Color(169, 169, 169);
    public static final Color[] COLORS = new Color[]{new Color(152, 251, 152), new Color(175, 238, 238), new Color(240, 230, 140), new Color(255, 182, 193)};
    public static final Color GRID_COLOR = new Color(189, 183, 107, 200);
    public static boolean DIAGNOSTIC_MODE = true;
    public static final String LOGO_IMAGE = "./data/resources/textures/help/logotip.png";
    public static final String ARROW_TOP_IMAGE = "./data/resources/textures/arrow_top.png";
    public static final String ARROW_BOTTOM_IMAGE = "./data/resources/textures/arrow_bottom.png";
    public static final String VERTEX_BOTTOM_IMAGE = "./data/resources/textures/vertex.png";
    public static final String EDGE_BOTTOM_IMAGE = "./data/resources/textures/edge.png";
    public static final String MATCH_CASE_BOTTOM_IMAGE = "./data/resources/textures/match_case.png";
    public static final String WORDS_BOTTOM_IMAGE = "./data/resources/textures/words.png";
    public static final String REGEX_BOTTOM_IMAGE = "./data/resources/textures/regex.png";
    public static final String UI_MONOSPACED_FONT_FAMILY = "Consolas";
    public static final String UI_STANDARD_FONT_FAMILY = "Courier";
    public static final String GRAPH_VIEW_FONT = "font/ubuntu-mono/UbuntuMono-R.ttf";
    public static final int GRAPH_VIEW_GRID_SIZE = 20;
    public static final int GRAPH_VIEW_EDGE_SCROLL_MARGIN = 20;
    public static final int GRAPH_VIEW_EDGE_SCROLL_TIMER = 30;
    public static final int GRAPH_VIEW_EDGE_SCROLL_SHIFT = 45;
    public static final int GRAPH_VIEW_DEFAULT_VERTEX_BORDER = 2;
    public static final int GRAPH_VIEW_DEFAULT_VERTEX_FONT_SIZE = 14;
    public static final int GRAPH_VIEW_DEFAULT_EDGE_FONT_SIZE = 10;
    public static final String GRAPH_VIEW_DEFAULT_VERTEX_COLOR = "#ffff00";
    public static final Color GRAPH_VIEW_VERTEX_DEFAULT_HIGHLIGHTING_COLOR = new Color(255, 80, 80);
    public static final Color GRAPH_VIEW_EDGE_DEFAULT_HIGHLIGHTING_COLOR = new Color(255, 80, 80);
    public static final Color GRAPH_VIEW_VERTEX_DEFAULT_SELECT_HIGHLIGHTING_COLOR = new Color(255, 80, 80);
    public static final Color GRAPH_VIEW_EDGE_DEFAULT_SELECT_HIGHLIGHTING_COLOR = new Color(255, 80, 80);
    public static final String GRAPH_VIEW_DEFAULT_VERTEX_SHAPE = VertexGraphics.ShapeType.RECTANGLE.name();
    public static final String GRAPH_VIEW_DEFAULT_VERTEX_VISIBLE_ATTRIBUTES_PATTERN = ".*";
    public static final String GRAPH_VIEW_DEFAULT_EDGE_VISIBLE_ATTRIBUTES_PATTERN = ".*";
    public static final Dimension GRAPH_VIEW_TILE_DIMENSION = new Dimension(500, 500);
    public static final Dimension GRAPH_VIEW_MAX_CANVAS_SIZE = new Dimension(50000, 50000);
    public static final int GRAPH_VIEW_CACHE_PADDING = 2500;
    public static final int GRAPH_VIEW_CACHE_TRIGGER_PADDING = 900;
    public static final GraphModelAttributesMapping GRAPH_VIEW_DEFAULT_GRAPH_MODEL_ATTRIBUTES_MAPPING = GraphModelAttributesMapping.builder().vertexShapeRules(List.of(GraphModelAttributesMapping.VertexShapeRule.builder().shapeType(VertexGraphics.ShapeType.DIAMOND).attributeName("shape").attributeValuePattern(".*Mdiamond.*").build(), GraphModelAttributesMapping.VertexShapeRule.builder().shapeType(VertexGraphics.ShapeType.DIAMOND).attributeName("shape").attributeValuePattern("^diamond.*").build(), GraphModelAttributesMapping.VertexShapeRule.builder().shapeType(VertexGraphics.ShapeType.CIRCLE).attributeName("shape").attributeValuePattern(".*Mcircle.*").build(), GraphModelAttributesMapping.VertexShapeRule.builder().shapeType(VertexGraphics.ShapeType.CIRCLE).attributeName("shape").attributeValuePattern("^circle.*").build())).vertexColorRules(List.of(GraphModelAttributesMapping.VertexColorRule.builder().attributeName("fillcolor").excludeColors(Set.of("#000000")).build(), GraphModelAttributesMapping.VertexColorRule.builder().attributeName("color").excludeColors(Set.of("#000000")).build())).build();
    public static final String GRAPH_VIEW_ATTRIBUTE_KEY_VALUE_DELIMITER = ":";
    public static final Point GRAPH_VIEW_DEFAULT_VERTEX_MIN_SIZE = new Point(21, 21);
    public static final Color DEFAULT_PANEL_BACKGROUND_COLOR = UIManager.getColor("Panel.background");
    private static final ConcurrentHashMap<String, Image> images = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ImageIcon> imageIcons = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Font> fonts = new ConcurrentHashMap();

    public static Image getImage(String resourcePath) {
        return images.computeIfAbsent(resourcePath, key -> {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);){
                if (is == null) {
                    log.error("Image '{}' was not found.", (Object)resourcePath);
                    Image image = null;
                    return image;
                }
                BufferedImage bufferedImage = ImageIO.read(is);
                return bufferedImage;
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        });
    }

    public static ImageIcon getImageIcon(String resourcePath) {
        return imageIcons.computeIfAbsent(resourcePath, key -> {
            Image image = VGConfigSettings.getImage(resourcePath);
            if (image == null) {
                return null;
            }
            return new ImageIcon(image);
        });
    }

    public static Font getFontResource(String resourcePath) {
        Font font = fonts.computeIfAbsent(resourcePath, key -> {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);){
                if (is == null) {
                    log.error("Resource '{}' was not found.", (Object)resourcePath);
                    Font font2 = null;
                    return font2;
                }
                Font font = Font.createFont(0, is);
                return font;
            }
            catch (FontFormatException | IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        });
        Validate.notNull((Object)font, (String)String.format("Font with path '%s' was not found.", resourcePath), (Object[])new Object[0]);
        return font;
    }
}

