/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vg.lib.model.graph.Attribute;
import vg.lib.model.record.AttributeRecord;

public class VGUtils {
    private static final Logger log = LoggerFactory.getLogger(VGUtils.class);

    public static Attribute convertToAttribute(AttributeRecord attributeRecord) {
        Validate.notNull((Object)attributeRecord);
        return new Attribute(attributeRecord.getName(), attributeRecord.getStringValue(), attributeRecord.getType(), attributeRecord.isVisible());
    }

    public static List<Attribute> convertToAttributes(List<AttributeRecord> attributeRecords) {
        Validate.notNull(attributeRecords);
        ArrayList result = Lists.newArrayList();
        for (AttributeRecord header : attributeRecords) {
            result.add(VGUtils.convertToAttribute(header));
        }
        return result;
    }
}

