/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.common;

import org.apache.commons.lang3.StringUtils;

public class TypeComparatorUtils {
    public static float flexibleDoubleComparison(double value1, double value2) {
        float diff;
        if (value1 < 0.0 && value2 < 0.0) {
            value1 = -value1;
            value2 = -value2;
        }
        if (value1 < 0.0 && value2 > 0.0) {
            value1 = -value1;
            value2 = value1 + value2;
        }
        if (value2 < 0.0 && value1 > 0.0) {
            value2 = -value2;
            value1 += value2;
        }
        if ((diff = (value1 += 1.0) > (value2 += 1.0) ? (float)(value2 / value1) : (float)(value1 / value2)) > 1.0f) {
            diff = 1.0f;
        }
        if (diff < 0.0f) {
            diff = 0.0f;
        }
        return diff;
    }

    public static float flexibleStringComparison(String value1, String value2) {
        int i;
        byte[] bytes2;
        if (value1 == null && value2 == null) {
            return 1.0f;
        }
        if (value1 == null || value2 == null) {
            return 0.0f;
        }
        if (value1.length() == 0 || value2.length() == 0) {
            return 1.0f;
        }
        byte[] bytes1 = value1.getBytes();
        if (bytes1.length > (bytes2 = value2.getBytes()).length) {
            byte[] tmp = bytes2;
            bytes2 = bytes1;
            bytes1 = tmp;
        }
        for (i = 0; i < bytes1.length && bytes1[i] == bytes2[i]; ++i) {
        }
        return (float)(2 * i) / (float)(bytes1.length + bytes2.length);
    }

    public static float strongDoubleComparison(double value1, double value2) {
        if (Double.compare(value1, value2) == 0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static float strongStringComparison(String value1, String value2) {
        return StringUtils.equals((CharSequence)value1, (CharSequence)value2) ? 1.0f : 0.0f;
    }
}

