/*
 * Decompiled with CFR 0.152.
 */
package vg.lib.common;

import java.util.List;

public class SplineInterpolator {
    private final List<Float> mX;
    private final List<Float> mY;
    private final float[] mM;

    private SplineInterpolator(List<Float> x, List<Float> y, float[] m) {
        this.mX = x;
        this.mY = y;
        this.mM = m;
    }

    public static SplineInterpolator createMonotoneCubicSpline(List<Float> x, List<Float> y) {
        int i;
        if (x == null || y == null || x.size() != y.size() || x.size() < 2) {
            throw new IllegalArgumentException("There must be at least two control points and the arrays must be of equal length.");
        }
        int n = x.size();
        float[] d = new float[n - 1];
        float[] m = new float[n];
        for (i = 0; i < n - 1; ++i) {
            float h = x.get(i + 1).floatValue() - x.get(i).floatValue();
            if (h <= 0.0f) {
                throw new IllegalArgumentException("The control points must all have strictly increasing X values.");
            }
            d[i] = (y.get(i + 1).floatValue() - y.get(i).floatValue()) / h;
        }
        m[0] = d[0];
        for (i = 1; i < n - 1; ++i) {
            m[i] = (d[i - 1] + d[i]) * 0.5f;
        }
        m[n - 1] = d[n - 2];
        for (i = 0; i < n - 1; ++i) {
            if (d[i] == 0.0f) {
                m[i] = 0.0f;
                m[i + 1] = 0.0f;
                continue;
            }
            float a = m[i] / d[i];
            float b = m[i + 1] / d[i];
            float h = (float)Math.hypot(a, b);
            if (!(h > 9.0f)) continue;
            float t = 3.0f / h;
            m[i] = t * a * d[i];
            m[i + 1] = t * b * d[i];
        }
        return new SplineInterpolator(x, y, m);
    }

    public float interpolate(float x) {
        int n = this.mX.size();
        if (Float.isNaN(x)) {
            return x;
        }
        if (x <= this.mX.get(0).floatValue()) {
            return this.mY.get(0).floatValue();
        }
        if (x >= this.mX.get(n - 1).floatValue()) {
            return this.mY.get(n - 1).floatValue();
        }
        int i = 0;
        while (x >= this.mX.get(i + 1).floatValue()) {
            if (x != this.mX.get(++i).floatValue()) continue;
            return this.mY.get(i).floatValue();
        }
        float h = this.mX.get(i + 1).floatValue() - this.mX.get(i).floatValue();
        float t = (x - this.mX.get(i).floatValue()) / h;
        return (this.mY.get(i).floatValue() * (1.0f + 2.0f * t) + h * this.mM[i] * t) * (1.0f - t) * (1.0f - t) + (this.mY.get(i + 1).floatValue() * (3.0f - 2.0f * t) + h * this.mM[i + 1] * (t - 1.0f)) * t * t;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        int n = this.mX.size();
        str.append("[");
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                str.append(", ");
            }
            str.append("(").append(this.mX.get(i));
            str.append(", ").append(this.mY.get(i));
            str.append(": ").append(this.mM[i]).append(")");
        }
        str.append("]");
        return str.toString();
    }
}

